/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import quadbase.common.util.internal.XMLConditionNode;
import quadbase.common.util.internal.XMLDefaultTreeNode;
import quadbase.common.util.internal.XMLFieldInfo;

public class XMLOperatorNode
extends XMLDefaultTreeNode {
    public static final int AND = 0;
    public static final int OR = 1;
    int op;

    public XMLOperatorNode(String name) {
        super(name);
    }

    public XMLOperatorNode(String name, int op) {
        super(name);
        this.op = op;
    }

    @Override
    public String getName() {
        return (String)this.getUserObject();
    }

    @Override
    public void setName(String name) {
        this.setUserObject(name);
    }

    public int getOp() {
        return this.op;
    }

    public void setOp(int opType) {
        this.op = opType;
    }

    @Override
    public boolean execute() {
        try {
            this.isExecutable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        XMLDefaultTreeNode node1 = this.getChildAt(0);
        XMLDefaultTreeNode node2 = this.getChildAt(1);
        try {
            if (this.op == 0) {
                return this.executeAndOperator(node1, node2);
            }
            if (this.op == 1) {
                return this.executeOrOperator(node1, node2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isExecutable() throws Exception {
        int childCt = this.getChildCount();
        if (childCt != 2) {
            throw new Exception("Operator has to have 2 children");
        }
        return true;
    }

    private boolean executeAndOperator(XMLDefaultTreeNode node1, XMLDefaultTreeNode node2) throws Exception {
        boolean b1 = this.executeNode(node1);
        if (!b1) {
            return false;
        }
        boolean b2 = this.executeNode(node2);
        return b2;
    }

    private boolean executeOrOperator(XMLDefaultTreeNode node1, XMLDefaultTreeNode node2) throws Exception {
        boolean b1 = this.executeNode(node1);
        if (b1) {
            return true;
        }
        boolean b2 = this.executeNode(node2);
        return b2;
    }

    private boolean executeNode(XMLDefaultTreeNode node) throws Exception {
        if (node instanceof XMLConditionNode) {
            return ((XMLConditionNode)node).execute();
        }
        if (node instanceof XMLOperatorNode) {
            return ((XMLOperatorNode)node).execute();
        }
        throw new Exception("ERROR in PROCESSING THE QUERY");
    }

    @Override
    public XMLFieldInfo getField(String paramName) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            XMLDefaultTreeNode child = this.getChildAt(i);
            XMLFieldInfo field = child.getField(paramName);
            if (field == null) continue;
            return field;
        }
        return null;
    }
}

