/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static final int ELEMENT_TYPE = 1;
    public static final int ATTR_TYPE = 2;
    public static final int TEXT_TYPE = 3;
    public static final int CDATA_TYPE = 4;
    public static final int ENTITYREF_TYPE = 5;
    public static final int ENTITY_TYPE = 6;
    public static final int PROCINSTR_TYPE = 7;
    public static final int COMMENT_TYPE = 8;
    public static final int DOCUMENT_TYPE = 9;
    public static final int DOCTYPE_TYPE = 10;
    public static final int DOCFRAG_TYPE = 11;
    public static final int NOTATION_TYPE = 12;

    public static String encodeXML(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static String readCDATA(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node cnode = nodeList.item(i);
            if (cnode.getNodeType() == 4) {
                return cnode.getNodeValue();
            }
            if (cnode.getNodeType() != 3) continue;
            return cnode.getNodeValue();
        }
        return "";
    }

    public static String readText(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node cnode = nodeList.item(i);
            if (cnode.getNodeType() != 3) continue;
            return cnode.getNodeValue();
        }
        return "";
    }

    public static boolean parseBoolean(String b) {
        return (b = b.trim()).equalsIgnoreCase("t") || b.equalsIgnoreCase("true") || b.equalsIgnoreCase("y") || b.equalsIgnoreCase("yes");
    }

    public static String encodeCDATA(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        return "<![CDATA[" + text + "]]>";
    }
}

