/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLVerifierHandler
implements ErrorHandler {
    private String xmlFile;
    private String schemaFile;
    private int type;
    private StringBuffer errors;

    public XMLVerifierHandler(String xmlFile, int type, String schemaFile) {
        this.xmlFile = xmlFile;
        this.type = type;
        this.schemaFile = schemaFile;
        xmlFile = xmlFile.replace('\\', '/');
        schemaFile = schemaFile.replace('\\', '/');
    }

    public String verify() {
        this.errors = new StringBuffer();
        if (this.type == 0) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setErrorHandler(this);
                InputSource is = new InputSource(this.xmlFile);
                is.setPublicId(this.schemaFile);
                reader.parse(is);
            }
            catch (Exception e) {
                return e.toString();
            }
        } else if (this.type == 1) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                Schema schema = this.schemaFile.indexOf("://") > 0 ? schemaFactory.newSchema(new URL(this.schemaFile)) : schemaFactory.newSchema(new File(this.schemaFile));
                Validator validator = schema.newValidator();
                validator.setErrorHandler(this);
                validator.validate(new SAXSource(new InputSource(this.xmlFile)));
            }
            catch (Exception e) {
                return e.toString();
            }
        } else {
            throw new IllegalArgumentException("Unknown schema type: " + this.type);
        }
        if (this.errors.length() > 0) {
            return this.errors.substring(0, this.errors.length() - 2);
        }
        return null;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.errors.append("** Warning **\n");
        this.errors.append(this.parseExceptionToString(e));
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errors.append("** Error **\n");
        this.errors.append(this.parseExceptionToString(e));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errors.append("** Fatal Error **\n");
        this.errors.append(this.parseExceptionToString(e));
    }

    private String parseExceptionToString(SAXParseException e) {
        return "Public ID: " + e.getPublicId() + "\nSystem ID: " + e.getSystemId() + "\nLine number: " + e.getLineNumber() + "\nColumn number: " + e.getColumnNumber() + "\nMessage: " + e.getMessage() + "\n\n";
    }
}

