/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import quadbase.awt.RotateText;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.Java2DUtil;
import quadbase.common.util.internal.QbGraphics;
import quadbase.reportdesigner.util.internal.ImageData;
import quadbase.util.internal.Composite;

public class ZoomGraphics
extends QbGraphics
implements IQbGraphics {
    Graphics g;
    Component component;
    Color foreground;
    Font font = new Font("Helvetica", 0, 12);
    float propx = 1.0f;
    float propy = 1.0f;
    int winWidth;
    int winHeight;
    Hashtable<Font, Font> fontTable;

    public ZoomGraphics(Graphics graphics, int w, int h, double propx, double propy) {
        this.g = graphics;
        this.propx = (float)propx;
        this.propy = (float)propy;
        this.winWidth = this.getW(w);
        this.winHeight = this.getH(h);
        this.fontTable = new Hashtable();
    }

    private int getX(int x) {
        return (int)Math.ceil((float)x * this.propx);
    }

    private int getY(int y) {
        return (int)Math.ceil((float)y * this.propy);
    }

    private int getW(int w) {
        return (int)Math.ceil((float)w * this.propx);
    }

    private int getH(int h) {
        return (int)Math.ceil((float)h * this.propy);
    }

    private int getRadius(int radius) {
        return (int)Math.ceil((float)radius * this.propx);
    }

    private float getX(float x) {
        return x * this.propx;
    }

    private float getY(float y) {
        return y * this.propy;
    }

    private float getW(float w) {
        return w * this.propx;
    }

    private float getH(float h) {
        return h * this.propy;
    }

    @Override
    public void done() throws Exception {
    }

    @Override
    public void setChartTab() {
    }

    @Override
    public void setTableTab() {
    }

    @Override
    public void setLegendTab() {
    }

    @Override
    public void setEndTab() {
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.g.clearRect(this.getX(x), this.getY(y), this.getW(width), this.getH(height));
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        System.err.println("clipRect not supported");
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.err.println("copyArea not supported");
    }

    @Override
    public Graphics create() {
        System.err.println("create not supported");
        return null;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        System.err.println("create not supported");
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(this.getX(x), this.getY(y), this.getW(width), this.getH(height), startAngle, arcAngle);
    }

    @Override
    public void drawImage(URL url, int option, int x, int y, int width, int height) {
        ImageData image = new ImageData(url, option);
        if (this.component == null) {
            this.component = IOUtil.getOffScreenComponent();
        }
        image.draw(this.g, this.getX(x), this.getY(y), this.getW(width), this.getH(height), (Object)this.component);
    }

    @Override
    public void drawImage(byte[] data, int option, int x, int y, int width, int height) {
        try {
            ImageData idata = new ImageData(new URL("http://temp"), option);
            Image i = Toolkit.getDefaultToolkit().createImage(data);
            idata.setImage(i);
            if (this.component == null) {
                this.component = IOUtil.getOffScreenComponent();
            }
            MediaTracker tracker = new MediaTracker(this.component);
            tracker.addImage(i, 0);
            tracker.waitForID(0);
            if (tracker.isErrorID(0)) {
                return;
            }
            idata.draw(this.g, this.getX(x), this.getY(y), this.getW(width), this.getH(height), (Object)this.component);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawLine2D(float x1, float y1, float x2, float y2) {
        if (this.g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.g;
            g2.draw(new Line2D.Float(this.getX(x1), this.getY(y1), this.getX(x2), this.getY(y2)));
        }
    }

    @Override
    public void drawArc2D(float x, float y, float w, float h, float start, float extent, int type) {
        if (this.g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.g;
            g2.draw(new Arc2D.Float(this.getX(x), this.getY(y), this.getX(w), this.getY(h), start, extent, type));
        }
    }

    @Override
    public void setBasicStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        if (this.g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.g;
            g2.setStroke(new BasicStroke(this.getW(width), cap, join, miterlimit, dash, dash_phase));
        }
    }

    @Override
    public void drawRoundRectangle(float x1, float y1, float x2, float y2, float rx, float ry) {
        if (this.g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.g;
            g2.draw(new RoundRectangle2D.Float(this.getX(x1), this.getY(y1), this.getX(x2), this.getY(y2), this.getX(rx), this.getY(ry)));
        }
    }

    @Override
    public void fillRoundRectangle(float x, float y, float w, float h, float r, float thickness, boolean drawTop, boolean drawBottom) {
        if (!(this.g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.g;
        x = this.getX(x);
        y = this.getY(y);
        float width = this.getW(w);
        float height = this.getH(h);
        Area rect = null;
        if (drawTop && drawBottom) {
            rect = new Area(new RoundRectangle2D.Float(x, y, width, height, 2.0f * r - thickness, 2.0f * r - thickness));
        } else {
            Area rect2;
            if (drawTop) {
                rect = new Area(new RoundRectangle2D.Float(x, y, width, height + r, 2.0f * r - thickness, 2.0f * r - thickness));
                rect2 = new Area(new RoundRectangle2D.Float(x, y - r, width, r, 0.0f, 0.0f));
                rect.subtract(rect2);
            }
            if (drawBottom) {
                rect = new Area(new RoundRectangle2D.Float(x, y - r, width, height + r, 2.0f * r - thickness, 2.0f * r - thickness));
                rect2 = new Area(new RoundRectangle2D.Float(x, y - r, width, r, 0.0f, 0.0f));
                rect.subtract(rect2);
            }
            if (!drawTop && !drawBottom) {
                rect = new Area(new RoundRectangle2D.Float(x, y, width, height, 0.0f, 0.0f));
            }
        }
        if (rect != null) {
            g2.fill(rect);
        }
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    @Override
    public void setCompositeSrcOver(float alpha) {
        if (IOUtil.isJava2D()) {
            Composite.setCompositeSrcOver(this.g, alpha);
        }
    }

    @Override
    public void setOriginalComposite() {
        if (IOUtil.isJava2D()) {
            Composite.setOriginalComposite(this.g);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(this.getX(x1), this.getY(y1), this.getX(x2), this.getY(y2));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(this.getX(x), this.getY(y), this.getW(width), this.getH(height));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int i;
        int[] nxPoints = new int[xPoints.length];
        int[] nyPoints = new int[yPoints.length];
        for (i = 0; i < xPoints.length; ++i) {
            nxPoints[i] = this.getX(xPoints[i]);
        }
        for (i = 0; i < yPoints.length; ++i) {
            nyPoints[i] = this.getY(yPoints[i]);
        }
        this.g.drawPolygon(nxPoints, nyPoints, nPoints);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        int i;
        int[] nxPoints = new int[xPoints.length];
        int[] nyPoints = new int[yPoints.length];
        for (i = 0; i < xPoints.length; ++i) {
            nxPoints[i] = this.getX(xPoints[i]);
        }
        for (i = 0; i < yPoints.length; ++i) {
            nyPoints[i] = this.getY(yPoints[i]);
        }
        this.g.drawPolyline(nxPoints, nyPoints, nPoints);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(this.getX(x), this.getY(y), this.getX(width), this.getY(height));
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.draw3DRect(this.getX(x), this.getY(y), this.getX(width), this.getY(height), raised);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(this.getX(x), this.getY(y), this.getW(width), this.getH(height), arcWidth, arcHeight);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.g.drawString(str, this.getX(x), this.getY(y));
    }

    @Override
    public void drawString(String str3, int xPt1, int wPt1, short align, int yPt1, boolean drawUnderline) {
        xPt1 = this.getX(xPt1);
        wPt1 = this.getW(wPt1);
        yPt1 = this.getY(yPt1);
        FontMetrics fm = this.g.getFontMetrics(this.g.getFont());
        int strW = fm.stringWidth(str3);
        xPt1 = this.getStringX(strW, xPt1, wPt1, align);
        this.g.drawString(str3, xPt1, yPt1);
        if (drawUnderline && !str3.trim().equals("")) {
            int underLineY = yPt1 + fm.getDescent();
            this.g.drawLine(xPt1, underLineY, strW + xPt1, underLineY);
        }
    }

    @Override
    public void drawSegment(Object[] segment, int xPt2, int yPt2) {
        try {
            xPt2 = this.getX(xPt2);
            yPt2 = this.getY(yPt2);
            for (Object element : segment) {
                Object[] seg = (Object[])element;
                if (seg.length == 4) {
                    String sStr = (String)seg[0];
                    this.g.setFont(this.calcFont(seg[1], this.g));
                    this.g.setColor((Color)seg[2]);
                    boolean drawUnline = (Boolean)seg[3];
                    this.g.setFont(this.g.getFont());
                    FontMetrics fm1 = this.g.getFontMetrics(this.g.getFont());
                    int strW2 = fm1.stringWidth(sStr);
                    this.g.drawString(sStr, xPt2, yPt2);
                    if (drawUnline && !sStr.trim().equals("")) {
                        int underLineY = yPt2 + fm1.getDescent();
                        this.g.drawLine(xPt2, underLineY, strW2 + xPt2, underLineY);
                    }
                    xPt2 += strW2;
                    continue;
                }
                byte[] sImg = (byte[])seg[0];
                int sW = this.calcWidth(seg[1]);
                int sH = this.calcHeight(seg[2]);
                if (sImg != null) {
                    ImageData idata2 = new ImageData(new URL("http://temp"), 1);
                    Image im = Toolkit.getDefaultToolkit().createImage(sImg);
                    idata2.setImage(im);
                    if (this.component == null) {
                        this.component = IOUtil.getOffScreenComponent();
                    }
                    MediaTracker tracker2 = new MediaTracker(this.component);
                    tracker2.addImage(im, 0);
                    tracker2.waitForID(0);
                    if (!tracker2.isErrorID(0)) {
                        idata2.draw(this.g, xPt2, yPt2 - sH, sW, sH, (Object)this.component);
                    }
                }
                xPt2 += sW;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void drawRotateString(String str, Font font, boolean isJ2DRotate, Color color, float angle, int x, int y) {
        x = this.getX(x);
        y = this.getY(y);
        if (this.component == null) {
            this.component = IOUtil.getOffScreenComponent();
        }
        RotateText rText = new RotateText(str, this.component, angle);
        rText.setFont(font);
        rText.setJava2DRotateTextEnabled(isJ2DRotate);
        rText.setColor(color);
        rText.prepareImage(this.g);
        rText.setPos(x, y);
        rText.draw(this.g);
    }

    @Override
    public void drawRotateString2(String text, Font font, Color color, int x, int y, int w, int h, short align, short valign, boolean isUnderline, double rotation, int length, int index) {
        Java2DUtil.drawRotateString(this, x, y, w, h, align, valign, isUnderline, rotation, font, text, length, index);
    }

    @Override
    public void drawString(AttributedCharacterIterator text, int x, int y) {
        System.err.println("drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(this.getX(x), this.getY(y), this.getW(width), this.getH(height), startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(this.getX(x), this.getY(y), this.getW(width), this.getH(height));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int i;
        int[] nxPoints = new int[xPoints.length];
        int[] nyPoints = new int[yPoints.length];
        for (i = 0; i < xPoints.length; ++i) {
            nxPoints[i] = this.getX(xPoints[i]);
        }
        for (i = 0; i < yPoints.length; ++i) {
            nyPoints[i] = this.getY(yPoints[i]);
        }
        this.g.fillPolygon(nxPoints, nyPoints, nPoints);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(this.getX(x), this.getY(y), this.getW(width), this.getH(height));
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.g.fill3DRect(this.getX(x), this.getY(y), this.getW(width), this.getH(height), raised);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(this.getX(x), this.getY(y), this.getW(width), this.getH(height), this.getW(arcWidth), this.getH(arcHeight));
    }

    @Override
    public Shape getClip() {
        return this.g.getClip();
    }

    @Override
    public Rectangle getClipRect() {
        System.err.println("getClipRect not supported");
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        System.err.println("getClipBounds not supported");
        return null;
    }

    @Override
    public Color getColor() {
        return this.foreground;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(this.getX(x), this.getY(y), this.getW(width), this.getH(height));
    }

    @Override
    public void setClip(Shape clip) {
        this.g.setClip(clip);
    }

    @Override
    public void setColor(Color newcolor) {
        this.foreground = newcolor;
        this.g.setColor(newcolor);
    }

    @Override
    public void setFont(Font newfont) {
        try {
            this.font = this.calcFont(newfont, this.g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.g.setFont(this.font);
    }

    @Override
    public void setPaintMode() {
        System.err.println("setPaintMode not supported");
    }

    @Override
    public void setXORMode(Color c1) {
        System.err.println("setXORMode not supported");
    }

    @Override
    public void translate(int x, int y) {
        this.g.translate(this.getX(x), this.getY(y));
    }

    private int getStringX(int strLen, int x, int w, short align) {
        switch (align) {
            case 2: {
                return x + w - strLen;
            }
            case 0: {
                return x + (int)Math.rint((double)(w - strLen) / 2.0);
            }
        }
        return x;
    }

    private int calcWidth(Object xPt) {
        float tmp = Float.valueOf(xPt.toString()).floatValue();
        return (int)Math.rint(tmp * this.propx);
    }

    private int calcHeight(Object yPt) {
        float tmp = Float.valueOf(yPt.toString()).floatValue();
        return (int)Math.rint(tmp * this.propy);
    }

    private Font calcFont(Object font, Graphics g) throws Exception {
        return this.resizeFont(g, (Font)font);
    }

    Font resizeFont(Graphics g, Font font) {
        if (this.propx == 1.0f || g == null) {
            return font;
        }
        Font newFont = this.fontTable.get(font);
        if (newFont != null) {
            return newFont;
        }
        String text = "mibrelts ESa";
        double printToScreenRatio = this.propx;
        if (printToScreenRatio == 1.0) {
            this.fontTable.put(font, font);
            return font;
        }
        FontMetrics fm = g.getFontMetrics(font);
        int orgWidth = fm.stringWidth(text);
        double newWidth = (double)orgWidth * printToScreenRatio;
        newFont = FontTable.newFont(font.getName(), font.getStyle(), font.getSize());
        if (printToScreenRatio < 1.0) {
            while ((double)orgWidth > newWidth && newFont.getSize() > 1) {
                newFont = FontTable.newFont(newFont.getName(), newFont.getStyle(), newFont.getSize() - 1);
                fm = g.getFontMetrics(newFont);
                orgWidth = fm.stringWidth(text);
            }
        } else {
            Font testFont = newFont;
            while ((double)orgWidth < newWidth) {
                newFont = testFont;
                testFont = FontTable.newFont(newFont.getName(), newFont.getStyle(), newFont.getSize() + 1);
                fm = g.getFontMetrics(testFont);
                orgWidth = fm.stringWidth(text);
            }
        }
        this.fontTable.put(font, newFont);
        return newFont;
    }

    @Override
    public void drawCellWithRoundCornersBySegments(float rX, float rY, int roundCornerRadius, boolean[] roundCornersArray, float rW, float rH, Color borderColor, Color bgColor, int gridStyle, boolean drawTop, boolean drawBottom, float[] borderThickness) throws Exception {
        Java2DUtil.drawCellWithRoundCornersBySegments((Graphics2D)this.g, this.getX(rX), this.getY(rY), this.getRadius(roundCornerRadius), roundCornersArray, this.getW(rW), this.getH(rH), borderColor, bgColor, gridStyle, true, drawTop, drawBottom, borderThickness);
    }
}

