/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.ElementListener;
import quadbase.common.util.output.ElementTags;
import quadbase.common.util.output.Font;
import quadbase.common.util.output.FontFactory;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.MarkupAttributes;
import quadbase.common.util.output.SplitCharacter;
import quadbase.common.util.output.markup.MarkupParser;
import quadbase.common.util.output.pdf.HyphenationEvent;
import quadbase.common.util.output.pdf.PdfAction;
import quadbase.common.util.output.pdf.PdfAnnotation;

public class Chunk
implements Element,
MarkupAttributes {
    public static final String OBJECT_REPLACEMENT_CHARACTER = "\ufffc";
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String STRIKETHRU = "STRIKETHRU";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String IMAGE = "IMAGE";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String SPLITCHARACTER = "SPLITCHARACTER";
    public static final String ACTION = "ACTION";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String PDFANNOTATION = "PDFANNOTATION";
    public static final String HYPHENATION = "HYPHENATION";
    public static final String TEXTRENDERMODE = "TEXTRENDERMODE";
    public static final String SKEW = "SKEW";
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap attributes = null;
    protected Properties markupAttributes = null;

    protected Chunk() {
    }

    public Chunk(String content, Font font) {
        this.content = new StringBuffer(content);
        this.font = font;
    }

    public Chunk(String content) {
        this(content, new Font());
    }

    public Chunk(char c, Font font) {
        this.content = new StringBuffer();
        this.content.append(c);
        this.font = font;
    }

    public Chunk(char c) {
        this(c, new Font());
    }

    public Chunk(Image image, float offsetX, float offsetY) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        Image copyImage = Image.getInstance(image);
        copyImage.setAbsolutePosition(Float.NaN, Float.NaN);
        this.setAttribute(IMAGE, new Object[]{copyImage, Float.valueOf(offsetX), Float.valueOf(offsetY), Boolean.FALSE});
    }

    public Chunk(Image image, float offsetX, float offsetY, boolean changeLeading) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.setAttribute(IMAGE, new Object[]{image, Float.valueOf(offsetX), Float.valueOf(offsetY), changeLeading});
    }

    public Chunk(Properties attributes) {
        this("", FontFactory.getFont(attributes));
        String value = (String)attributes.remove("itext");
        if (value != null) {
            this.append(value);
        }
        if ((value = (String)attributes.remove(ElementTags.LOCALGOTO)) != null) {
            this.setLocalGoto(value);
        }
        if ((value = (String)attributes.remove(ElementTags.REMOTEGOTO)) != null) {
            String destination = (String)attributes.remove(ElementTags.DESTINATION);
            String page = (String)attributes.remove(ElementTags.PAGE);
            if (page != null) {
                this.setRemoteGoto(value, Integer.valueOf(page));
            } else if (destination != null) {
                this.setRemoteGoto(value, destination);
            }
        }
        if ((value = (String)attributes.remove(ElementTags.LOCALDESTINATION)) != null) {
            this.setLocalDestination(value);
        }
        if ((value = (String)attributes.remove(ElementTags.SUBSUPSCRIPT)) != null) {
            this.setTextRise(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("vertical-align")) != null && value.endsWith("%")) {
            float p = Float.valueOf(value.substring(0, value.length() - 1) + "f").floatValue() / 100.0f;
            this.setTextRise(p * this.font.size());
        }
        if ((value = (String)attributes.remove(ElementTags.GENERICTAG)) != null) {
            this.setGenericTag(value);
        }
        if ((value = (String)attributes.remove("backgroundcolor")) != null) {
            this.setBackground(MarkupParser.decodeColor((String)value));
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 10;
    }

    @Override
    public ArrayList getChunks() {
        ArrayList<Chunk> tmp = new ArrayList<Chunk>();
        tmp.add(this);
        return tmp;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public Font font() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String content() {
        return this.content.toString();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf(10) == -1 && this.attributes == null;
    }

    public Chunk setTextRise(float rise) {
        return this.setAttribute(SUBSUPSCRIPT, Float.valueOf(rise));
    }

    public Chunk setTextRenderMode(int mode, float strokeWidth, Color strokeColor) {
        return this.setAttribute(TEXTRENDERMODE, new Object[]{mode, Float.valueOf(strokeWidth), strokeColor});
    }

    public Chunk setSkew(float alpha, float beta) {
        alpha = (float)Math.tan((double)alpha * Math.PI / 180.0);
        beta = (float)Math.tan((double)beta * Math.PI / 180.0);
        return this.setAttribute(SKEW, new float[]{alpha, beta});
    }

    public Chunk setAction(PdfAction action) {
        return this.setAttribute(ACTION, action);
    }

    public Chunk setAnchor(URL url) {
        return this.setAttribute(ACTION, new PdfAction(url.toExternalForm()));
    }

    public Chunk setAnchor(String url) {
        return this.setAttribute(ACTION, new PdfAction(url));
    }

    public Chunk setLocalGoto(String name) {
        return this.setAttribute(LOCALGOTO, name);
    }

    public Chunk setBackground(Color color) {
        return this.setAttribute(BACKGROUND, color);
    }

    public Chunk setAnnotation(PdfAnnotation annotation) {
        return this.setAttribute(PDFANNOTATION, annotation);
    }

    public Chunk setHyphenation(HyphenationEvent hyphenation) {
        return this.setAttribute(HYPHENATION, hyphenation);
    }

    public Chunk setRemoteGoto(String filename, String name) {
        return this.setAttribute(REMOTEGOTO, new Object[]{filename, name});
    }

    public Chunk setRemoteGoto(String filename, int page) {
        return this.setAttribute(REMOTEGOTO, new Object[]{filename, page});
    }

    public Chunk setLocalDestination(String name) {
        return this.setAttribute(LOCALDESTINATION, name);
    }

    public Chunk setGenericTag(String text) {
        return this.setAttribute(GENERICTAG, text);
    }

    public Chunk setSplitCharacter(SplitCharacter splitCharacter) {
        return this.setAttribute(SPLITCHARACTER, splitCharacter);
    }

    public Chunk setNewPage() {
        return this.setAttribute(NEWPAGE, null);
    }

    private Chunk setAttribute(String name, Object obj) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, obj);
        return this;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] obj = (Object[])this.attributes.get(IMAGE);
        if (obj == null) {
            return null;
        }
        return (Image)obj[0];
    }

    public static boolean isTag(String tag) {
        return "chunk".equals(tag);
    }

    @Override
    public void setMarkupAttribute(String name, String value) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(name, value);
    }

    @Override
    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    @Override
    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    @Override
    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    @Override
    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public static Set getKeySet(Hashtable table) {
        return table == null ? Collections.EMPTY_SET : table.keySet();
    }
}

