/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import quadbase.common.util.output.BadElementException;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.Image;

public class Gif
extends Image
implements Element {
    Gif(Image image) {
        super(image);
    }

    public Gif(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    @Deprecated
    public Gif(URL url, float width, float height) throws BadElementException, IOException {
        this(url);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    @Deprecated
    public Gif(String filename) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename));
    }

    @Deprecated
    public Gif(String filename, float width, float height) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename), width, height);
    }

    public Gif(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.processParameters();
    }

    public Gif(byte[] img, float width, float height) throws BadElementException, IOException {
        this(img);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    private void processParameters() throws BadElementException, IOException {
        this.type = 31;
        InputStream is = null;
        try {
            String errorID;
            if (this.rawData == null) {
                is = this.url.openStream();
                errorID = this.url.toString();
            } else {
                is = new ByteArrayInputStream(this.rawData);
                errorID = "Byte array";
            }
            if (is.read() != 71 || is.read() != 73 || is.read() != 70) {
                throw new BadElementException(errorID + " is not a valid GIF-file.");
            }
            Gif.skip(is, 3);
            this.scaledWidth = is.read() + (is.read() << 8);
            this.setRight(this.scaledWidth);
            this.scaledHeight = is.read() + (is.read() << 8);
            this.setTop(this.scaledHeight);
        }
        finally {
            if (is != null) {
                is.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }
}

