/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.util.Properties;
import quadbase.common.util.output.Chunk;
import quadbase.common.util.output.ElementTags;
import quadbase.common.util.output.Font;
import quadbase.common.util.output.FontFactory;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.List;
import quadbase.common.util.output.MarkupAttributes;
import quadbase.common.util.output.Phrase;
import quadbase.common.util.output.TextElementArray;
import quadbase.common.util.output.markup.MarkupParser;

public class Paragraph
extends Phrase
implements TextElementArray,
MarkupAttributes {
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    protected boolean keeptogether = false;

    public Paragraph() {
    }

    public Paragraph(float leading) {
        super(leading);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float leading, String string) {
        super(leading, string);
    }

    public Paragraph(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading, "", phrase.font());
        super.add(phrase);
    }

    public Paragraph(Properties attributes) {
        this("", FontFactory.getFont(attributes));
        String value = (String)attributes.remove("itext");
        if (value != null) {
            Chunk chunk = new Chunk(value);
            value = (String)attributes.remove(ElementTags.GENERICTAG);
            if (value != null) {
                chunk.setGenericTag(value);
            }
            this.add(chunk);
        }
        if ((value = (String)attributes.remove("align")) != null) {
            this.setAlignment(value);
        }
        if ((value = (String)attributes.remove("leading")) != null) {
            this.setLeading(Float.valueOf(value + "f").floatValue());
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(MarkupParser.parseLength((String)value));
            } else {
                this.setLeading(16.0f);
            }
        }
        value = (String)attributes.remove("indentationleft");
        if (value != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("keeptogether")) != null) {
            this.keeptogether = Boolean.valueOf(value);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    @Override
    public int type() {
        return 12;
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (o instanceof Image) {
            super.addSpecial(o);
            return true;
        }
        if (o instanceof Paragraph) {
            super.add(o);
            super.add(Chunk.NEWLINE);
            return true;
        }
        return super.add(o);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setAlignment(String alignment) {
        if ("Center".equalsIgnoreCase(alignment)) {
            this.alignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(alignment)) {
            this.alignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(alignment)) {
            this.alignment = 3;
            return;
        }
        this.alignment = 0;
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setKeepTogether(boolean keeptogether) {
        this.keeptogether = keeptogether;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int alignment() {
        return this.alignment;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isTag(String tag) {
        return "paragraph".equals(tag);
    }
}

