/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import quadbase.common.util.output.Chunk;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.ElementListener;
import quadbase.common.util.output.ElementTags;
import quadbase.common.util.output.Font;
import quadbase.common.util.output.FontFactory;
import quadbase.common.util.output.Greek;
import quadbase.common.util.output.MarkupAttributes;
import quadbase.common.util.output.TextElementArray;
import quadbase.common.util.output.markup.MarkupParser;

public class Phrase
extends ArrayList
implements TextElementArray,
MarkupAttributes {
    protected float leading = Float.NaN;
    protected Font font = new Font();
    protected Properties markupAttributes;

    public Phrase() {
        this(16.0f);
    }

    public Phrase(float leading) {
        this.leading = leading;
    }

    public Phrase(Chunk chunk) {
        super.add(chunk);
    }

    public Phrase(float leading, Chunk chunk) {
        this(leading);
        super.add(chunk);
    }

    public Phrase(String string) {
        this(Float.NaN, string, new Font());
    }

    public Phrase(String string, Font font) {
        this(Float.NaN, string, font);
        this.font = font;
    }

    public Phrase(float leading, String string) {
        this(leading, string, new Font());
    }

    public Phrase(float leading, String string, Font font) {
        this(leading);
        this.font = font;
        if (font.family() != 3 && font.family() != 4 && font.getBaseFont() == null) {
            int index;
            while ((index = Greek.index(string)) > -1) {
                if (index > 0) {
                    String firstPart = string.substring(0, index);
                    super.add(new Chunk(firstPart, font));
                    string = string.substring(index);
                }
                Font symbol = new Font(3, font.size(), font.style(), font.color());
                StringBuffer buf = new StringBuffer();
                buf.append(Greek.getCorrespondingSymbol(string.charAt(0)));
                string = string.substring(1);
                while (Greek.index(string) == 0) {
                    buf.append(Greek.getCorrespondingSymbol(string.charAt(0)));
                    string = string.substring(1);
                }
                super.add(new Chunk(buf.toString(), symbol));
            }
        }
        if (string.length() != 0) {
            super.add(new Chunk(string, font));
        }
    }

    public Phrase(Properties attributes) {
        this("", FontFactory.getFont(attributes));
        this.clear();
        String value = (String)attributes.remove("leading");
        if (value != null) {
            this.setLeading(Float.valueOf(value + "f").floatValue());
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(MarkupParser.parseLength((String)value));
            }
        }
        value = (String)attributes.remove("itext");
        if (value != null) {
            Chunk chunk = new Chunk(value);
            value = (String)attributes.remove(ElementTags.GENERICTAG);
            if (value != null) {
                chunk.setGenericTag(value);
            }
            this.add(chunk);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                listener.add((Element)i.next());
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 11;
    }

    @Override
    public ArrayList getChunks() {
        ArrayList tmp = new ArrayList();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            tmp.addAll(((Element)i.next()).getChunks());
        }
        return tmp;
    }

    @Override
    public void add(int index, Object o) {
        block5: {
            try {
                Element element = (Element)o;
                if (element.type() == 10) {
                    Chunk chunk = (Chunk)element;
                    if (!this.font.isStandardFont()) {
                        chunk.setFont(this.font.difference(chunk.font()));
                    }
                    super.add(index, chunk);
                    break block5;
                }
                if (element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 39) {
                    super.add(index, element);
                    break block5;
                }
                throw new ClassCastException(String.valueOf(element.type()));
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("Insertion of illegal Element: " + cce.getMessage());
            }
        }
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof String) {
            return super.add(new Chunk((String)o, this.font));
        }
        try {
            Element element = (Element)o;
            switch (element.type()) {
                case 10: {
                    return this.addChunk((Chunk)o);
                }
                case 11: 
                case 12: {
                    Phrase phrase = (Phrase)o;
                    boolean success = true;
                    for (Element e : phrase) {
                        if (e instanceof Chunk) {
                            success &= this.addChunk((Chunk)e);
                            continue;
                        }
                        success &= this.add(e);
                    }
                    return success;
                }
                case 17: {
                    return super.add(o);
                }
                case 29: {
                    return super.add(o);
                }
                case 22: {
                    return super.add(o);
                }
                case 14: {
                    return super.add(o);
                }
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Insertion of illegal Element: " + cce.getMessage());
        }
    }

    private synchronized boolean addChunk(Chunk chunk) {
        if (!this.font.isStandardFont()) {
            chunk.setFont(this.font.difference(chunk.font()));
        }
        if (this.size() > 0 && !chunk.hasAttributes()) {
            try {
                Chunk previous = (Chunk)this.get(this.size() - 1);
                if (!(previous.hasAttributes() || previous.font().compareTo(chunk.font()) != 0 || "".equals(previous.content().trim()) || "".equals(chunk.content().trim()))) {
                    previous.append(chunk.content());
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return super.add(chunk);
    }

    @Override
    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    protected void addSpecial(Object object) {
        super.add(object);
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    @Override
    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.get(0);
                return element.type() == 10 && ((Chunk)element).isEmpty();
            }
        }
        return false;
    }

    public boolean leadingDefined() {
        return !Float.isNaN(this.leading);
    }

    public float leading() {
        if (Float.isNaN(this.leading)) {
            return this.font.leading(1.5f);
        }
        return this.leading;
    }

    public Font font() {
        return this.font;
    }

    public static boolean isTag(String tag) {
        return "phrase".equals(tag);
    }

    @Override
    public void setMarkupAttribute(String name, String value) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(name, value);
    }

    @Override
    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    @Override
    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    @Override
    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    @Override
    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

