/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfString;

public class FdfReader
extends PdfReader {
    HashMap fields;
    String fileSpec;

    public FdfReader(String filename) throws IOException {
        super(filename);
    }

    public FdfReader(byte[] pdfIn) throws IOException {
        super(pdfIn);
    }

    public FdfReader(URL url) throws IOException {
        super(url);
    }

    @Override
    protected void readPdf() throws IOException {
        this.fields = new HashMap();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
        this.readFields();
    }

    protected void kidNode(PdfDictionary merged, String name) {
        PdfArray kids = (PdfArray)FdfReader.getPdfObject(merged.get(PdfName.KIDS));
        if (kids == null || kids.getArrayList().size() == 0) {
            if (name.length() > 0) {
                name = name.substring(1);
            }
            this.fields.put(name, merged);
        } else {
            merged.remove(PdfName.KIDS);
            ArrayList ar = kids.getArrayList();
            for (int k = 0; k < ar.size(); ++k) {
                PdfDictionary dic = new PdfDictionary();
                dic.merge(merged);
                PdfDictionary newDic = (PdfDictionary)FdfReader.getPdfObject((PdfObject)ar.get(k));
                PdfString t = (PdfString)FdfReader.getPdfObject(newDic.get(PdfName.T));
                String newName = name;
                if (t != null) {
                    newName = newName + "." + t.toUnicodeString();
                }
                dic.merge(newDic);
                dic.remove(PdfName.T);
                this.kidNode(dic, newName);
            }
        }
    }

    protected void readFields() throws IOException {
        PdfArray fld;
        this.catalog = (PdfDictionary)FdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary fdf = (PdfDictionary)FdfReader.getPdfObject(this.catalog.get(PdfName.FDF));
        PdfString fs = (PdfString)FdfReader.getPdfObject(fdf.get(PdfName.F));
        if (fs != null) {
            this.fileSpec = fs.toUnicodeString();
        }
        if ((fld = (PdfArray)FdfReader.getPdfObject(fdf.get(PdfName.FIELDS))) == null) {
            return;
        }
        PdfDictionary merged = new PdfDictionary();
        merged.put(PdfName.KIDS, fld);
        this.kidNode(merged, "");
    }

    public HashMap getFields() {
        return this.fields;
    }

    public PdfDictionary getField(String name) {
        return (PdfDictionary)this.fields.get(name);
    }

    public String getFieldValue(String name) {
        PdfDictionary field = (PdfDictionary)this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfObject v = FdfReader.getPdfObject(field.get(PdfName.V));
        if (v == null) {
            return null;
        }
        if (v.type() == 4) {
            return PdfName.decodeName(((PdfName)v).toString());
        }
        if (v.type() == 3) {
            return ((PdfString)v).toUnicodeString();
        }
        return null;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

