/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import quadbase.common.util.output.DocWriter;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.pdf.AcroFields;
import quadbase.common.util.output.pdf.FdfReader;
import quadbase.common.util.output.pdf.PRAcroForm;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfDocument;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfString;
import quadbase.common.util.output.pdf.PdfWriter;

public class FdfWriter {
    static byte[] HEADER_FDF = DocWriter.getISOBytes("%FDF-1.2\n%\u00e2\u00e3\u00cf\u00d3\n");
    HashMap fields = new HashMap();
    private String file;

    public void writeTo(OutputStream os) throws DocumentException, IOException {
        Wrt wrt = new Wrt(os);
        wrt.writeTo();
    }

    boolean setField(String field, PdfObject value) {
        Object obj;
        String s;
        HashMap map;
        block4: {
            map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            while (true) {
                s = tk.nextToken();
                obj = map.get(s);
                if (!tk.hasMoreTokens()) break block4;
                if (obj == null) {
                    obj = new HashMap();
                    map.put(s, obj);
                    map = (HashMap)obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return false;
        }
        if (obj == null || !(obj instanceof HashMap)) {
            map.put(s, value);
            return true;
        }
        return false;
    }

    void iterateFields(HashMap values, HashMap map, String name) {
        for (String s : map.keySet()) {
            Object obj = map.get(s);
            if (obj instanceof HashMap) {
                this.iterateFields(values, (HashMap)obj, name + "." + s);
                continue;
            }
            values.put((name + "." + s).substring(1), obj);
        }
    }

    public boolean removeField(String field) {
        Object obj;
        ArrayList<Object> hist;
        HashMap map;
        block5: {
            map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            hist = new ArrayList<Object>();
            while (true) {
                String s;
                if ((obj = map.get(s = tk.nextToken())) == null) {
                    return false;
                }
                hist.add(map);
                hist.add(s);
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return false;
        }
        if (obj instanceof HashMap) {
            return false;
        }
        for (int k = hist.size() - 2; k >= 0; k -= 2) {
            map = (HashMap)hist.get(k);
            String s = (String)hist.get(k + 1);
            map.remove(s);
            if (map.size() > 0) break;
        }
        return true;
    }

    public HashMap getFields() {
        HashMap values = new HashMap();
        this.iterateFields(values, this.fields, "");
        return values;
    }

    public String getField(String field) {
        Object obj;
        block5: {
            HashMap map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return null;
            }
            while (true) {
                String s;
                if ((obj = map.get(s = tk.nextToken())) == null) {
                    return null;
                }
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return null;
        }
        if (obj instanceof HashMap) {
            return null;
        }
        if (((PdfObject)obj).type() == 3) {
            return ((PdfString)obj).toUnicodeString();
        }
        return PdfName.decodeName(obj.toString());
    }

    public boolean setFieldAsName(String field, String value) {
        return this.setField(field, new PdfName(value));
    }

    public boolean setFieldAsString(String field, String value) {
        return this.setField(field, new PdfString(value, "UnicodeBig"));
    }

    public void setFields(FdfReader fdf) {
        HashMap map = fdf.getFields();
        for (String key : map.keySet()) {
            PdfDictionary dic = (PdfDictionary)map.get(key);
            PdfObject v = dic.get(PdfName.V);
            if (v == null) continue;
            this.setField(key, v);
        }
    }

    public void setFields(PdfReader pdf) {
        PRAcroForm acro = pdf.getAcroForm();
        ArrayList f = acro.getFields();
        for (int k = 0; k < f.size(); ++k) {
            PRAcroForm.FieldInformation inf = (PRAcroForm.FieldInformation)f.get(k);
            PdfObject obj = inf.getInfo().get(PdfName.V);
            if (obj == null) continue;
            this.setField(inf.name, obj);
        }
    }

    public void setFields(AcroFields acro) {
        HashMap map = acro.getFields();
        for (String key : map.keySet()) {
            AcroFields.Item item = (AcroFields.Item)map.get(key);
            PdfObject obj = ((PdfDictionary)item.merged.get(0)).get(PdfName.V);
            if (obj == null) continue;
            this.setField(key, obj);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    class Wrt
    extends PdfWriter {
        Wrt(OutputStream os) throws DocumentException, IOException {
            super(new PdfDocument(), os);
            this.os.write(HEADER_FDF);
            this.body = new PdfWriter.PdfBody(this);
        }

        void writeTo() throws DocumentException, IOException {
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.FIELDS, this.calculate(FdfWriter.this.fields));
            if (FdfWriter.this.file != null) {
                dic.put(PdfName.F, new PdfString(FdfWriter.this.file, "UnicodeBig"));
            }
            PdfDictionary fd = new PdfDictionary();
            fd.put(PdfName.FDF, dic);
            PdfIndirectReference ref = this.addToBody(fd).getIndirectReference();
            this.os.write(Wrt.getISOBytes("trailer\n"));
            PdfDictionary trailer = new PdfDictionary();
            trailer.put(PdfName.ROOT, ref);
            trailer.toPdf(null, this.os);
            this.os.write(Wrt.getISOBytes("\n%%EOF\n"));
            this.os.close();
        }

        PdfArray calculate(HashMap map) throws IOException {
            PdfArray ar = new PdfArray();
            for (String key : map.keySet()) {
                Object v = map.get(key);
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.T, new PdfString(key, "UnicodeBig"));
                if (v instanceof HashMap) {
                    dic.put(PdfName.KIDS, this.calculate((HashMap)v));
                } else {
                    dic.put(PdfName.V, (PdfObject)v);
                }
                ar.add(dic);
            }
            return ar;
        }
    }
}

