/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import quadbase.common.util.output.Document;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfEncryption;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfStream;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.RandomAccessFileOrArray;

public class PRStream
extends PdfStream {
    protected PdfReader reader;
    protected int offset;
    protected int length;
    protected int objNum = 0;
    protected int objGen = 0;

    public PRStream(PRStream stream, PdfDictionary newDic) {
        this.reader = stream.reader;
        this.offset = stream.offset;
        this.length = stream.length;
        this.compressed = stream.compressed;
        this.streamBytes = stream.streamBytes;
        this.bytes = stream.bytes;
        this.objNum = stream.objNum;
        this.objGen = stream.objGen;
        if (newDic != null) {
            this.putAll(newDic);
        } else {
            this.hashMap.putAll(stream.hashMap);
        }
    }

    public PRStream(PdfReader reader, int offset) {
        this.reader = reader;
        this.offset = offset;
    }

    public PRStream(PdfReader reader, byte[] conts) {
        this.reader = reader;
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                DeflaterOutputStream zip = new DeflaterOutputStream(stream);
                zip.write(conts);
                zip.close();
                this.bytes = stream.toByteArray();
            }
            catch (IOException ioe) {
                throw new ExceptionConverter(ioe);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = conts;
        }
        this.setLength(this.bytes.length);
    }

    public void setLength(int length) {
        this.length = length;
        this.put(PdfName.LENGTH, new PdfNumber(length));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setObjNum(int objNum, int objGen) {
        this.objNum = objNum;
        this.objGen = objGen;
    }

    int getObjNum() {
        return this.objNum;
    }

    int getObjGen() {
        return this.objGen;
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        this.superToPdf(writer, os);
        os.write(STARTSTREAM);
        if (this.length > 0) {
            PdfEncryption crypto = null;
            if (writer != null) {
                crypto = writer.getEncryption();
            }
            if (this.offset < 0) {
                if (crypto == null) {
                    os.write(this.bytes);
                } else {
                    crypto.prepareKey();
                    byte[] buf = new byte[this.length];
                    System.arraycopy(this.bytes, 0, buf, 0, this.length);
                    crypto.encryptRC4(buf);
                    os.write(buf);
                }
            } else {
                byte[] buf = new byte[Math.min(this.length, 4092)];
                RandomAccessFileOrArray file = writer.getReaderFile(this.reader);
                file.seek(this.offset);
                int size = this.length;
                PdfEncryption decrypt = this.reader.getDecrypt();
                if (decrypt != null) {
                    decrypt.setHashKey(this.objNum, this.objGen);
                    decrypt.prepareKey();
                }
                if (crypto != null) {
                    crypto.prepareKey();
                }
                while (size > 0) {
                    int r = file.read(buf, 0, Math.min(size, buf.length));
                    size -= r;
                    if (decrypt != null) {
                        decrypt.encryptRC4(buf, 0, r);
                    }
                    if (crypto != null) {
                        crypto.encryptRC4(buf, 0, r);
                    }
                    os.write(buf, 0, r);
                }
            }
        }
        os.write(ENDSTREAM);
    }
}

