/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import quadbase.common.util.output.Anchor;
import quadbase.common.util.output.Cell;
import quadbase.common.util.output.Chunk;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.List;
import quadbase.common.util.output.ListItem;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.PdfAction;
import quadbase.common.util.output.pdf.PdfChunk;
import quadbase.common.util.output.pdf.PdfLine;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private PdfLine line;
    private ArrayList images;
    private float leading;
    private int rownumber;
    private int rowspan;
    private float cellspacing;
    private float cellpadding;
    private boolean header = false;
    private int groupNumber;

    public PdfCell(Cell cell, int rownumber, float left, float right, float top, float cellspacing, float cellpadding) {
        super(left, top, right, top);
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.images = new ArrayList();
        this.leading = cell.leading();
        int alignment = cell.horizontalAlignment();
        left += cellspacing + cellpadding;
        right -= cellspacing + cellpadding;
        float height = this.leading + cellpadding;
        float rowSpan = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                height *= rowSpan;
                break;
            }
            case 5: {
                height = (float)((double)height * ((double)rowSpan / 1.5));
                break;
            }
            default: {
                height -= cellpadding * 0.4f;
            }
        }
        this.line = new PdfLine(left, right, alignment, height);
        Iterator i = cell.getElements();
        block11: while (i.hasNext()) {
            PdfChunk overflow;
            PdfChunk chunk;
            int aCounter;
            ArrayList allActions;
            Element element = (Element)i.next();
            switch (element.type()) {
                case 32: 
                case 34: 
                case 35: {
                    height = this.addImage((Image)element, left, right, height, alignment);
                    continue block11;
                }
                case 14: {
                    if (this.line.size() > 0) {
                        this.line.resetAlignment();
                        this.lines.add(this.line);
                    }
                    allActions = new ArrayList();
                    this.processActions(element, null, allActions);
                    aCounter = 0;
                    for (ListItem item : ((List)element).getItems()) {
                        this.line = new PdfLine(left + item.indentationLeft(), right, alignment, this.leading);
                        this.line.setListItem(item);
                        Iterator j = item.getChunks().iterator();
                        while (j.hasNext()) {
                            chunk = new PdfChunk((Chunk)j.next(), (PdfAction)allActions.get(aCounter++));
                            while ((overflow = this.line.add(chunk)) != null) {
                                this.lines.add(this.line);
                                this.line = new PdfLine(left + item.indentationLeft(), right, alignment, this.leading);
                                chunk = overflow;
                            }
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(left + item.indentationLeft(), right, alignment, this.leading);
                        }
                    }
                    this.line = new PdfLine(left, right, alignment, this.leading);
                    continue block11;
                }
            }
            allActions = new ArrayList();
            this.processActions(element, null, allActions);
            aCounter = 0;
            for (Chunk c : element.getChunks()) {
                chunk = new PdfChunk(c, (PdfAction)allActions.get(aCounter++));
                while ((overflow = this.line.add(chunk)) != null && !cell.noWrap()) {
                    this.lines.add(this.line);
                    this.line = new PdfLine(left, right, alignment, this.leading);
                    chunk = overflow;
                }
            }
            switch (element.type()) {
                case 12: 
                case 13: 
                case 16: {
                    this.line.resetAlignment();
                    this.lines.add(this.line);
                    this.line = new PdfLine(left, right, alignment, this.leading);
                }
            }
        }
        if (this.line.size() > 0) {
            this.lines.add(this.line);
        }
        this.setBottom(top - this.leading * (float)(this.lines.size() - 1) - cellpadding - height - 2.0f * cellspacing);
        this.cellpadding = cellpadding;
        this.cellspacing = cellspacing;
        this.rowspan = cell.rowspan();
        this.rownumber = rownumber;
    }

    @Override
    public float left() {
        return super.left(this.cellspacing);
    }

    @Override
    public float right() {
        return super.right(this.cellspacing);
    }

    @Override
    public float top() {
        return super.top(this.cellspacing);
    }

    @Override
    public float bottom() {
        return super.bottom(this.cellspacing);
    }

    private float addImage(Image imageOrg, float left, float right, float height, int alignment) {
        Image image = Image.getInstance(imageOrg);
        if (image.scaledWidth() > right - left) {
            image.scaleToFit(right - left, Float.MAX_VALUE);
        }
        if (this.line.size() != 0) {
            this.lines.add(this.line);
        }
        this.line = new PdfLine(left, right, alignment, image.scaledHeight() + 0.4f * this.leading);
        this.lines.add(this.line);
        this.line = new PdfLine(left, right, alignment, this.leading);
        switch (image.alignment() & 1) {
            case 2: {
                left = right - image.scaledWidth();
                break;
            }
            case 1: {
                left += (right - left - image.scaledWidth()) / 2.0f;
                break;
            }
        }
        image.setAbsolutePosition(left, height + (float)(this.lines.size() - 2) * this.leading + image.scaledHeight() + 0.4f * this.leading);
        this.images.add(image);
        return height + image.scaledHeight() + 0.4f * this.leading;
    }

    public ArrayList getLines(float top, float bottom) {
        if (this.top() < bottom) {
            return null;
        }
        float currentPosition = Math.min(this.top(), top);
        this.setTop(currentPosition + this.cellspacing);
        ArrayList<PdfLine> result = new ArrayList<PdfLine>();
        int size = this.lines.size();
        boolean aboveBottom = true;
        for (int i = 0; i < size && aboveBottom; ++i) {
            this.line = (PdfLine)this.lines.get(i);
            float lineHeight = this.line.height();
            if ((currentPosition -= lineHeight) > bottom + this.cellpadding) {
                result.add(this.line);
                continue;
            }
            aboveBottom = false;
        }
        float difference = 0.0f;
        if (!this.header) {
            if (aboveBottom) {
                this.lines = new ArrayList();
            } else {
                size = result.size();
                for (int i = 0; i < size; ++i) {
                    this.line = (PdfLine)this.lines.remove(0);
                    difference += this.line.height();
                }
            }
        }
        if (difference > 0.0f) {
            for (Image image : this.images) {
                image.setAbsolutePosition(image.absoluteX(), image.absoluteY() - difference - this.leading);
            }
        }
        return result;
    }

    public ArrayList getImages(float top, float bottom) {
        if (this.top() < bottom) {
            return new ArrayList();
        }
        top = Math.min(this.top(), top);
        ArrayList<Image> result = new ArrayList<Image>();
        Iterator i = this.images.iterator();
        while (i.hasNext() && !this.header) {
            Image image = (Image)i.next();
            float height = image.absoluteY();
            if (!(top - height > bottom + this.cellpadding)) continue;
            image.setAbsolutePosition(image.absoluteX(), top - height);
            result.add(image);
            i.remove();
        }
        return result;
    }

    boolean isHeader() {
        return this.header;
    }

    void setHeader() {
        this.header = true;
    }

    boolean mayBeRemoved() {
        return this.header || this.lines.size() == 0 && this.images.size() == 0;
    }

    public int size() {
        return this.lines.size();
    }

    public int remainingLines() {
        if (this.lines.size() == 0) {
            return 0;
        }
        int result = 0;
        int size = this.lines.size();
        for (int i = 0; i < size; ++i) {
            PdfLine line = (PdfLine)this.lines.get(i);
            if (line.size() <= 0) continue;
            ++result;
        }
        return result;
    }

    public float remainingHeight() {
        float result = 0.0f;
        for (Image image : this.images) {
            result += image.scaledHeight();
        }
        return (float)this.remainingLines() * this.leading + 2.0f * this.cellpadding + this.cellspacing + result + this.leading / 2.5f;
    }

    public float leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    protected void processActions(Element element, PdfAction action, ArrayList allActions) {
        String url;
        if (element.type() == 17 && (url = ((Anchor)element).reference()) != null) {
            action = new PdfAction(url);
        }
        switch (element.type()) {
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                Iterator i = ((ArrayList)((Object)element)).iterator();
                while (i.hasNext()) {
                    this.processActions((Element)i.next(), action, allActions);
                }
                break;
            }
            case 10: {
                allActions.add(action);
                break;
            }
            case 14: {
                Iterator i = ((List)element).getItems().iterator();
                while (i.hasNext()) {
                    this.processActions((Element)i.next(), action, allActions);
                }
                break;
            }
            default: {
                ArrayList tmp = element.getChunks();
                int n = element.getChunks().size();
                while (n-- > 0) {
                    allActions.add(action);
                }
                break block0;
            }
        }
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    void setGroupNumber(int number) {
        this.groupNumber = number;
    }
}

