/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import quadbase.common.util.output.Anchor;
import quadbase.common.util.output.Annotation;
import quadbase.common.util.output.Cell;
import quadbase.common.util.output.Chunk;
import quadbase.common.util.output.DocListener;
import quadbase.common.util.output.Document;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Element;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.Graphic;
import quadbase.common.util.output.HeaderFooter;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.List;
import quadbase.common.util.output.ListItem;
import quadbase.common.util.output.Meta;
import quadbase.common.util.output.Paragraph;
import quadbase.common.util.output.Phrase;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.Section;
import quadbase.common.util.output.StringCompare;
import quadbase.common.util.output.Table;
import quadbase.common.util.output.Watermark;
import quadbase.common.util.output.pdf.PageResources;
import quadbase.common.util.output.pdf.PdfAcroForm;
import quadbase.common.util.output.pdf.PdfAction;
import quadbase.common.util.output.pdf.PdfAnnotation;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfBoolean;
import quadbase.common.util.output.pdf.PdfCell;
import quadbase.common.util.output.pdf.PdfChunk;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfContents;
import quadbase.common.util.output.pdf.PdfDate;
import quadbase.common.util.output.pdf.PdfDestination;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfException;
import quadbase.common.util.output.pdf.PdfFont;
import quadbase.common.util.output.pdf.PdfFormField;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfLine;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfOutline;
import quadbase.common.util.output.pdf.PdfPTable;
import quadbase.common.util.output.pdf.PdfPTableEvent;
import quadbase.common.util.output.pdf.PdfPage;
import quadbase.common.util.output.pdf.PdfPageEvent;
import quadbase.common.util.output.pdf.PdfPageLabels;
import quadbase.common.util.output.pdf.PdfRectangle;
import quadbase.common.util.output.pdf.PdfString;
import quadbase.common.util.output.pdf.PdfTable;
import quadbase.common.util.output.pdf.PdfTextArray;
import quadbase.common.util.output.pdf.PdfTransition;
import quadbase.common.util.output.pdf.PdfWriter;

class PdfDocument
extends Document
implements DocListener {
    static final String hangingPunctuation = ".,;:'";
    private PdfWriter writer;
    private PdfInfo info = new PdfInfo();
    private boolean firstPageEvent = true;
    private boolean isParagraph = true;
    private PdfLine line = null;
    private float indentLeft = 0.0f;
    private float indentRight = 0.0f;
    private float listIndentLeft = 0.0f;
    private int alignment = 0;
    private PdfContentByte text;
    private PdfContentByte graphics;
    private ArrayList lines = new ArrayList();
    private float leading = 0.0f;
    private float currentHeight = 0.0f;
    private float indentTop = 0.0f;
    private float indentBottom = 0.0f;
    private boolean pageEmpty = true;
    private int textEmptySize;
    protected Rectangle nextPageSize = null;
    protected Rectangle thisCropSize = null;
    protected Rectangle cropSize = null;
    protected PageResources pageResources;
    private Image imageWait = null;
    private float imageEnd = -1.0f;
    private float imageIndentLeft = 0.0f;
    private float imageIndentRight = 0.0f;
    private ArrayList annotations;
    private ArrayList delayedAnnotations = new ArrayList();
    PdfAcroForm acroForm;
    private PdfOutline rootOutline;
    private PdfOutline currentOutline;
    private PdfAction currentAction = null;
    private TreeMap localDestinations = new TreeMap(new StringCompare());
    private ArrayList documentJavaScript = new ArrayList();
    private int viewerPreferences = 0;
    private String openActionName;
    private PdfAction openActionAction;
    private PdfDictionary additionalActions;
    private PdfPageLabels pageLabels;
    private boolean isNewpage = false;
    private boolean isParagraphE = false;
    private float paraIndent = 0.0f;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected float nextMarginBottom;
    protected int duration = -1;
    protected PdfTransition transition = null;
    protected PdfDictionary pageAA = null;
    private boolean strictImageSequence = false;

    public PdfDocument() throws DocumentException {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter writer) throws DocumentException {
        if (this.writer == null) {
            this.writer = writer;
            this.acroForm = new PdfAcroForm(writer);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    @Override
    public boolean setPageSize(Rectangle pageSize) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(pageSize);
        return true;
    }

    @Override
    public void setHeader(HeaderFooter header) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(header);
    }

    @Override
    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    @Override
    public void setFooter(HeaderFooter footer) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(footer);
    }

    @Override
    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    @Override
    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    @Override
    public void setPageCount(int pageN) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(pageN);
    }

    @Override
    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    @Override
    public void removeWatermark() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        this.watermark = null;
    }

    @Override
    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = marginLeft;
        this.nextMarginRight = marginRight;
        this.nextMarginTop = marginTop;
        this.nextMarginBottom = marginBottom;
        return true;
    }

    protected PdfArray rotateAnnotations() {
        PdfArray array = new PdfArray();
        int rotation = this.pageSize.getRotation() % 360;
        int currentPage = this.writer.getCurrentPageNumber();
        for (int k = 0; k < this.annotations.size(); ++k) {
            PdfAnnotation dic = (PdfAnnotation)this.annotations.get(k);
            int page = dic.getPlaceInPage();
            if (page > currentPage) {
                this.delayedAnnotations.add(dic);
                continue;
            }
            if (dic.isForm()) {
                PdfFormField field;
                HashMap templates;
                if (!dic.isUsed() && (templates = dic.getTemplates()) != null) {
                    this.acroForm.addFieldTemplates(templates);
                }
                if ((field = (PdfFormField)dic).getParent() == null) {
                    this.acroForm.addDocumentField(field.getIndirectReference());
                }
            }
            if (dic.isAnnotation()) {
                array.add(dic.getIndirectReference());
                if (!dic.isUsed()) {
                    PdfRectangle rect = (PdfRectangle)dic.get(PdfName.RECT);
                    switch (rotation) {
                        case 90: {
                            dic.put(PdfName.RECT, new PdfRectangle(this.pageSize.top() - rect.bottom(), rect.left(), this.pageSize.top() - rect.top(), rect.right()));
                            break;
                        }
                        case 180: {
                            dic.put(PdfName.RECT, new PdfRectangle(this.pageSize.right() - rect.left(), this.pageSize.top() - rect.bottom(), this.pageSize.right() - rect.right(), this.pageSize.top() - rect.top()));
                            break;
                        }
                        case 270: {
                            dic.put(PdfName.RECT, new PdfRectangle(rect.bottom(), this.pageSize.right() - rect.left(), rect.top(), this.pageSize.right() - rect.right()));
                        }
                    }
                }
            }
            if (dic.isUsed()) continue;
            dic.setUsed();
            try {
                this.writer.addToBody((PdfObject)dic, dic.getIndirectReference());
                continue;
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
        return array;
    }

    protected PdfDictionary codeTransition(PdfTransition transition) {
        PdfDictionary trans = new PdfDictionary(PdfName.TRANS);
        switch (transition.getType()) {
            case 1: {
                trans.put(PdfName.S, PdfName.SPLIT);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DM, PdfName.V);
                trans.put(PdfName.M, PdfName.O);
                break;
            }
            case 2: {
                trans.put(PdfName.S, PdfName.SPLIT);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DM, PdfName.H);
                trans.put(PdfName.M, PdfName.O);
                break;
            }
            case 3: {
                trans.put(PdfName.S, PdfName.SPLIT);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DM, PdfName.V);
                trans.put(PdfName.M, PdfName.I);
                break;
            }
            case 4: {
                trans.put(PdfName.S, PdfName.SPLIT);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DM, PdfName.H);
                trans.put(PdfName.M, PdfName.I);
                break;
            }
            case 5: {
                trans.put(PdfName.S, PdfName.BLINDS);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DM, PdfName.V);
                break;
            }
            case 6: {
                trans.put(PdfName.S, PdfName.BLINDS);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DM, PdfName.H);
                break;
            }
            case 7: {
                trans.put(PdfName.S, PdfName.BOX);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.M, PdfName.I);
                break;
            }
            case 8: {
                trans.put(PdfName.S, PdfName.BOX);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.M, PdfName.O);
                break;
            }
            case 9: {
                trans.put(PdfName.S, PdfName.WIPE);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 10: {
                trans.put(PdfName.S, PdfName.WIPE);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(180));
                break;
            }
            case 11: {
                trans.put(PdfName.S, PdfName.WIPE);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(90));
                break;
            }
            case 12: {
                trans.put(PdfName.S, PdfName.WIPE);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 13: {
                trans.put(PdfName.S, PdfName.DISSOLVE);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                break;
            }
            case 14: {
                trans.put(PdfName.S, PdfName.GLITTER);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 15: {
                trans.put(PdfName.S, PdfName.GLITTER);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 16: {
                trans.put(PdfName.S, PdfName.GLITTER);
                trans.put(PdfName.D, new PdfNumber(transition.getDuration()));
                trans.put(PdfName.DI, new PdfNumber(315));
            }
        }
        return trans;
    }

    @Override
    public boolean newPage() throws DocumentException {
        PdfArray array;
        this.isNewpage = true;
        if (this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer != null && this.writer.isPaused())) {
            return false;
        }
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            pageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.imageIndentLeft = 0.0f;
        this.imageIndentRight = 0.0f;
        this.flushLines();
        PdfDictionary resources = this.pageResources.getResources();
        int rotation = this.pageSize.getRotation();
        PdfPage page = rotation == 0 ? new PdfPage(new PdfRectangle(this.pageSize, rotation), this.thisCropSize, resources) : new PdfPage(new PdfRectangle(this.pageSize, rotation), this.thisCropSize, resources, new PdfNumber(rotation));
        if (this.transition != null) {
            page.put(PdfName.TRANS, this.codeTransition(this.transition));
            this.transition = null;
        }
        if (this.duration > 0) {
            page.put(PdfName.DUR, new PdfNumber(this.duration));
            this.duration = 0;
        }
        if (this.pageAA != null) {
            try {
                page.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
            }
            catch (IOException ioe) {
                throw new ExceptionConverter(ioe);
            }
            this.pageAA = null;
        }
        if (this.annotations.size() > 0 && (array = this.rotateAnnotations()).size() != 0) {
            page.put(PdfName.ANNOTS, array);
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        if (this.text.size() > this.textEmptySize) {
            this.text.endText();
        } else {
            this.text = null;
        }
        PdfIndirectReference pageReference = this.writer.add(page, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
        this.initPage();
        this.isNewpage = false;
        return true;
    }

    @Override
    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    void outlineTree(PdfOutline outline) throws IOException {
        int k;
        outline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (outline.parent() != null) {
            outline.put(PdfName.PARENT, outline.parent().indirectReference());
        }
        ArrayList kids = outline.getKids();
        int size = kids.size();
        for (k = 0; k < size; ++k) {
            this.outlineTree((PdfOutline)kids.get(k));
        }
        for (k = 0; k < size; ++k) {
            if (k > 0) {
                ((PdfOutline)kids.get(k)).put(PdfName.PREV, ((PdfOutline)kids.get(k - 1)).indirectReference());
            }
            if (k >= size - 1) continue;
            ((PdfOutline)kids.get(k)).put(PdfName.NEXT, ((PdfOutline)kids.get(k + 1)).indirectReference());
        }
        if (size > 0) {
            outline.put(PdfName.FIRST, ((PdfOutline)kids.get(0)).indirectReference());
            outline.put(PdfName.LAST, ((PdfOutline)kids.get(size - 1)).indirectReference());
        }
        for (k = 0; k < size; ++k) {
            PdfOutline kid = (PdfOutline)kids.get(k);
            this.writer.addToBody((PdfObject)kid, kid.indirectReference());
        }
    }

    void writeOutlines() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.outlineTree(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    void traverseOutlineCount(PdfOutline outline) {
        ArrayList kids = outline.getKids();
        PdfOutline parent = outline.parent();
        if (kids.size() == 0) {
            if (parent != null) {
                parent.setCount(parent.getCount() + 1);
            }
        } else {
            for (int k = 0; k < kids.size(); ++k) {
                this.traverseOutlineCount((PdfOutline)kids.get(k));
            }
            if (parent != null) {
                if (outline.isOpen()) {
                    parent.setCount(outline.getCount() + parent.getCount() + 1);
                } else {
                    parent.setCount(parent.getCount() + 1);
                    outline.setCount(-outline.getCount());
                }
            }
        }
    }

    void calculateOutlineCount() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.traverseOutlineCount(this.rootOutline);
    }

    @Override
    public void close() {
        if (this.close) {
            return;
        }
        try {
            this.newPage();
            if (this.imageWait != null) {
                this.newPage();
            }
            if (this.annotations.size() > 0) {
                throw new RuntimeException(this.annotations.size() + " annotations had invalid placement pages.");
            }
            PdfPageEvent pageEvent = this.writer.getPageEvent();
            if (pageEvent != null) {
                pageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.addLocalDestinations(this.localDestinations);
            this.calculateOutlineCount();
            this.writeOutlines();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.writer.close();
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    void addPTable(PdfPTable ptable, float xWidth) throws DocumentException {
        int k;
        float[] finalHeights;
        int startRow;
        float baseY;
        if (ptable.getHeaderRows() >= ptable.size()) {
            return;
        }
        boolean skipHeader = ptable.getSkipFirstHeader();
        float headerHeight = ptable.getHeaderHeight();
        float bottom = this.indentBottom();
        float currentY = baseY = this.indentTop() - this.currentHeight;
        int currentRow = startRow = ptable.getHeaderRows();
        PdfContentByte[] cv = null;
        float eventY = 0.0f;
        int eventRow = 0;
        int eventHeader = 0;
        float[] absoluteWidths = ptable.getAbsoluteWidths();
        PdfPTableEvent event = ptable.getTableEvent();
        ptable.setTableEvent(null);
        float[] heights = new float[ptable.size()];
        int heightsIdx = 0;
        for (currentRow = startRow; currentRow < ptable.size(); ++currentRow) {
            if (currentRow == startRow && currentY - ptable.getRowHeight(currentRow) - headerHeight < bottom) {
                if (this.currentHeight == 0.0f) {
                    ++startRow;
                    continue;
                }
                this.newPage();
                startRow = currentRow--;
                bottom = this.indentBottom();
                currentY = baseY = this.indentTop() - this.currentHeight;
                skipHeader = false;
                continue;
            }
            if (currentY - ptable.getRowHeight(currentRow) < bottom) {
                if (cv != null) {
                    if (event != null) {
                        finalHeights = new float[heightsIdx + 1];
                        finalHeights[0] = eventY;
                        for (k = 0; k < heightsIdx; ++k) {
                            finalHeights[k + 1] = finalHeights[k] - heights[k];
                        }
                        event.tableLayout(ptable, ptable.getEventWidths(xWidth, eventRow, eventRow + heightsIdx - eventHeader, true), finalHeights, eventHeader, eventRow, cv);
                    }
                    PdfPTable.endWritingRows(cv);
                    cv = null;
                }
                this.newPage();
                startRow = currentRow--;
                bottom = this.indentBottom();
                currentY = baseY = this.indentTop() - this.currentHeight;
                continue;
            }
            if (cv == null) {
                cv = PdfPTable.beginWritingRows(this.writer.getDirectContent());
                if (event != null && !skipHeader) {
                    heightsIdx = 0;
                    eventHeader = ptable.getHeaderRows();
                    for (int k2 = 0; k2 < eventHeader; ++k2) {
                        heights[heightsIdx++] = ptable.getRowHeight(k2);
                    }
                    eventY = currentY;
                    eventRow = currentRow;
                }
                if (!skipHeader) {
                    currentY = ptable.writeSelectedRows(0, ptable.getHeaderRows(), xWidth, currentY, cv);
                } else {
                    skipHeader = false;
                }
            }
            if (event != null) {
                heights[heightsIdx++] = ptable.getRowHeight(currentRow);
            }
            currentY = ptable.writeSelectedRows(currentRow, currentRow + 1, xWidth, currentY, cv);
        }
        if (cv != null) {
            if (event != null) {
                finalHeights = new float[heightsIdx + 1];
                finalHeights[0] = eventY;
                for (k = 0; k < heightsIdx; ++k) {
                    finalHeights[k + 1] = finalHeights[k] - heights[k];
                }
                event.tableLayout(ptable, ptable.getEventWidths(xWidth, eventRow, eventRow + heightsIdx - eventHeader, true), finalHeights, eventHeader, eventRow, cv);
            }
            PdfPTable.endWritingRows(cv);
            this.text.moveText(0.0f, currentY - baseY);
            this.currentHeight = this.indentTop() - currentY;
        }
        ptable.setTableEvent(event);
    }

    @Override
    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    this.info.addkey(((Meta)element).name(), ((Meta)element).content());
                    break;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 7: {
                    this.info.addCreator(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    PdfChunk overflow;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk chunk = new PdfChunk((Chunk)element, this.currentAction);
                    while ((overflow = this.line.add(chunk)) != null) {
                        this.carriageReturn();
                        chunk = overflow;
                    }
                    this.pageEmpty = false;
                    if (!chunk.isAttribute("NEWPAGE")) break;
                    this.newPage();
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    String url = anchor.reference();
                    this.leading = anchor.leading();
                    if (url != null) {
                        this.currentAction = new PdfAction(url);
                    }
                    element.process(this);
                    this.currentAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annot = (Annotation)element;
                    switch (annot.annotationType()) {
                        case 1: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((URL)annot.attributes().get(Annotation.URL))));
                            break;
                        }
                        case 2: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.FILE))));
                            break;
                        }
                        case 3: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.FILE), (String)annot.attributes().get(Annotation.DESTINATION))));
                            break;
                        }
                        case 4: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.FILE), (Integer)annot.attributes().get(Annotation.PAGE))));
                            break;
                        }
                        case 5: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((Integer)annot.attributes().get(Annotation.NAMED))));
                            break;
                        }
                        case 6: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.APPLICATION), (String)annot.attributes().get(Annotation.PARAMETERS), (String)annot.attributes().get(Annotation.OPERATION), (String)annot.attributes().get(Annotation.DEFAULTDIR))));
                            break;
                        }
                        default: {
                            this.annotations.add(new PdfAnnotation(this.writer, annot.llx(this.indentRight() - this.line.widthLeft()), annot.lly(this.indentTop() - this.currentHeight), annot.urx(this.indentRight() - this.line.widthLeft() + 20.0f), annot.ury(this.indentTop() - this.currentHeight - 20.0f), new PdfString(annot.title()), new PdfString(annot.content())));
                        }
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Paragraph paragraph = (Paragraph)element;
                    this.alignment = paragraph.alignment();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.carriageReturn();
                    this.isParagraphE = true;
                    this.paraIndent += paragraph.indentationLeft();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null && this.isParagraph) {
                        pageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        Table table = new Table(1, 1);
                        table.setOffset(0.0f);
                        table.setBorder(0);
                        table.setWidth(100.0f);
                        table.setTableFitsPage(true);
                        Cell cell = new Cell(paragraph);
                        cell.setBorder(0);
                        cell.setHorizontalAlignment(paragraph.alignment());
                        table.addCell(cell);
                        this.add(table);
                        break;
                    }
                    element.process(this);
                    this.paraIndent -= paragraph.indentationLeft();
                    this.carriageReturn();
                    if (pageEvent != null && this.isParagraph) {
                        pageEvent.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    this.isParagraphE = false;
                    break;
                }
                case 13: 
                case 16: {
                    boolean hasTitle;
                    Section section = (Section)element;
                    boolean bl = hasTitle = section.title() != null;
                    if (section.isChapter()) {
                        this.newPage();
                    } else {
                        this.newLine();
                    }
                    if (hasTitle) {
                        PdfOutline outline;
                        float fith = this.indentTop() - this.currentHeight;
                        int rotation = this.pageSize.getRotation();
                        if (rotation == 90 || rotation == 180) {
                            fith = this.pageSize.height() - fith;
                        }
                        PdfDestination destination = new PdfDestination(2, fith);
                        while (this.currentOutline.level() >= section.depth()) {
                            this.currentOutline = this.currentOutline.parent();
                        }
                        this.currentOutline = outline = new PdfOutline(this.currentOutline, destination, section.title(), section.isBookmarkOpen());
                    }
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null) {
                        if (element.type() == 16) {
                            pageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.title());
                        } else {
                            pageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.depth(), section.title());
                        }
                    }
                    if (hasTitle) {
                        this.isParagraph = false;
                        this.add(section.title());
                        this.isParagraph = true;
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (pageEvent == null) break;
                    if (element.type() == 16) {
                        pageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    this.newLine();
                    this.flushLines();
                    PdfPTable ptable = (PdfPTable)element;
                    float totalWidth = (this.indentRight() - this.indentLeft()) * ptable.getWidthPercentage() / 100.0f;
                    float xWidth = 0.0f;
                    switch (ptable.getHorizontalAlignment()) {
                        case 0: {
                            xWidth = this.indentLeft();
                            break;
                        }
                        case 2: {
                            xWidth = this.indentRight() - totalWidth;
                            break;
                        }
                        default: {
                            xWidth = (this.indentRight() + this.indentLeft() - totalWidth) / 2.0f;
                        }
                    }
                    ptable.setTotalWidth(totalWidth);
                    this.addPTable(ptable, xWidth);
                    break;
                }
                case 22: {
                    boolean tableHasToFit;
                    ((Table)element).complete();
                    float offset = ((Table)element).getOffset();
                    if (Float.isNaN(offset)) {
                        offset = this.leading;
                    }
                    this.carriageReturn();
                    this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, offset));
                    this.currentHeight += offset;
                    this.flushLines();
                    float pagetop = this.indentTop();
                    float oldHeight = this.currentHeight;
                    PdfContentByte cellGraphics = new PdfContentByte(this.writer);
                    PdfTable table = new PdfTable((Table)element, this.indentLeft(), this.indentRight(), this.currentHeight > 0.0f ? pagetop - this.currentHeight - 6.0f : pagetop);
                    boolean bl = ((Table)element).hasToFitPageTable() ? table.bottom() < this.indentBottom() : (tableHasToFit = false);
                    if (this.pageEmpty) {
                        tableHasToFit = false;
                    }
                    boolean cellsHaveToFit = ((Table)element).hasToFitPageCells();
                    ArrayList cells = table.getCells();
                    ArrayList headercells = null;
                    while (!cells.isEmpty()) {
                        float cellDisplacement;
                        int i;
                        PdfCell cell;
                        float lostTableBottom = 0.0f;
                        boolean cellsShown = false;
                        int currentGroupNumber = 0;
                        boolean headerChecked = false;
                        ListIterator iterator = cells.listIterator();
                        while (iterator.hasNext() && !tableHasToFit) {
                            cell = (PdfCell)iterator.next();
                            if (cellsHaveToFit) {
                                if (!cell.isHeader()) {
                                    if (cell.getGroupNumber() != currentGroupNumber) {
                                        boolean cellsFit = true;
                                        currentGroupNumber = cell.getGroupNumber();
                                        int cellCount = 0;
                                        while (cell.getGroupNumber() == currentGroupNumber && cellsFit && iterator.hasNext()) {
                                            if (cell.bottom() < this.indentBottom()) {
                                                cellsFit = false;
                                            }
                                            cell = (PdfCell)iterator.next();
                                            ++cellCount;
                                        }
                                        if (!cellsFit) break;
                                        for (int i2 = cellCount; i2 >= 0; --i2) {
                                            cell = (PdfCell)iterator.previous();
                                        }
                                    }
                                } else if (!headerChecked) {
                                    headerChecked = true;
                                    boolean cellsFit = true;
                                    int cellCount = 0;
                                    float firstTop = cell.top();
                                    while (cell.isHeader() && cellsFit && iterator.hasNext()) {
                                        if (firstTop - cell.bottom(0.0f) > this.indentTop() - this.currentHeight - this.indentBottom()) {
                                            cellsFit = false;
                                        }
                                        cell = (PdfCell)iterator.next();
                                        ++cellCount;
                                    }
                                    currentGroupNumber = cell.getGroupNumber();
                                    while (cell.getGroupNumber() == currentGroupNumber && cellsFit && iterator.hasNext()) {
                                        if ((double)(firstTop - cell.bottom(0.0f)) > (double)(this.indentTop() - this.currentHeight - this.indentBottom()) - 10.0) {
                                            cellsFit = false;
                                        }
                                        cell = (PdfCell)iterator.next();
                                        ++cellCount;
                                    }
                                    for (i = cellCount; i >= 0; --i) {
                                        cell = (PdfCell)iterator.previous();
                                    }
                                    if (!cellsFit) {
                                        while (cell.isHeader()) {
                                            iterator.remove();
                                            cell = (PdfCell)iterator.next();
                                        }
                                        break;
                                    }
                                }
                            }
                            this.lines = cell.getLines(pagetop, this.indentBottom());
                            if (this.lines != null && this.lines.size() > 0) {
                                cellsShown = true;
                                cellGraphics.rectangle(cell.rectangle(pagetop, this.indentBottom()));
                                lostTableBottom = Math.max(cell.bottom(), this.indentBottom());
                                float cellTop = cell.top(pagetop - oldHeight);
                                this.text.moveText(0.0f, cellTop);
                                cellDisplacement = this.flushLines() - cellTop;
                                this.text.moveText(0.0f, cellDisplacement);
                                if (oldHeight + cellDisplacement > this.currentHeight) {
                                    this.currentHeight = oldHeight + cellDisplacement;
                                }
                            }
                            ArrayList images = cell.getImages(pagetop, this.indentBottom());
                            Iterator i3 = images.iterator();
                            while (i3.hasNext()) {
                                cellsShown = true;
                                Image image = (Image)i3.next();
                                this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                            }
                            if (!cell.mayBeRemoved()) continue;
                            iterator.remove();
                        }
                        tableHasToFit = false;
                        if (cellsShown) {
                            Rectangle tablerec = new Rectangle(table);
                            tablerec.setBorder(table.border());
                            tablerec.setBorderWidth(table.borderWidth());
                            tablerec.setBorderColor(table.borderColor());
                            tablerec.setBackgroundColor(table.backgroundColor());
                            tablerec.setGrayFill(table.grayFill());
                            PdfContentByte under = this.writer.getDirectContentUnder();
                            under.rectangle(tablerec.rectangle(this.top(), this.indentBottom()));
                            under.add(cellGraphics);
                            tablerec.setGrayFill(0.0f);
                            tablerec.setBackgroundColor(null);
                            under.rectangle(tablerec.rectangle(this.top(), this.indentBottom()));
                        }
                        cellGraphics = new PdfContentByte(null);
                        if (cells.isEmpty()) continue;
                        this.graphics.setLineWidth(table.borderWidth());
                        if (cellsShown && (table.border() & 2) == 2) {
                            Color tColor = table.borderColor();
                            if (tColor != null) {
                                this.graphics.setColorStroke(tColor);
                            }
                            this.graphics.moveTo(table.left(), Math.max(table.bottom(), this.indentBottom()));
                            this.graphics.lineTo(table.right(), Math.max(table.bottom(), this.indentBottom()));
                            this.graphics.stroke();
                            if (tColor != null) {
                                this.graphics.resetRGBColorStroke();
                            }
                        }
                        this.pageEmpty = false;
                        float difference = lostTableBottom;
                        this.newPage();
                        float heightCorrection = 0.0f;
                        boolean somethingAdded = false;
                        if (this.currentHeight > 0.0f) {
                            heightCorrection = 6.0f;
                            this.currentHeight += heightCorrection;
                            somethingAdded = true;
                            this.newLine();
                            this.flushLines();
                            this.indentTop = this.currentHeight - this.leading;
                            this.currentHeight = 0.0f;
                        } else {
                            this.flushLines();
                        }
                        headercells = table.getHeaderCells();
                        int size = headercells.size();
                        if (size > 0) {
                            cell = (PdfCell)headercells.get(0);
                            float oldTop = cell.top(0.0f);
                            for (int i4 = 0; i4 < size; ++i4) {
                                cell = (PdfCell)headercells.get(i4);
                                cell.setTop(this.indentTop() - oldTop + cell.top(0.0f));
                                cell.setBottom(this.indentTop() - oldTop + cell.bottom(0.0f));
                                pagetop = cell.bottom();
                                cellGraphics.rectangle(cell.rectangle(this.indentTop(), this.indentBottom()));
                                ArrayList images = cell.getImages(this.indentTop(), this.indentBottom());
                                Iterator im = images.iterator();
                                while (im.hasNext()) {
                                    cellsShown = true;
                                    Image image = (Image)im.next();
                                    this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                                }
                                this.lines = cell.getLines(this.indentTop(), this.indentBottom());
                                float cellTop = cell.top(this.indentTop());
                                this.text.moveText(0.0f, cellTop - heightCorrection);
                                cellDisplacement = this.flushLines() - cellTop + heightCorrection;
                                this.text.moveText(0.0f, cellDisplacement);
                            }
                            this.currentHeight = this.indentTop() - pagetop + table.cellspacing();
                            this.text.moveText(0.0f, pagetop - this.indentTop() - table.cellspacing() - this.currentHeight);
                        } else if (somethingAdded) {
                            pagetop = this.indentTop();
                            this.text.moveText(0.0f, pagetop - this.indentTop() - table.cellspacing());
                        }
                        oldHeight = this.currentHeight + table.cellspacing() - heightCorrection;
                        size = Math.min(cells.size(), table.columns());
                        for (i = 0; i < size; ++i) {
                            float neededHeight;
                            float newBottom;
                            cell = (PdfCell)cells.get(i);
                            if (!(cell.top(-table.cellspacing()) > lostTableBottom) || !((newBottom = pagetop - difference + cell.bottom()) > pagetop - (neededHeight = cell.remainingHeight()))) continue;
                            difference += newBottom - (pagetop - neededHeight);
                        }
                        size = cells.size();
                        table.setTop(this.indentTop());
                        table.setBottom(pagetop - difference + table.bottom(table.cellspacing()));
                        for (i = 0; i < size; ++i) {
                            cell = (PdfCell)cells.get(i);
                            float newBottom = pagetop - difference + cell.bottom();
                            float newTop = pagetop - difference + cell.top(-table.cellspacing());
                            if (newTop > this.indentTop() - this.currentHeight + table.cellspacing()) {
                                newTop = this.indentTop() - this.currentHeight + table.cellspacing();
                            }
                            cell.setTop(newTop - table.cellspacing());
                            cell.setBottom(newBottom - table.cellspacing());
                        }
                    }
                    this.text.moveText(0.0f, oldHeight - this.currentHeight);
                    this.lines.add(this.line);
                    this.currentHeight += this.line.height() - pagetop + this.indentTop();
                    this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
                    this.pageEmpty = false;
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    this.carriageReturn();
                    this.add((Image)element);
                    this.pageEmpty = false;
                    break;
                }
                case 39: {
                    Graphic graphic = (Graphic)element;
                    graphic.processAttributes(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight);
                    this.graphics.add(graphic);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            throw new DocumentException(e.getMessage());
        }
    }

    private void addImage(PdfContentByte graphics, Image image, float a, float b, float c, float d, float e, float f) throws DocumentException {
        Annotation annotation = image.annotation();
        if (image.hasAbsolutePosition()) {
            graphics.addImage(image);
            if (annotation != null) {
                annotation.setDimensions(image.absoluteX(), image.absoluteY(), image.absoluteX() + image.scaledWidth(), image.absoluteY() + image.scaledHeight());
                this.add(annotation);
            }
        } else {
            graphics.addImage(image, a, b, c, d, e, f);
            if (annotation != null) {
                annotation.setDimensions(e, f, e + image.scaledWidth(), f + image.scaledHeight());
                this.add(annotation);
            }
        }
    }

    private void add(Image image) throws PdfException, DocumentException {
        this.pageEmpty = false;
        if (image.hasAbsolutePosition()) {
            this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean textwrap = (image.alignment() & 4) == 4 && (image.alignment() & 1) != 1;
        boolean underlying = (image.alignment() & 8) == 8;
        float diff = this.leading / 2.0f;
        if (textwrap) {
            diff += this.leading;
        }
        float lowerleft = this.indentTop() - this.currentHeight - image.scaledHeight() - diff;
        float[] mt = image.matrix();
        float startPosition = this.indentLeft() - mt[4];
        if ((image.alignment() & 1) == 2) {
            startPosition = this.indentRight() - image.scaledWidth() - mt[4];
        }
        if ((image.alignment() & 1) == 1) {
            startPosition = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.scaledWidth()) / 2.0f - mt[4];
        }
        if (image.hasAbsoluteX()) {
            startPosition = image.absoluteX();
        }
        this.addImage(this.graphics, image, mt[0], mt[1], mt[2], mt[3], startPosition, lowerleft - mt[5]);
        if (textwrap) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + diff) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + diff;
            }
            if ((image.alignment() & 2) == 2) {
                this.imageIndentRight += image.scaledWidth() + image.indentationLeft();
            } else {
                this.imageIndentLeft += image.scaledWidth() + image.indentationRight();
            }
        }
        if (!textwrap && !underlying) {
            this.currentHeight += image.scaledHeight() + diff;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + diff));
            this.newLine();
        }
    }

    private void initPage() throws DocumentException {
        float tmpIndentRight;
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList();
        this.pageResources = new PageResources();
        this.writer.resetContent();
        ++this.pageN;
        float oldleading = this.leading;
        int oldAlignment = this.alignment;
        this.marginLeft = this.nextMarginLeft;
        this.marginRight = this.nextMarginRight;
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
        this.imageEnd = -1.0f;
        this.imageIndentRight = 0.0f;
        this.imageIndentLeft = 0.0f;
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.beginText();
        this.text.moveText(this.left(), this.top());
        this.textEmptySize = this.text.size();
        this.text.reset();
        this.text.beginText();
        this.leading = 16.0f;
        this.indentBottom = 0.0f;
        this.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.pageSize = this.nextPageSize;
        this.thisCropSize = this.cropSize;
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null || this.pageSize.grayFill() > 0.0f) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            float[] mt = this.watermark.matrix();
            this.addImage(this.graphics, this.watermark, mt[0], mt[1], mt[2], mt[3], this.watermark.offsetX() - mt[4], this.watermark.offsetY() - mt[5]);
        }
        if (this.footer != null) {
            float tmpIndentLeft = this.indentLeft;
            tmpIndentRight = this.indentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.moveText(this.left(), this.indentBottom());
            this.flushLines();
            this.text.moveText(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - 0.75f * this.leading);
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 2.0f;
            this.currentHeight = 0.0f;
            this.indentLeft = tmpIndentLeft;
            this.indentRight = tmpIndentRight;
        }
        this.text.moveText(this.left(), this.top());
        if (this.header != null) {
            float tmpIndentLeft = this.indentLeft;
            tmpIndentRight = this.indentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.moveText(0.0f, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0.0f;
            this.indentLeft = tmpIndentLeft;
            this.indentRight = tmpIndentRight;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.leading = oldleading;
        this.alignment = oldAlignment;
        this.carriageReturn();
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            if (this.firstPageEvent) {
                pageEvent.onOpenDocument(this.writer, this);
            }
            pageEvent.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.height();
                    this.lines.add(this.line);
                    this.pageEmpty = false;
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.imageIndentRight = 0.0f;
            this.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void newLine() throws DocumentException {
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        boolean newline = false;
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
            newline = true;
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        Object[] currentValues = new Object[2];
        PdfFont currentFont = null;
        float displacement = 0.0f;
        Float lastBaseFactor = Float.valueOf(0.0f);
        currentValues[1] = lastBaseFactor;
        for (PdfLine l : this.lines) {
            if (this.isParagraphE && this.isNewpage && newline) {
                newline = false;
                this.text.moveText(l.indentLeft() - this.indentLeft() + this.listIndentLeft + this.paraIndent, -l.height());
            } else {
                this.text.moveText(l.indentLeft() - this.indentLeft() + this.listIndentLeft, -l.height());
            }
            if (l.listSymbol() != null) {
                PdfChunk chunk = l.listSymbol();
                this.text.moveText(-l.listIndent(), 0.0f);
                if (chunk.font().compareTo(currentFont) != 0) {
                    currentFont = chunk.font();
                    this.text.setFontAndSize(currentFont.getFont(), currentFont.size());
                }
                if (chunk.color() != null) {
                    Color color = chunk.color();
                    this.text.setColorFill(color);
                    this.text.showText(chunk.toString());
                    this.text.resetRGBColorFill();
                } else if (chunk.isImage()) {
                    Image image = chunk.getImage();
                    float[] matrix = image.matrix();
                    float xMarker = this.text.getXTLM();
                    float yMarker = this.text.getYTLM();
                    matrix[4] = xMarker + chunk.getImageOffsetX() - matrix[4];
                    matrix[5] = yMarker + chunk.getImageOffsetY() - matrix[5];
                    this.addImage(this.graphics, image, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                } else {
                    this.text.showText(chunk.toString());
                }
                this.text.moveText(l.listIndent(), 0.0f);
            }
            currentValues[0] = currentFont;
            this.writeLineToContent(l, this.text, this.graphics, currentValues, this.writer.getSpaceCharRatio());
            currentFont = (PdfFont)currentValues[0];
            displacement += l.height();
            if (this.indentLeft() - this.listIndentLeft == l.indentLeft()) continue;
            this.text.moveText(this.indentLeft() - l.indentLeft() - this.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return displacement;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pages) {
        PdfCatalog catalog = this.rootOutline.getKids().size() > 0 ? new PdfCatalog(pages, this.rootOutline.indirectReference()) : new PdfCatalog(pages);
        if (this.openActionName != null) {
            PdfAction action = this.getLocalGotoAction(this.openActionName);
            catalog.setOpenAction(action);
        } else if (this.openActionAction != null) {
            catalog.setOpenAction(this.openActionAction);
        }
        if (this.additionalActions != null) {
            catalog.setAdditionalActions(this.additionalActions);
        }
        if (this.pageLabels != null) {
            catalog.setPageLabels(this.pageLabels);
        }
        catalog.addNames(this.localDestinations, this.documentJavaScript, this.writer);
        catalog.setViewerPreferences(this.viewerPreferences);
        if (this.acroForm.isValid()) {
            try {
                catalog.setAcroForm(this.writer.addToBody(this.acroForm).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
        return catalog;
    }

    float bottom(Table table) {
        float h = this.currentHeight > 0.0f ? this.indentTop() - this.currentHeight - 2.0f * this.leading : this.indentTop();
        PdfTable tmp = new PdfTable(table, this.indentLeft(), this.indentRight(), h);
        return tmp.bottom();
    }

    boolean fitsPage(PdfPTable table, float margin) {
        float totalWidth = (this.indentRight() - this.indentLeft()) * table.getWidthPercentage() / 100.0f;
        table.setTotalWidth(totalWidth);
        return table.getTotalHeight() <= this.indentTop() - this.currentHeight - this.indentBottom() - margin;
    }

    private float indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentTop);
    }

    float indentBottom() {
        return this.bottom(this.indentBottom);
    }

    void addOutline(PdfOutline outline, String name) {
        this.localDestination(name, outline.getPdfDestination());
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    void writeLineToContent(PdfLine line, PdfContentByte text, PdfContentByte graphics, Object[] currentValues, float ratio) throws DocumentException {
        float xMarker;
        boolean isJustified;
        PdfFont currentFont = (PdfFont)currentValues[0];
        float lastBaseFactor = ((Float)currentValues[1]).floatValue();
        float hangingCorrection = 0.0f;
        int numberOfSpaces = line.numberOfSpaces();
        int lineLen = line.toString().length();
        boolean bl = isJustified = line.hasToBeJustified() && (numberOfSpaces != 0 || lineLen > 1);
        if (isJustified) {
            if (line.isNewlineSplit() && line.widthLeft() >= lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f)) {
                if (line.isRTL()) {
                    text.moveText(line.widthLeft() - lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f), 0.0f);
                }
                text.setWordSpacing(ratio * lastBaseFactor);
                text.setCharacterSpacing(lastBaseFactor);
            } else {
                char c;
                String s;
                float width = line.widthLeft();
                PdfChunk last = line.getChunk(line.size() - 1);
                if (last != null && (s = last.toString()).length() > 0 && hangingPunctuation.indexOf(c = s.charAt(s.length() - 1)) >= 0) {
                    float oldWidth = width;
                    hangingCorrection = (width += last.font().width(c) * 0.4f) - oldWidth;
                }
                float baseFactor = width / (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f);
                text.setWordSpacing(ratio * baseFactor);
                text.setCharacterSpacing(baseFactor);
                lastBaseFactor = baseFactor;
            }
        }
        int lastChunkStroke = line.getLastStrokeChunk();
        int chunkStrokeIdx = 0;
        float baseXMarker = xMarker = text.getXTLM();
        float yMarker = text.getYTLM();
        boolean adjustMatrix = false;
        Iterator j = line.iterator();
        while (j.hasNext()) {
            PdfChunk chunk = (PdfChunk)j.next();
            Color color = chunk.color();
            if (chunkStrokeIdx <= lastChunkStroke) {
                boolean isStroked = chunk.isAttribute("STRIKETHRU") || chunk.isAttribute("UNDERLINE");
                float width = isJustified ? chunk.getWidthCorrected(lastBaseFactor, ratio * lastBaseFactor) : chunk.width();
                if (chunk.isStroked()) {
                    float descender;
                    float subtract;
                    PdfChunk nextChunk = line.getChunk(chunkStrokeIdx + 1);
                    if (isStroked) {
                        graphics.setLineWidth(chunk.font().size() / 15.0f);
                        if (color != null) {
                            graphics.setColorStroke(color);
                        }
                    }
                    float shift = chunk.font().size() / 3.0f;
                    if (chunk.isAttribute("STRIKETHRU")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("STRIKETHRU")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        graphics.moveTo(xMarker, yMarker + shift);
                        graphics.lineTo(xMarker + width - subtract, yMarker + shift);
                        graphics.stroke();
                    }
                    if (chunk.isAttribute("UNDERLINE")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("UNDERLINE")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        graphics.moveTo(xMarker, yMarker - shift);
                        graphics.lineTo(xMarker + width - subtract, yMarker - shift);
                        graphics.stroke();
                    }
                    if (chunk.isAttribute("ACTION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("ACTION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.annotations.add(new PdfAnnotation(this.writer, xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size(), (PdfAction)chunk.getAttribute("ACTION")));
                    }
                    if (chunk.isAttribute("REMOTEGOTO")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("REMOTEGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[] obj = (Object[])chunk.getAttribute("REMOTEGOTO");
                        String filename = (String)obj[0];
                        if (obj[1] instanceof String) {
                            this.remoteGoto(filename, (String)obj[1], xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        } else {
                            this.remoteGoto(filename, (Integer)obj[1], xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        }
                    }
                    if (chunk.isAttribute("LOCALGOTO")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localGoto((String)chunk.getAttribute("LOCALGOTO"), xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                    }
                    if (chunk.isAttribute("LOCALDESTINATION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALDESTINATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localDestination((String)chunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, xMarker, yMarker + chunk.font().size(), 0.0f));
                    }
                    if (chunk.isAttribute("GENERICTAG")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("GENERICTAG")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Rectangle rect = new Rectangle(xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        PdfPageEvent pev = this.writer.getPageEvent();
                        if (pev != null) {
                            pev.onGenericTag(this.writer, this, rect, (String)chunk.getAttribute("GENERICTAG"));
                        }
                    }
                    if (chunk.isAttribute("BACKGROUND")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("BACKGROUND")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        float fontSize = chunk.font().size();
                        float ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
                        descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
                        graphics.setColorFill((Color)chunk.getAttribute("BACKGROUND"));
                        graphics.rectangle(xMarker, yMarker + descender, width - subtract, ascender - descender);
                        graphics.fill();
                        graphics.setGrayFill(0.0f);
                    }
                    if (chunk.isAttribute("PDFANNOTATION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("PDFANNOTATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        float fontSize = chunk.font().size();
                        float ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
                        descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
                        PdfAnnotation annot = PdfFormField.shallowDuplicate((PdfAnnotation)chunk.getAttribute("PDFANNOTATION"));
                        annot.put(PdfName.RECT, new PdfRectangle(xMarker, yMarker + descender, xMarker + width - subtract, yMarker + ascender));
                        this.addAnnotation(annot);
                    }
                    if (chunk.isAttribute("SKEW")) {
                        float[] params = (float[])chunk.getAttribute("SKEW");
                        text.setTextMatrix(1.0f, params[0], params[1], 1.0f, xMarker, yMarker);
                    }
                    if (chunk.isImage()) {
                        Image image = chunk.getImage();
                        float[] matrix = image.matrix();
                        matrix[4] = xMarker + chunk.getImageOffsetX() - matrix[4];
                        matrix[5] = yMarker + chunk.getImageOffsetY() - matrix[5];
                        this.addImage(graphics, image, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                        text.moveText(xMarker + lastBaseFactor + image.scaledWidth() - text.getXTLM(), 0.0f);
                    }
                    if (isStroked) {
                        graphics.setLineWidth(chunk.font().size() / 15.0f);
                        if (color != null) {
                            graphics.resetRGBColorStroke();
                        }
                    }
                }
                xMarker += width;
                ++chunkStrokeIdx;
            }
            if (chunk.font().compareTo(currentFont) != 0) {
                currentFont = chunk.font();
                text.setFontAndSize(currentFont.getFont(), currentFont.size());
            }
            float rise = 0.0f;
            Object[] textRender = (Object[])chunk.getAttribute("TEXTRENDERMODE");
            int tr = 0;
            float strokeWidth = 1.0f;
            Color strokeColor = null;
            Float fr = (Float)chunk.getAttribute("SUBSUPSCRIPT");
            if (textRender != null) {
                tr = (Integer)textRender[0] & 3;
                if (tr != 0) {
                    text.setTextRenderingMode(tr);
                }
                if (tr == 1 || tr == 2) {
                    strokeWidth = ((Float)textRender[1]).floatValue();
                    if (strokeWidth != 1.0f) {
                        text.setLineWidth(strokeWidth);
                    }
                    if ((strokeColor = (Color)textRender[2]) == null) {
                        strokeColor = color;
                    }
                    if (strokeColor != null) {
                        text.setColorStroke(strokeColor);
                    }
                }
            }
            if (fr != null) {
                rise = fr.floatValue();
            }
            if (color != null) {
                text.setColorFill(color);
            }
            if (rise != 0.0f) {
                text.setTextRise(rise);
            }
            if (chunk.isImage()) {
                adjustMatrix = true;
            } else if (isJustified && numberOfSpaces > 0 && chunk.isSpecialEncoding()) {
                String s = chunk.toString();
                int idx = s.indexOf(32);
                if (idx < 0) {
                    text.showText(chunk.toString());
                } else {
                    float spaceCorrection = -ratio * lastBaseFactor * 1000.0f / chunk.font.size();
                    PdfTextArray textArray = new PdfTextArray(s.substring(0, idx));
                    int lastIdx = idx;
                    while ((idx = s.indexOf(32, lastIdx + 1)) >= 0) {
                        textArray.add(spaceCorrection);
                        textArray.add(s.substring(lastIdx, idx));
                        lastIdx = idx;
                    }
                    textArray.add(spaceCorrection);
                    textArray.add(s.substring(lastIdx));
                    text.showText(textArray);
                }
            } else {
                text.showText(chunk.toString());
            }
            if (rise != 0.0f) {
                text.setTextRise(0.0f);
            }
            if (color != null) {
                text.resetRGBColorFill();
            }
            if (tr != 0) {
                text.setTextRenderingMode(0);
            }
            if (strokeColor != null) {
                text.resetRGBColorStroke();
            }
            if (strokeWidth != 1.0f) {
                text.setLineWidth(1.0f);
            }
            if (!chunk.isAttribute("SKEW")) continue;
            adjustMatrix = true;
            text.setTextMatrix(xMarker, yMarker);
        }
        if (isJustified) {
            text.setWordSpacing(0.0f);
            text.setCharacterSpacing(0.0f);
            if (line.isNewlineSplit()) {
                lastBaseFactor = 0.0f;
            }
        }
        if (adjustMatrix) {
            text.moveText(baseXMarker - text.getXTLM(), 0.0f);
        }
        currentValues[0] = currentFont;
        currentValues[1] = Float.valueOf(lastBaseFactor);
    }

    void localGoto(String name, float llx, float lly, float urx, float ury) {
        PdfAction action = this.getLocalGotoAction(name);
        this.annotations.add(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    PdfAction getLocalGotoAction(String name) {
        PdfAction action;
        Object[] obj = (Object[])this.localDestinations.get(name);
        if (obj == null) {
            obj = new Object[3];
        }
        if (obj[0] == null) {
            if (obj[1] == null) {
                obj[1] = this.writer.getPdfIndirectReference();
            }
            action = new PdfAction((PdfIndirectReference)obj[1]);
            obj[0] = action;
            this.localDestinations.put(name, obj);
        } else {
            action = (PdfAction)obj[0];
        }
        return action;
    }

    boolean localDestination(String name, PdfDestination destination) {
        Object[] obj = (Object[])this.localDestinations.get(name);
        if (obj == null) {
            obj = new Object[3];
        }
        if (obj[2] != null) {
            return false;
        }
        obj[2] = destination;
        this.localDestinations.put(name, obj);
        destination.addPage(this.writer.getCurrentPage());
        return true;
    }

    void remoteGoto(String filename, String name, float llx, float lly, float urx, float ury) {
        this.annotations.add(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, name)));
    }

    void remoteGoto(String filename, int page, float llx, float lly, float urx, float ury) {
        this.annotations.add(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, page)));
    }

    public void setViewerPreferences(int preferences) {
        this.viewerPreferences |= preferences;
    }

    void setAction(PdfAction action, float llx, float lly, float urx, float ury) {
        this.annotations.add(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    void setOpenAction(String name) {
        this.openActionName = name;
        this.openActionAction = null;
    }

    void setOpenAction(PdfAction action) {
        this.openActionAction = action;
        this.openActionName = null;
    }

    void addAdditionalAction(PdfName actionType, PdfAction action) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        this.additionalActions.put(actionType, action);
    }

    void setPageLabels(PdfPageLabels pageLabels) {
        this.pageLabels = pageLabels;
    }

    void addJavaScript(PdfAction js) {
        if (js.get(PdfName.JS) == null) {
            throw new RuntimeException("Only JavaScript actions are allowed.");
        }
        try {
            this.documentJavaScript.add(this.writer.addToBody(js).getIndirectReference());
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    void setCropBoxSize(Rectangle crop) {
        this.cropSize = new Rectangle(crop);
    }

    void addCalculationOrder(PdfFormField formField) {
        this.acroForm.addCalculationOrder(formField);
    }

    void setSigFlags(int f) {
        this.acroForm.setSigFlags(f);
    }

    void addFormFieldRaw(PdfFormField field) {
        this.annotations.add(field);
        ArrayList kids = field.getKids();
        if (kids != null) {
            for (int k = 0; k < kids.size(); ++k) {
                this.addFormFieldRaw((PdfFormField)kids.get(k));
            }
        }
    }

    void addAnnotation(PdfAnnotation annot) {
        this.pageEmpty = false;
        if (annot.isForm()) {
            PdfFormField field = (PdfFormField)annot;
            if (field.getParent() == null) {
                this.addFormFieldRaw(field);
            }
        } else {
            this.annotations.add(annot);
        }
    }

    void setDuration(int seconds) {
        this.duration = seconds > 0 ? seconds : -1;
    }

    void setTransition(PdfTransition transition) {
        this.transition = transition;
    }

    void setPageAction(PdfName actionType, PdfAction action) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(actionType, action);
    }

    boolean isStrictImageSequence() {
        return this.strictImageSequence;
    }

    void setStrictImageSequence(boolean strictImageSequence) {
        this.strictImageSequence = strictImageSequence;
    }

    void setPageEmpty(boolean pageEmpty) {
        this.pageEmpty = pageEmpty;
    }

    @Override
    public void clearTextWrap() throws DocumentException {
        super.clearTextWrap();
        float tmpHeight = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            tmpHeight += this.line.height();
        }
        if (this.imageEnd > -1.0f && tmpHeight > 0.0f) {
            this.carriageReturn();
            this.currentHeight += tmpHeight;
        }
    }

    class PdfCatalog
    extends PdfDictionary {
        PdfCatalog(PdfIndirectReference pages) {
            super(CATALOG);
            this.put(PdfName.PAGES, pages);
        }

        PdfCatalog(PdfIndirectReference pages, PdfIndirectReference outlines) {
            super(CATALOG);
            this.put(PdfName.PAGES, pages);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, outlines);
        }

        void addNames(TreeMap localDestinations, ArrayList documentJavaScript, PdfWriter writer) {
            if (localDestinations.size() == 0 && documentJavaScript.size() == 0) {
                return;
            }
            try {
                PdfDictionary names = new PdfDictionary();
                if (localDestinations.size() > 0) {
                    PdfArray ar = new PdfArray();
                    for (String name : localDestinations.keySet()) {
                        Object[] obj = (Object[])localDestinations.get(name);
                        PdfIndirectReference ref = (PdfIndirectReference)obj[1];
                        ar.add(new PdfString(name));
                        ar.add(ref);
                    }
                    PdfDictionary dests = new PdfDictionary();
                    dests.put(PdfName.NAMES, ar);
                    names.put(PdfName.DESTS, writer.addToBody(dests).getIndirectReference());
                }
                if (documentJavaScript.size() > 0) {
                    String[] s = new String[documentJavaScript.size()];
                    for (int k = 0; k < s.length; ++k) {
                        s[k] = Integer.toHexString(k);
                    }
                    Arrays.sort(s, new StringCompare());
                    PdfArray ar = new PdfArray();
                    for (int k = 0; k < s.length; ++k) {
                        ar.add(new PdfString(s[k]));
                        ar.add((PdfIndirectReference)documentJavaScript.get(k));
                    }
                    PdfDictionary js = new PdfDictionary();
                    js.put(PdfName.NAMES, ar);
                    names.put(PdfName.JAVASCRIPT, writer.addToBody(js).getIndirectReference());
                }
                this.put(PdfName.NAMES, writer.addToBody(names).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }

        void setViewerPreferences(int preferences) {
            if ((preferences & 1) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.SINGLEPAGE);
            } else if ((preferences & 2) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.ONECOLUMN);
            } else if ((preferences & 4) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNLEFT);
            } else if ((preferences & 8) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNRIGHT);
            }
            if ((preferences & 0x10) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USENONE);
            } else if ((preferences & 0x20) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            } else if ((preferences & 0x40) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USETHUMBS);
            } else if ((preferences & 0x80) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.FULLSCREEN);
            }
            if ((preferences & 0x3FF00) == 0) {
                return;
            }
            PdfDictionary vp = new PdfDictionary();
            if ((preferences & 0x100) != 0) {
                vp.put(PdfName.HIDETOOLBAR, PdfBoolean.PDFTRUE);
            }
            if ((preferences & 0x200) != 0) {
                vp.put(PdfName.HIDEMENUBAR, PdfBoolean.PDFTRUE);
            }
            if ((preferences & 0x400) != 0) {
                vp.put(PdfName.HIDEWINDOWUI, PdfBoolean.PDFTRUE);
            }
            if ((preferences & 0x800) != 0) {
                vp.put(PdfName.FITWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((preferences & 0x1000) != 0) {
                vp.put(PdfName.CENTERWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((preferences & 0x2000) != 0) {
                vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USENONE);
            } else if ((preferences & 0x4000) != 0) {
                vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOUTLINES);
            } else if ((preferences & 0x8000) != 0) {
                vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USETHUMBS);
            }
            if ((preferences & 0x10000) != 0) {
                vp.put(PdfName.DIRECTION, PdfName.L2R);
            } else if ((preferences & 0x20000) != 0) {
                vp.put(PdfName.DIRECTION, PdfName.R2L);
            }
            this.put(PdfName.VIEWERPREFERENCES, vp);
        }

        void setOpenAction(PdfAction action) {
            this.put(PdfName.OPENACTION, action);
        }

        void setAdditionalActions(PdfDictionary actions) {
            try {
                this.put(PdfName.AA, PdfDocument.this.writer.addToBody(actions).getIndirectReference());
            }
            catch (Exception e) {
                new ExceptionConverter(e);
            }
        }

        void setPageLabels(PdfPageLabels pageLabels) {
            this.put(PdfName.PAGELABELS, pageLabels.getDictionary());
        }

        void setAcroForm(PdfObject fields) {
            this.put(PdfName.ACROFORM, fields);
        }
    }

    public class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String author, String title, String subject) {
            this();
            this.addTitle(title);
            this.addSubject(subject);
            this.addAuthor(author);
        }

        void addTitle(String title) {
            this.put(PdfName.TITLE, new PdfString(title, "UnicodeBig"));
        }

        void addSubject(String subject) {
            this.put(PdfName.SUBJECT, new PdfString(subject, "UnicodeBig"));
        }

        void addKeywords(String keywords) {
            this.put(PdfName.KEYWORDS, new PdfString(keywords, "UnicodeBig"));
        }

        void addAuthor(String author) {
            this.put(PdfName.AUTHOR, new PdfString(author, "UnicodeBig"));
        }

        void addCreator(String creator) {
            this.put(PdfName.CREATOR, new PdfString(creator, "UnicodeBig"));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString(Document.getVersion()));
        }

        void addCreationDate() {
            PdfDate date = new PdfDate();
            this.put(PdfName.CREATIONDATE, date);
            this.put(PdfName.MODDATE, date);
        }

        void addkey(String key, String value) {
            if (key.equals("Producer") || key.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(key), new PdfString(value, "UnicodeBig"));
        }
    }
}

