/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.pdf.BaseFont;
import quadbase.common.util.output.pdf.IntHashtable;

public class PdfEncodings {
    protected static final int CIDNONE = 0;
    protected static final int CIDRANGE = 1;
    protected static final int CIDCHAR = 2;
    static final char[] winansiByteToChar = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\u017d', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\u017e', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    static final char[] pdfEncodingByteToChar = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2014', '\u2013', '\u0192', '\u2044', '\ufffd', '\ufffd', '\u2212', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2019', '\u201a', '\u2122', '\ufb01', '\ufb02', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\ufffd', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    static final IntHashtable winansi = new IntHashtable();
    static final IntHashtable pdfEncoding = new IntHashtable();
    static final HashMap cmaps;
    public static final byte[][] CRLF_CID_NEWLINE;

    public static final byte[] convertToBytes(String text, String encoding) {
        if (text == null) {
            return new byte[0];
        }
        if (encoding == null || encoding.length() == 0) {
            int len = text.length();
            byte[] b = new byte[len];
            for (int k = 0; k < len; ++k) {
                b[k] = (byte)text.charAt(k);
            }
            return b;
        }
        IntHashtable hash = null;
        if (encoding.equals("Cp1252")) {
            hash = winansi;
        } else if (encoding.equals("PDF")) {
            hash = pdfEncoding;
        }
        if (hash != null) {
            int len = text.length();
            byte[] b = new byte[len];
            int c = 0;
            for (int k = 0; k < len; ++k) {
                int char1 = text.charAt(k);
                c = char1 < 128 || char1 >= 160 && char1 <= 255 ? char1 : hash.get(char1);
                b[k] = (byte)c;
            }
            return b;
        }
        if (encoding.equals("UnicodeBig")) {
            char[] cc = text.toCharArray();
            int len = cc.length;
            byte[] b = new byte[cc.length * 2 + 2];
            b[0] = -2;
            b[1] = -1;
            int bptr = 2;
            for (int k = 0; k < len; ++k) {
                char c = cc[k];
                b[bptr++] = (byte)(c >> 8);
                b[bptr++] = (byte)(c & 0xFF);
            }
            return b;
        }
        try {
            return text.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExceptionConverter(e);
        }
    }

    public static final String convertToString(byte[] bytes, String encoding) {
        if (bytes == null) {
            return "";
        }
        if (encoding == null || encoding.length() == 0) {
            char[] c = new char[bytes.length];
            for (int k = 0; k < bytes.length; ++k) {
                c[k] = (char)(bytes[k] & 0xFF);
            }
            return new String(c);
        }
        char[] ch = null;
        if (encoding.equals("Cp1252")) {
            ch = winansiByteToChar;
        } else if (encoding.equals("PDF")) {
            ch = pdfEncodingByteToChar;
        }
        if (ch != null) {
            int len = bytes.length;
            char[] c = new char[len];
            for (int k = 0; k < len; ++k) {
                c[k] = ch[bytes[k] & 0xFF];
            }
            return new String(c);
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExceptionConverter(e);
        }
    }

    public static boolean isPdfDocEncoding(String text) {
        if (text == null) {
            return true;
        }
        int len = text.length();
        for (int k = 0; k < len; ++k) {
            char char1 = text.charAt(k);
            if (char1 < '\u0080' || char1 >= '\u00a0' && char1 <= '\u00ff' || pdfEncoding.containsKey(char1)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCmap(String name) {
        HashMap hashMap = cmaps;
        synchronized (hashMap) {
            if (name.length() == 0) {
                cmaps.clear();
            } else {
                cmaps.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCmap(String name, byte[][] newline) {
        block8: {
            try {
                char[][] planes = null;
                HashMap hashMap = cmaps;
                synchronized (hashMap) {
                    planes = (char[][])cmaps.get(name);
                }
                if (planes != null) break block8;
                planes = PdfEncodings.readCmap(name, newline);
                hashMap = cmaps;
                synchronized (hashMap) {
                    cmaps.put(name, planes);
                }
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    public static String convertCmap(String name, byte[] seq) {
        return PdfEncodings.convertCmap(name, seq, 0, seq.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertCmap(String name, byte[] seq, int start, int length) {
        try {
            char[][] planes = null;
            HashMap hashMap = cmaps;
            synchronized (hashMap) {
                planes = (char[][])cmaps.get(name);
            }
            if (planes == null) {
                planes = PdfEncodings.readCmap(name, (byte[][])null);
                hashMap = cmaps;
                synchronized (hashMap) {
                    cmaps.put(name, planes);
                }
            }
            return PdfEncodings.decodeSequence(seq, start, length, planes);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    static String decodeSequence(byte[] seq, int start, int length, char[][] planes) {
        StringBuffer buf = new StringBuffer();
        int end = start + length;
        int currentPlane = 0;
        for (int k = start; k < end; ++k) {
            char[] plane = planes[currentPlane];
            int one = seq[k] & 0xFF;
            char cid = plane[one];
            if ((cid & 0x8000) == 0) {
                buf.append(cid);
                currentPlane = 0;
                continue;
            }
            currentPlane = cid & Short.MAX_VALUE;
        }
        return buf.toString();
    }

    static char[][] readCmap(String name, byte[][] newline) throws IOException {
        ArrayList<char[]> planes = new ArrayList<char[]>();
        planes.add(new char[256]);
        PdfEncodings.readCmap(name, planes);
        if (newline != null) {
            for (int k = 0; k < newline.length; ++k) {
                PdfEncodings.encodeSequence(newline[k].length, newline[k], Short.MAX_VALUE, planes);
            }
        }
        char[][] ret = new char[planes.size()][];
        return (char[][])planes.toArray((T[])ret);
    }

    static void readCmap(String name, ArrayList planes) throws IOException {
        String fullName = "fonts/cmaps/" + name;
        InputStream in = BaseFont.getResourceStream(fullName);
        if (in == null) {
            throw new IOException("The Cmap " + name + " was not found.");
        }
        PdfEncodings.encodeStream(in, planes);
        in.close();
    }

    static void encodeStream(InputStream in, ArrayList planes) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader(in, "iso-8859-1"));
        String line = null;
        int state = 0;
        byte[] seqs = new byte[7];
        block5: while ((line = rd.readLine()) != null) {
            if (line.length() < 6) continue;
            switch (state) {
                case 0: {
                    if (line.indexOf("begincidrange") >= 0) {
                        state = 1;
                        break;
                    }
                    if (line.indexOf("begincidchar") >= 0) {
                        state = 2;
                        break;
                    }
                    if (line.indexOf("usecmap") < 0) break;
                    StringTokenizer tk = new StringTokenizer(line);
                    String t = tk.nextToken();
                    PdfEncodings.readCmap(t.substring(1), planes);
                    break;
                }
                case 1: {
                    if (line.indexOf("endcidrange") >= 0) {
                        state = 0;
                        break;
                    }
                    StringTokenizer tk = new StringTokenizer(line);
                    String t = tk.nextToken();
                    int size = t.length() / 2 - 1;
                    long start = Long.parseLong(t.substring(1, t.length() - 1), 16);
                    t = tk.nextToken();
                    long end = Long.parseLong(t.substring(1, t.length() - 1), 16);
                    t = tk.nextToken();
                    int cid = Integer.parseInt(t);
                    for (long k = start; k <= end; ++k) {
                        PdfEncodings.breakLong(k, size, seqs);
                        PdfEncodings.encodeSequence(size, seqs, (char)cid, planes);
                        ++cid;
                    }
                    continue block5;
                }
                case 2: {
                    if (line.indexOf("endcidchar") >= 0) {
                        state = 0;
                        break;
                    }
                    StringTokenizer tk = new StringTokenizer(line);
                    String t = tk.nextToken();
                    int size = t.length() / 2 - 1;
                    long start = Long.parseLong(t.substring(1, t.length() - 1), 16);
                    t = tk.nextToken();
                    int cid = Integer.parseInt(t);
                    PdfEncodings.breakLong(start, size, seqs);
                    PdfEncodings.encodeSequence(size, seqs, (char)cid, planes);
                    break;
                }
            }
        }
    }

    static void breakLong(long n, int size, byte[] seqs) {
        for (int k = 0; k < size; ++k) {
            seqs[k] = (byte)(n >> (size - 1 - k) * 8);
        }
    }

    static void encodeSequence(int size, byte[] seqs, char cid, ArrayList planes) {
        int one;
        --size;
        int nextPlane = 0;
        for (int idx = 0; idx < size; ++idx) {
            int one2;
            char[] plane = (char[])planes.get(nextPlane);
            char c = plane[one2 = seqs[idx] & 0xFF];
            if (c != '\u0000' && (c & 0x8000) == 0) {
                throw new RuntimeException("Inconsistent mapping.");
            }
            if (c == '\u0000') {
                planes.add(new char[256]);
                plane[one2] = c = (char)(planes.size() - 1 | 0x8000);
            }
            nextPlane = c & Short.MAX_VALUE;
        }
        char[] plane = (char[])planes.get(nextPlane);
        char c = plane[one = seqs[size] & 0xFF];
        if ((c & 0x8000) != 0) {
            throw new RuntimeException("Inconsistent mapping.");
        }
        plane[one] = cid;
    }

    static {
        winansi.put(8364, 128);
        winansi.put(8218, 130);
        winansi.put(402, 131);
        winansi.put(8222, 132);
        winansi.put(8230, 133);
        winansi.put(8224, 134);
        winansi.put(8225, 135);
        winansi.put(710, 136);
        winansi.put(8240, 137);
        winansi.put(352, 138);
        winansi.put(8249, 139);
        winansi.put(338, 140);
        winansi.put(381, 142);
        winansi.put(8216, 145);
        winansi.put(8217, 146);
        winansi.put(8220, 147);
        winansi.put(8221, 148);
        winansi.put(8226, 149);
        winansi.put(8211, 150);
        winansi.put(8212, 151);
        winansi.put(732, 152);
        winansi.put(8482, 153);
        winansi.put(353, 154);
        winansi.put(8250, 155);
        winansi.put(339, 156);
        winansi.put(382, 158);
        winansi.put(376, 159);
        pdfEncoding.put(8226, 128);
        pdfEncoding.put(8224, 129);
        pdfEncoding.put(8225, 130);
        pdfEncoding.put(8230, 131);
        pdfEncoding.put(8212, 132);
        pdfEncoding.put(8211, 133);
        pdfEncoding.put(402, 134);
        pdfEncoding.put(8260, 135);
        pdfEncoding.put(8722, 138);
        pdfEncoding.put(8217, 144);
        pdfEncoding.put(8218, 145);
        pdfEncoding.put(8482, 146);
        pdfEncoding.put(64257, 147);
        pdfEncoding.put(64258, 148);
        pdfEncoding.put(321, 149);
        pdfEncoding.put(338, 150);
        pdfEncoding.put(352, 151);
        pdfEncoding.put(376, 152);
        pdfEncoding.put(381, 153);
        pdfEncoding.put(305, 154);
        pdfEncoding.put(322, 155);
        pdfEncoding.put(339, 156);
        pdfEncoding.put(353, 157);
        pdfEncoding.put(382, 158);
        pdfEncoding.put(8364, 160);
        cmaps = new HashMap();
        CRLF_CID_NEWLINE = new byte[][]{{10}, {13, 10}};
    }
}

