/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfLiteral;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfRectangle;
import quadbase.common.util.output.pdf.PdfStream;
import quadbase.common.util.output.pdf.PdfTemplate;

public class PdfFormXObject
extends PdfStream {
    public static final PdfNumber ZERO = new PdfNumber(0);
    public static final PdfNumber ONE = new PdfNumber(1);
    public static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate template) {
        PdfArray matrix;
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.FORM);
        this.put(PdfName.RESOURCES, template.getResources());
        this.put(PdfName.BBOX, new PdfRectangle(template.getBoundingBox()));
        this.put(PdfName.FORMTYPE, ONE);
        if (template.getGroup() != null) {
            this.put(PdfName.GROUP, template.getGroup());
        }
        if ((matrix = template.getMatrix()) == null) {
            this.put(PdfName.MATRIX, MATRIX);
        } else {
            this.put(PdfName.MATRIX, matrix);
        }
        this.bytes = template.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        try {
            this.flateCompress();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

