/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.Png;
import quadbase.common.util.output.pdf.BadPdfFormatException;
import quadbase.common.util.output.pdf.ByteBuffer;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfBoolean;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfException;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfLiteral;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfStream;
import quadbase.common.util.output.pdf.PdfString;

class PdfImage
extends PdfStream {
    static final int TRANSFERSIZE = 4096;
    protected PdfName name = null;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PdfImage(Image image, String name, PdfIndirectReference maskRef) throws BadPdfFormatException {
        super();
        this.name = new PdfName(name);
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.IMAGE);
        this.put(PdfName.NAME, this.name);
        this.put(PdfName.WIDTH, new PdfNumber(image.width()));
        this.put(PdfName.HEIGHT, new PdfNumber(image.height()));
        if (maskRef != null) {
            this.put(PdfName.MASK, maskRef);
        }
        if (image.isMask() && image.isInvertMask()) {
            this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
        }
        if (image.isInterpolation()) {
            this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
        }
        is = null;
        try {
            if (image.isImgRaw()) {
                colorspace = image.colorspace();
                transparency = image.getTransparency();
                if (transparency != null && !image.isMask() && maskRef == null) {
                    s = "[";
                    for (k = 0; k < transparency.length; ++k) {
                        s = s + transparency[k] + " ";
                    }
                    s = s + "]";
                    this.put(PdfName.MASK, new PdfLiteral(s));
                }
                this.bytes = image.rawData();
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                bpc = image.bpc();
                if (bpc > 255) {
                    if (!image.isMask()) {
                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                    this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                    k = bpc - 257;
                    decodeparms = new PdfDictionary();
                    if (k != 0) {
                        decodeparms.put(PdfName.K, new PdfNumber(k));
                    }
                    if ((colorspace & 1) != 0) {
                        decodeparms.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                    }
                    if ((colorspace & 2) != 0) {
                        decodeparms.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                    }
                    if ((colorspace & 4) != 0) {
                        decodeparms.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                    }
                    if ((colorspace & 8) != 0) {
                        decodeparms.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                    }
                    decodeparms.put(PdfName.COLUMNS, new PdfNumber(image.width()));
                    decodeparms.put(PdfName.ROWS, new PdfNumber(image.height()));
                    this.put(PdfName.DECODEPARMS, decodeparms);
                } else {
                    if (!image.isMask()) {
                        switch (colorspace) {
                            case 1: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                break;
                            }
                            case 3: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                break;
                            }
                            default: {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            }
                        }
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(image.bpc()));
                    try {
                        this.flateCompress();
                    }
                    catch (PdfException pe) {
                        throw new ExceptionConverter(pe);
                    }
                }
                if (image.isMask() == false) return;
                this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
                return;
            }
            if (image.rawData() == null) {
                is = image.url().openStream();
                errorID = image.url().toString();
            } else {
                is = new ByteArrayInputStream(image.rawData());
                errorID = "Byte array";
            }
            this.streamBytes = new ByteArrayOutputStream();
            i = 0;
            block13 : switch (image.type()) {
                case 33: {
                    this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                    for (int element : Png.PNGID) {
                        if (element == is.read()) continue;
                        throw new BadPdfFormatException(errorID + " is not a PNG file.");
                    }
                    colorType = 0;
                    block46: while (true) {
                        len = Png.getInt(is);
                        marker = Png.getString(is);
                        if ("IDAT".equals(marker)) {
                            PdfImage.transferBytes(is, this.streamBytes, len);
                            Png.getInt(is);
                            continue;
                        }
                        if ("tRNS".equals(marker) && !image.isMask() && maskRef == null) {
                            block18 : switch (colorType) {
                                case 0: {
                                    if (len < 2) break;
                                    len -= 2;
                                    gray = Png.getWord(is);
                                    this.put(PdfName.MASK, new PdfLiteral("[" + gray + " " + gray + "]"));
                                    break;
                                }
                                case 2: {
                                    if (len < 6) break;
                                    len -= 6;
                                    red = Png.getWord(is);
                                    green = Png.getWord(is);
                                    blue = Png.getWord(is);
                                    this.put(PdfName.MASK, new PdfLiteral("[" + red + " " + red + " " + green + " " + green + " " + blue + " " + blue + "]"));
                                    break;
                                }
                                case 3: {
                                    if (len <= 0) break;
                                    idx = 0;
                                    while (len-- != 0) {
                                        if (is.read() == 0) {
                                            this.put(PdfName.MASK, new PdfLiteral("[" + idx + " " + idx + "]"));
                                            break block18;
                                        }
                                        ++idx;
                                    }
                                    break;
                                }
                            }
                            Image.skip(is, len + 4);
                            continue;
                        }
                        if ("IHDR".equals(marker)) {
                            w = Png.getInt(is);
                            h = Png.getInt(is);
                            bitDepth = is.read();
                            if (bitDepth == 16) {
                                throw new BadPdfFormatException(errorID + " Bit depth 16 is not suported.");
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(bitDepth));
                            colorType = is.read();
                            if (colorType != 0 && colorType != 2 && colorType != 3) {
                                throw new BadPdfFormatException(errorID + " Colortype " + colorType + " is not suported.");
                            }
                            if (colorType == 0) {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                            } else if (colorType == 2) {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                            }
                            compressionMethod = is.read();
                            filterMethod = is.read();
                            interlaceMethod = is.read();
                            if (interlaceMethod != 0) {
                                throw new BadPdfFormatException(errorID + " Interlace method " + interlaceMethod + " is not suported.");
                            }
                            decodeparms = new PdfDictionary();
                            decodeparms.put(PdfName.BITSPERCOMPONENT, new PdfNumber(bitDepth));
                            decodeparms.put(PdfName.PREDICTOR, new PdfNumber(15));
                            decodeparms.put(PdfName.COLUMNS, new PdfNumber(w));
                            decodeparms.put(PdfName.COLORS, new PdfNumber(colorType == 2 ? 3 : 1));
                            this.put(PdfName.DECODEPARMS, decodeparms);
                            Png.getInt(is);
                            continue;
                        }
                        if ("PLTE".equals(marker)) {
                            if (colorType == 3) {
                                colorspace = new PdfArray();
                                colorspace.add(PdfName.INDEXED);
                                colorspace.add(PdfName.DEVICERGB);
                                colorspace.add(new PdfNumber(len / 3 - 1));
                                colortable = new ByteBuffer();
                                while (len-- > 0) {
                                    colortable.append_i(is.read());
                                }
                                colorspace.add(new PdfString(colortable.toByteArray()));
                                this.put(PdfName.COLORSPACE, colorspace);
                                Png.getInt(is);
                                continue;
                            }
                            Image.skip(is, len + 4);
                            continue;
                        }
                        if ("IEND".equals(marker)) break block13;
                        j = -4;
                        while (true) {
                            if (j < len) ** break;
                            continue block46;
                            is.read();
                            ++j;
                        }
                        break;
                    }
                }
                case 32: {
                    this.put(PdfName.FILTER, PdfName.DCTDECODE);
                    switch (image.colorspace()) {
                        case 1: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                            break;
                        }
                        case 3: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                            break;
                        }
                        default: {
                            this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            if (!image.isInvertedJPEG()) break;
                            this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                        }
                    }
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                    if (image.rawData() != null) {
                        this.bytes = image.rawData();
                        this.streamBytes = null;
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        return;
                    }
                    PdfImage.transferBytes(is, this.streamBytes, -1);
                    break;
                }
                case 31: {
                    if (is.read() != 71) throw new BadPdfFormatException(errorID + " is not a GIF-file (GIF header not found).");
                    if (is.read() != 73) throw new BadPdfFormatException(errorID + " is not a GIF-file (GIF header not found).");
                    if (is.read() != 70) {
                        throw new BadPdfFormatException(errorID + " is not a GIF-file (GIF header not found).");
                    }
                    for (j = 0; j < 8; ++j) {
                        i = is.read();
                    }
                    nColors = 0;
                    colorTable = null;
                    if ((i & 128) == 128) {
                        nColors = 2 << (i & 7);
                        is.read();
                        is.read();
                        colorTable = new ByteBuffer();
                        for (j = 0; j < nColors; ++j) {
                            colorTable.append_i(is.read());
                            colorTable.append_i(is.read());
                            colorTable.append_i(is.read());
                        }
                    }
                    foundImageSeperator = false;
                    block52: while (!foundImageSeperator) {
                        gifField = is.read();
                        switch (gifField) {
                            case 44: {
                                foundImageSeperator = true;
                                for (j = 0; j < 8; ++j) {
                                    is.read();
                                }
                                packedFields = is.read();
                                if ((packedFields & 64) != 0) {
                                    throw new BadPdfFormatException(errorID + " is not a supported GIF-file (interlaced gifs are not supported).");
                                }
                                if ((packedFields & 128) != 0) {
                                    nColors = 2 << (i & 7);
                                    is.read();
                                    is.read();
                                    colorTable = new ByteBuffer();
                                    for (j = 0; j < nColors; ++j) {
                                        colorTable.append_i(is.read());
                                        colorTable.append_i(is.read());
                                        colorTable.append_i(is.read());
                                    }
                                }
                                if (is.read() != 8) {
                                    throw new BadPdfFormatException(errorID + " is not a supported GIF-file (initial LZW code not supported).");
                                }
                                code = 0;
                                codelength = 9;
                                tablelength = 257;
                                bitsread = 0;
                                bitstowrite = 0;
                                bitsdone = 0;
                                bitsleft = 23;
                                bytesdone = 0;
                                bytesread = 0;
                                byteswritten = 0;
                                size = is.read();
                                if (size < 1) {
                                    throw new BadPdfFormatException(errorID + " is not a supported GIF-file. (no image data found).");
                                }
                                ++bytesread;
                                bitsread = is.read();
                                if (--size > 0) {
                                    ++bytesread;
                                    bitsread += is.read() << 8;
                                    if (--size > 0) {
                                        --size;
                                        ++bytesread;
                                        bitsread += is.read() << 16;
                                    }
                                }
                                while (bytesread > byteswritten) {
                                    ++tablelength;
                                    code = bitsread >> bitsdone & (1 << codelength) - 1;
                                    bytesdone = (bitsdone + codelength) / 8;
                                    bitsdone = (bitsdone + codelength) % 8;
                                    while (bytesdone > 0) {
                                        --bytesdone;
                                        bitsread >>= 8;
                                        if (size > 0) {
                                            --size;
                                            ++bytesread;
                                            bitsread += is.read() << 16;
                                            continue;
                                        }
                                        size = is.read();
                                        if (size <= 0) continue;
                                        --size;
                                        ++bytesread;
                                        bitsread += is.read() << 16;
                                    }
                                    bitstowrite += code << bitsleft - codelength + 1;
                                    bitsleft -= codelength;
                                    while (bitsleft < 16) {
                                        this.streamBytes.write(bitstowrite >> 16);
                                        ++byteswritten;
                                        bitstowrite = (bitstowrite & 65535) << 8;
                                        bitsleft += 8;
                                    }
                                    if (code == 256) {
                                        codelength = 9;
                                        tablelength = 257;
                                    }
                                    if (code == 257) break;
                                    if (tablelength != 1 << codelength || codelength >= 12) continue;
                                    ++codelength;
                                }
                                if (bytesread - byteswritten <= 2) continue block52;
                                throw new BadPdfFormatException(errorID + " is not a supported GIF-file (unexpected end of data block).");
                            }
                            case 33: {
                                extensionLabel = is.read();
                                switch (extensionLabel) {
                                    case 249: {
                                        is.read();
                                        field = is.read();
                                        is.read();
                                        is.read();
                                        trf = is.read();
                                        if ((field & 1) != 0) {
                                            this.put(PdfName.MASK, new PdfLiteral("[" + trf + " " + trf + "]"));
                                        }
                                        len = 0;
                                        while ((len = is.read()) != 0) {
                                            is.skip(len);
                                        }
                                        continue block52;
                                    }
                                    case 1: 
                                    case 254: 
                                    case 255: {
                                        len = 0;
                                        while ((len = is.read()) != 0) {
                                            is.skip(len);
                                        }
                                        continue block52;
                                    }
                                }
                                throw new BadPdfFormatException(errorID + " is not a supported GIF-file (bad extension identifier).");
                            }
                            case 59: {
                                continue block52;
                            }
                        }
                        throw new BadPdfFormatException(errorID + " is not a supported GIF-file (bad data block identifier).");
                    }
                    if (colorTable == null) {
                        throw new BadPdfFormatException(errorID + " is not a supported GIF-file (there is nor a global, nor a local color table present).");
                    }
                    this.put(PdfName.FILTER, PdfName.LZWDECODE);
                    decodeparms = new PdfDictionary();
                    decodeparms.put(PdfName.EARLYCHANGE, new PdfNumber(0));
                    this.put(PdfName.DECODEPARMS, decodeparms);
                    colorspace = new PdfArray();
                    colorspace.add(PdfName.INDEXED);
                    colorspace.add(PdfName.DEVICERGB);
                    colorspace.add(new PdfNumber(nColors - 1));
                    colorspace.add(new PdfString(colorTable.toByteArray()));
                    this.put(PdfName.COLORSPACE, colorspace);
                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                    break;
                }
                default: {
                    throw new BadPdfFormatException(errorID + " is an unknown Image format.");
                }
            }
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            return;
        }
        catch (IOException ioe) {
            throw new BadPdfFormatException(ioe.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception var25_57) {}
            }
        }
    }

    public PdfName name() {
        return this.name;
    }

    static void transferBytes(InputStream in, OutputStream out, int len) throws IOException {
        byte[] buffer = new byte[4096];
        if (len < 0) {
            len = 0x7FFFFFF;
        }
        while (len != 0) {
            int size = in.read(buffer, 0, Math.min(len, 4096));
            if (size < 0) {
                return;
            }
            out.write(buffer, 0, size);
            len -= size;
        }
    }
}

