/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.Color;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.ColumnText;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfPCell;
import quadbase.common.util.output.pdf.PdfPCellEvent;
import quadbase.common.util.output.pdf.PdfPTable;

public class PdfPRow {
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;

    public PdfPRow(PdfPCell[] cells) {
        this.cells = cells;
        this.widths = new float[cells.length];
    }

    public PdfPRow(PdfPRow row) {
        this.maxHeight = row.maxHeight;
        this.calculated = row.calculated;
        this.cells = new PdfPCell[row.cells.length];
        for (int k = 0; k < this.cells.length; ++k) {
            if (row.cells[k] == null) continue;
            this.cells[k] = new PdfPCell(row.cells[k]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(row.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] widths) {
        if (widths.length != this.cells.length) {
            return false;
        }
        System.arraycopy(widths, 0, this.widths, 0, this.cells.length);
        float total = 0.0f;
        this.calculated = false;
        for (int k = 0; k < widths.length; ++k) {
            PdfPCell cell = this.cells[k];
            cell.setLeft(total);
            int last = k + cell.getColspan();
            while (k < last) {
                total += widths[k];
                ++k;
            }
            --k;
            cell.setRight(total);
            cell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int k = 0; k < this.cells.length; ++k) {
            PdfPCell cell = this.cells[k];
            if (cell == null) continue;
            PdfPTable table = cell.getTable();
            Image img = cell.getImage();
            if (img != null) {
                img.scalePercent(100.0f);
                float scale = (cell.right() - cell.getPaddingRight() - cell.getPaddingLeft() - cell.left()) / img.scaledWidth();
                img.scalePercent(scale * 100.0f);
                cell.setBottom(cell.top() - cell.getPaddingTop() - cell.getPaddingBottom() - img.scaledHeight());
            } else if (table == null) {
                float rightLimit = cell.isNoWrap() ? 20000.0f : cell.right() - cell.getPaddingRight();
                ColumnText ct = new ColumnText(null);
                ct.setSimpleColumn(cell.getPhrase(), cell.left() + cell.getPaddingLeft(), cell.top() - cell.getPaddingTop(), rightLimit, -20000.0f, 0.0f, cell.getHorizontalAlignment());
                ct.setLeading(cell.getLeading(), cell.getMultipliedLeading());
                ct.setIndent(cell.getIndent());
                ct.setExtraParagraphSpace(cell.getExtraParagraphSpace());
                ct.setFollowingIndent(cell.getFollowingIndent());
                ct.setRightIndent(cell.getRightIndent());
                ct.setRunDirection(cell.getRunDirection());
                ct.setArabicOptions(cell.getArabicOptions());
                try {
                    ct.go(true);
                }
                catch (DocumentException e) {
                    throw new ExceptionConverter(e);
                }
                float yLine = ct.getYLine();
                cell.setBottom(yLine - cell.getPaddingBottom());
            } else {
                table.setTotalWidth(cell.right() - cell.getPaddingRight() - cell.getPaddingLeft() - cell.left());
                cell.setBottom(cell.top() - cell.getPaddingTop() - cell.getPaddingBottom() - table.getTotalHeight());
            }
            float height = cell.getFixedHeight();
            if (height <= 0.0f) {
                height = cell.height();
            }
            if (height < cell.getFixedHeight()) {
                height = cell.getFixedHeight();
            } else if (height < cell.getMinimumHeight()) {
                height = cell.getMinimumHeight();
            }
            if (!(height > this.maxHeight)) continue;
            this.maxHeight = height;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackgroung(float xPos, float yPos, PdfPCell cell, PdfContentByte[] canvases) {
        PdfContentByte lines = canvases[2];
        PdfContentByte backgr = canvases[1];
        float x1 = cell.left() + xPos;
        float y2 = cell.top() + yPos;
        float x2 = cell.right() + xPos;
        float y1 = y2 - this.maxHeight;
        Color background = cell.backgroundColor();
        if (background != null) {
            backgr.setColorFill(background);
            backgr.rectangle(x1, y1, x2 - x1, y2 - y1);
            backgr.fill();
        } else if (cell.grayFill() > 0.0f) {
            backgr.setGrayFill(cell.grayFill());
            backgr.rectangle(x1, y1, x2 - x1, y2 - y1);
            backgr.fill();
        }
        if (cell.hasBorders()) {
            Color color;
            if (cell.borderWidth() != -1.0f) {
                lines.setLineWidth(cell.borderWidth());
            }
            if ((color = cell.borderColor()) != null) {
                lines.setColorStroke(color);
            }
            if (cell.hasBorder(15)) {
                lines.rectangle(x1, y1, x2 - x1, y2 - y1);
            } else {
                if (cell.hasBorder(8)) {
                    lines.moveTo(x2, y1);
                    lines.lineTo(x2, y2);
                }
                if (cell.hasBorder(4)) {
                    lines.moveTo(x1, y1);
                    lines.lineTo(x1, y2);
                }
                if (cell.hasBorder(2)) {
                    lines.moveTo(x1, y1);
                    lines.lineTo(x2, y1);
                }
                if (cell.hasBorder(1)) {
                    lines.moveTo(x1, y2);
                    lines.lineTo(x2, y2);
                }
            }
            lines.stroke();
            if (color != null) {
                lines.resetRGBColorStroke();
            }
        }
    }

    public void writeCells(int colStart, int colEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        int newStart;
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (colEnd < 0) {
            colEnd = this.cells.length;
        }
        colEnd = Math.min(colEnd, this.cells.length);
        if (colStart < 0) {
            colStart = 0;
        }
        if (colStart >= colEnd) {
            return;
        }
        for (newStart = colStart; newStart >= 0 && this.cells[newStart] == null; --newStart) {
            xPos -= this.widths[newStart - 1];
        }
        xPos -= this.cells[newStart].left();
        for (int k = newStart; k < colEnd; ++k) {
            PdfPCellEvent evt;
            PdfPCell cell = this.cells[k];
            if (cell == null) continue;
            this.writeBorderAndBackgroung(xPos, yPos, cell, canvases);
            PdfPTable table = cell.getTable();
            Image img = cell.getImage();
            float tly = 0.0f;
            boolean alignTop = false;
            switch (cell.getVerticalAlignment()) {
                case 6: {
                    tly = cell.top() + yPos - this.maxHeight + cell.height() - cell.getPaddingTop();
                    break;
                }
                case 5: {
                    tly = cell.top() + yPos + (cell.height() - this.maxHeight) / 2.0f - cell.getPaddingTop();
                    break;
                }
                default: {
                    alignTop = true;
                    tly = cell.top() + yPos - cell.getPaddingTop();
                }
            }
            if (img != null) {
                boolean vf = false;
                if (cell.height() > this.maxHeight) {
                    img.scalePercent(100.0f);
                    float scale = (this.maxHeight - cell.getPaddingTop() - cell.getPaddingBottom()) / img.scaledHeight();
                    img.scalePercent(scale * 100.0f);
                    vf = true;
                }
                float left = cell.left() + xPos + cell.getPaddingLeft();
                if (vf) {
                    switch (cell.getHorizontalAlignment()) {
                        case 1: {
                            left = xPos + (cell.left() + cell.getPaddingLeft() + cell.right() - cell.getPaddingRight() - img.scaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            left = xPos + cell.right() - cell.getPaddingRight() - img.scaledWidth();
                            break;
                        }
                    }
                    tly = cell.top() + yPos - cell.getPaddingTop();
                }
                img.setAbsolutePosition(left, tly - img.scaledHeight());
                try {
                    canvases[3].addImage(img);
                }
                catch (DocumentException e) {
                    throw new ExceptionConverter(e);
                }
            } else if (table == null) {
                float fixedHeight = cell.getFixedHeight();
                float rightLimit = cell.right() + xPos - cell.getPaddingRight();
                float leftLimit = cell.left() + xPos + cell.getPaddingLeft();
                if (cell.isNoWrap()) {
                    switch (cell.getHorizontalAlignment()) {
                        case 1: {
                            rightLimit += 10000.0f;
                            leftLimit -= 10000.0f;
                            break;
                        }
                        case 2: {
                            leftLimit -= 20000.0f;
                            break;
                        }
                        default: {
                            rightLimit += 20000.0f;
                        }
                    }
                }
                ColumnText ct = new ColumnText(canvases[3]);
                float bry = -20000.0f;
                if (fixedHeight > 0.0f && cell.height() > this.maxHeight) {
                    tly = cell.top() + yPos - cell.getPaddingTop();
                    bry = cell.top() + yPos - this.maxHeight + cell.getPaddingBottom();
                }
                ct.setSimpleColumn(cell.getPhrase(), leftLimit, tly, rightLimit, bry, 0.0f, cell.getHorizontalAlignment());
                ct.setLeading(cell.getLeading(), cell.getMultipliedLeading());
                ct.setIndent(cell.getIndent());
                ct.setExtraParagraphSpace(cell.getExtraParagraphSpace());
                ct.setFollowingIndent(cell.getFollowingIndent());
                ct.setRightIndent(cell.getRightIndent());
                ct.setSpaceCharRatio(cell.getSpaceCharRatio());
                ct.setRunDirection(cell.getRunDirection());
                ct.setArabicOptions(cell.getArabicOptions());
                try {
                    ct.go();
                }
                catch (DocumentException e) {
                    throw new ExceptionConverter(e);
                }
            } else {
                float remainingHeight = 0.0f;
                float maxLastRow = 0.0f;
                if (alignTop && table.size() > 0) {
                    PdfPRow row = table.getRow(table.size() - 1);
                    remainingHeight = this.maxHeight - table.getTotalHeight() - cell.getPaddingBottom() - cell.getPaddingTop();
                    if (remainingHeight > 0.0f) {
                        maxLastRow = row.getMaxHeights();
                        row.setMaxHeights(row.getMaxHeights() + remainingHeight);
                    }
                }
                table.writeSelectedRows(0, -1, cell.left() + xPos + cell.getPaddingLeft(), tly, canvases);
                if (alignTop && remainingHeight > 0.0f) {
                    table.getRow(table.size() - 1).setMaxHeights(maxLastRow);
                }
            }
            if ((evt = cell.getCellEvent()) == null) continue;
            Rectangle rect = new Rectangle(cell.left() + xPos, cell.top() + yPos - this.maxHeight, cell.right() + xPos, cell.top() + yPos);
            evt.cellLayout(cell, rect, canvases);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float maxHeight) {
        this.maxHeight = maxHeight;
    }

    float[] getEventWidth(float xPos) {
        int n = 0;
        for (int k = 0; k < this.cells.length; ++k) {
            if (this.cells[k] == null) continue;
            ++n;
        }
        float[] width = new float[n + 1];
        n = 0;
        width[n++] = xPos;
        for (int k = 0; k < this.cells.length; ++k) {
            if (this.cells[k] == null) continue;
            width[n] = width[n - 1] + this.cells[k].width();
            ++n;
        }
        return width;
    }
}

