/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfPatternPainter;
import quadbase.common.util.output.pdf.PdfRectangle;
import quadbase.common.util.output.pdf.PdfStream;

public class PdfPattern
extends PdfStream {
    PdfPattern(PdfPatternPainter painter) {
        PdfNumber one = new PdfNumber(1);
        PdfArray matrix = painter.getMatrix();
        if (matrix != null) {
            this.put(PdfName.MATRIX, matrix);
        }
        this.put(PdfName.TYPE, PdfName.PATTERN);
        this.put(PdfName.BBOX, new PdfRectangle(painter.getBoundingBox()));
        this.put(PdfName.RESOURCES, painter.getResources());
        this.put(PdfName.TILINGTYPE, one);
        this.put(PdfName.PATTERNTYPE, one);
        if (painter.isStencil()) {
            this.put(PdfName.PAINTTYPE, new PdfNumber(2));
        } else {
            this.put(PdfName.PAINTTYPE, one);
        }
        this.put(PdfName.XSTEP, new PdfNumber(painter.getXStep()));
        this.put(PdfName.YSTEP, new PdfNumber(painter.getYStep()));
        this.bytes = painter.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        try {
            this.flateCompress();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

