/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import quadbase.common.util.output.pdf.PRStream;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfImportedPage;
import quadbase.common.util.output.pdf.PdfLiteral;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfRectangle;
import quadbase.common.util.output.pdf.PdfStream;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.RandomAccessFileOrArray;

class PdfReaderInstance {
    static final PdfLiteral IDENTITYMATRIX = new PdfLiteral("[1 0 0 1 0 0]");
    static final PdfNumber ONE = new PdfNumber(1);
    PdfObject[] xrefObj;
    PdfDictionary[] pages;
    int[] myXref;
    PdfReader reader;
    RandomAccessFileOrArray file;
    HashMap importedPages = new HashMap();
    PdfWriter writer;
    HashMap visited = new HashMap();
    ArrayList nextRound = new ArrayList();

    PdfReaderInstance(PdfReader reader, PdfWriter writer, PdfObject[] xrefObj, PdfDictionary[] pages) {
        this.reader = reader;
        this.xrefObj = xrefObj;
        this.pages = pages;
        this.writer = writer;
        this.file = reader.getSafeFile();
        this.myXref = new int[xrefObj.length];
    }

    PdfReader getReader() {
        return this.reader;
    }

    PdfImportedPage getImportedPage(int pageNumber) {
        if (pageNumber < 1 || pageNumber > this.pages.length) {
            throw new IllegalArgumentException("Invalid page number");
        }
        Integer i = pageNumber;
        PdfImportedPage pageT = (PdfImportedPage)this.importedPages.get(i);
        if (pageT == null) {
            pageT = new PdfImportedPage(this, this.writer, pageNumber);
            this.importedPages.put(i, pageT);
        }
        return pageT;
    }

    int getNewObjectNumber(int number, int generation) {
        if (this.myXref[number] == 0) {
            this.myXref[number] = this.writer.getIndirectReferenceNumber();
            this.nextRound.add(number);
        }
        return this.myXref[number];
    }

    RandomAccessFileOrArray getReaderFile() {
        return this.file;
    }

    PdfObject getResources(int pageNumber) {
        return PdfReader.getPdfObject(this.pages[pageNumber - 1].get(PdfName.RESOURCES));
    }

    PdfStream getFormXObject(int pageNumber) throws IOException {
        PRStream stream;
        PdfDictionary page = this.pages[pageNumber - 1];
        PdfObject contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS));
        PdfDictionary dic = new PdfDictionary();
        byte[] bout = null;
        Object filters = null;
        if (contents != null) {
            if (contents.type() == 7) {
                dic.putAll((PRStream)contents);
            } else {
                bout = this.reader.getPageContent(pageNumber, this.file);
            }
        }
        dic.put(PdfName.RESOURCES, PdfReader.getPdfObject(page.get(PdfName.RESOURCES)));
        dic.put(PdfName.TYPE, PdfName.XOBJECT);
        dic.put(PdfName.SUBTYPE, PdfName.FORM);
        PdfImportedPage impPage = (PdfImportedPage)this.importedPages.get(pageNumber);
        dic.put(PdfName.BBOX, new PdfRectangle(impPage.getBoundingBox()));
        PdfArray matrix = impPage.getMatrix();
        if (matrix == null) {
            dic.put(PdfName.MATRIX, IDENTITYMATRIX);
        } else {
            dic.put(PdfName.MATRIX, matrix);
        }
        dic.put(PdfName.FORMTYPE, ONE);
        if (bout == null) {
            stream = new PRStream((PRStream)contents, dic);
        } else {
            stream = new PRStream(this.reader, bout);
            stream.putAll(dic);
        }
        return stream;
    }

    void writeAllVisited() throws IOException {
        while (this.nextRound.size() > 0) {
            ArrayList vec = this.nextRound;
            this.nextRound = new ArrayList();
            for (int k = 0; k < vec.size(); ++k) {
                Integer i = (Integer)vec.get(k);
                if (this.visited.containsKey(i)) continue;
                this.visited.put(i, null);
                int n = i;
                this.writer.addToBody(this.xrefObj[n], this.myXref[n]);
            }
        }
    }

    void writeAllPages() throws IOException {
        try {
            this.file.reOpen();
            for (PdfImportedPage ip : this.importedPages.values()) {
                this.writer.addToBody((PdfObject)ip.getFormXObject(), ip.getIndirectReference());
            }
            this.writeAllVisited();
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
    }
}

