/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfString;

public class PdfSignature
extends PdfDictionary {
    public PdfSignature(String filter) {
        this.put(PdfName.FILTER, new PdfName(filter));
    }

    public void setSubFilter(String filter) {
        this.put(PdfName.SUBFILTER, new PdfName(filter));
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        for (int k = 0; k < range.length; ++k) {
            array.add(new PdfNumber(range[k]));
        }
        this.put(PdfName.BYTERANGE, array);
    }

    public void setContents(byte[] contents) {
        this.put(PdfName.CONTENTS, new PdfString(contents));
    }

    public void setName(String name) {
        this.put(PdfName.NAME, new PdfString(name, "UnicodeBig"));
    }

    public void setDate(String date) {
        this.put(PdfName.M, new PdfString(date));
    }

    public void setLocation(String name) {
        this.put(PdfName.LOCATION, new PdfString(name, "UnicodeBig"));
    }

    public void setReason(String name) {
        this.put(PdfName.REASON, new PdfString(name, "UnicodeBig"));
    }

    public void setString(String name, byte[] value) {
        this.put(new PdfName(name), new PdfString(value));
    }

    public void setString(String name, String value) {
        this.put(new PdfName(name), new PdfString(value, "UnicodeBig"));
    }

    public void setStringAsName(String name, String value) {
        this.put(new PdfName(name), new PdfName(value));
    }
}

