/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import quadbase.common.util.output.DocListener;
import quadbase.common.util.output.DocWriter;
import quadbase.common.util.output.Document;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.Image;
import quadbase.common.util.output.ImgWMF;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.Table;
import quadbase.common.util.output.pdf.BaseFont;
import quadbase.common.util.output.pdf.ColorDetails;
import quadbase.common.util.output.pdf.ExtendedColor;
import quadbase.common.util.output.pdf.FontDetails;
import quadbase.common.util.output.pdf.OutputStreamCounter;
import quadbase.common.util.output.pdf.PRIndirectReference;
import quadbase.common.util.output.pdf.PdfAcroForm;
import quadbase.common.util.output.pdf.PdfAction;
import quadbase.common.util.output.pdf.PdfAnnotation;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfContents;
import quadbase.common.util.output.pdf.PdfDestination;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfDocument;
import quadbase.common.util.output.pdf.PdfEncryption;
import quadbase.common.util.output.pdf.PdfException;
import quadbase.common.util.output.pdf.PdfFormField;
import quadbase.common.util.output.pdf.PdfICCBased;
import quadbase.common.util.output.pdf.PdfImage;
import quadbase.common.util.output.pdf.PdfImportedPage;
import quadbase.common.util.output.pdf.PdfIndirectObject;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfOutline;
import quadbase.common.util.output.pdf.PdfPTable;
import quadbase.common.util.output.pdf.PdfPage;
import quadbase.common.util.output.pdf.PdfPageEvent;
import quadbase.common.util.output.pdf.PdfPageLabels;
import quadbase.common.util.output.pdf.PdfPages;
import quadbase.common.util.output.pdf.PdfPatternPainter;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfReaderInstance;
import quadbase.common.util.output.pdf.PdfShading;
import quadbase.common.util.output.pdf.PdfShadingPattern;
import quadbase.common.util.output.pdf.PdfSpotColor;
import quadbase.common.util.output.pdf.PdfTemplate;
import quadbase.common.util.output.pdf.PdfTransition;
import quadbase.common.util.output.pdf.RandomAccessFileOrArray;
import quadbase.common.util.output.pdf.SpotColor;

public class PdfWriter
extends DocWriter {
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageModeUseNone = 16;
    public static final int PageModeUseOutlines = 32;
    public static final int PageModeUseThumbs = 64;
    public static final int PageModeFullScreen = 128;
    public static final int HideToolbar = 256;
    public static final int HideMenubar = 512;
    public static final int HideWindowUI = 1024;
    public static final int FitWindow = 2048;
    public static final int CenterWindow = 4096;
    public static final int NonFullScreenPageModeUseNone = 8192;
    public static final int NonFullScreenPageModeUseOutlines = 16384;
    public static final int NonFullScreenPageModeUseThumbs = 32768;
    public static final int DirectionL2R = 65536;
    public static final int DirectionR2L = 131072;
    static final int ViewerPreferencesMask = 261888;
    public static final int AllowPrinting = 2052;
    public static final int AllowModifyContents = 8;
    public static final int AllowCopy = 16;
    public static final int AllowModifyAnnotations = 32;
    public static final int AllowFillIn = 256;
    public static final int AllowScreenReaders = 512;
    public static final int AllowAssembly = 1024;
    public static final int AllowDegradedPrinting = 4;
    public static final boolean STRENGTH40BITS = false;
    public static final boolean STRENGTH128BITS = true;
    public static final PdfName DOCUMENT_CLOSE = PdfName.DC;
    public static final PdfName WILL_SAVE = PdfName.WS;
    public static final PdfName DID_SAVE = PdfName.DS;
    public static final PdfName WILL_PRINT = PdfName.WP;
    public static final PdfName DID_PRINT = PdfName.DP;
    public static final PdfName PAGE_OPEN = PdfName.O;
    public static final PdfName PAGE_CLOSE = PdfName.C;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    public static final char VERSION_1_5 = '5';
    private static final int VPOINT = 7;
    protected byte[] HEADER = PdfWriter.getISOBytes("%PDF-1.4\n%\u00e2\u00e3\u00cf\u00d3\n");
    protected PdfPages root = new PdfPages(this);
    protected PdfDictionary imageDictionary = new PdfDictionary();
    private HashMap images = new HashMap();
    private HashMap imageFiles = new HashMap();
    protected HashMap formXObjects = new HashMap();
    protected int formXObjectsCounter = 1;
    protected int fontNumber = 1;
    protected int colorNumber = 1;
    protected int patternNumber = 1;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected HashMap documentFonts = new HashMap();
    protected HashMap documentColors = new HashMap();
    protected HashMap documentPatterns = new HashMap();
    protected HashMap documentShadings = new HashMap();
    protected HashMap documentShadingPatterns = new HashMap();
    protected ColorDetails patternColorspaceRGB;
    protected ColorDetails patternColorspaceGRAY;
    protected ColorDetails patternColorspaceCMYK;
    protected HashMap documentSpotPatterns = new HashMap();
    protected HashMap documentExtGState = new HashMap();
    protected PdfBody body;
    protected PdfDocument pdf;
    private PdfPageEvent pageEvent;
    protected PdfEncryption crypto;
    protected HashMap importedPages = new HashMap();
    protected PdfReaderInstance currentPdfReaderInstance;
    protected ArrayList pageReferences = new ArrayList();
    protected int currentPageNumber = 1;
    protected PdfDictionary group;
    public static final float SPACE_CHAR_RATIO_DEFAULT = 2.5f;
    public static final float NO_SPACE_CHAR_RATIO = 1.0E7f;
    public static final int RUN_DIRECTION_DEFAULT = 0;
    public static final int RUN_DIRECTION_NO_BIDI = 1;
    public static final int RUN_DIRECTION_LTR = 2;
    public static final int RUN_DIRECTION_RTL = 3;
    protected int runDirection = 1;
    private float spaceCharRatio = 2.5f;
    private PdfDictionary extraCatalog;

    protected PdfWriter(PdfDocument document, OutputStream os) {
        super(document, os);
        this.pdf = document;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream os) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        document.addDocListener(pdf);
        PdfWriter writer = new PdfWriter(pdf, os);
        pdf.addWriter(writer);
        return writer;
    }

    public static PdfWriter getInstance(Document document, OutputStream os, DocListener listener) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        pdf.addDocListener(listener);
        document.addDocListener(pdf);
        PdfWriter writer = new PdfWriter(pdf, os);
        pdf.addWriter(writer);
        return writer;
    }

    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        PdfIndirectObject object;
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        try {
            object = this.body.add(contents);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
        page.add(object.getIndirectReference());
        if (this.group != null) {
            page.put(PdfName.GROUP, this.group);
            this.group = null;
        }
        this.root.addPage(page);
        ++this.currentPageNumber;
        return null;
    }

    PdfName addDirectImageSimple(Image image) throws PdfException, DocumentException {
        PdfName name = null;
        Object SerialId = this.getImageSerialId(image);
        if (SerialId != null || this.images.containsKey(image.getMySerialId())) {
            name = SerialId != null ? (PdfName)this.images.get(SerialId) : (PdfName)this.images.get(image.getMySerialId());
        } else {
            if (image.isImgTemplate()) {
                name = new PdfName("img" + this.images.size());
                if (image.templateData() == null) {
                    try {
                        ImgWMF wmf = (ImgWMF)image;
                        wmf.readWMF(this.getDirectContent().createTemplate(0.0f, 0.0f));
                    }
                    catch (Exception e) {
                        throw new DocumentException(e.getMessage());
                    }
                }
            } else {
                Image maskImage = image.getImageMask();
                PdfIndirectReference maskRef = null;
                if (maskImage != null) {
                    PdfName mname = (PdfName)this.images.get(maskImage.getMySerialId());
                    maskRef = this.getImageReference(mname);
                }
                PdfImage i = new PdfImage(image, "img" + this.images.size(), maskRef);
                if (image.hasICCProfile()) {
                    PdfICCBased icc = new PdfICCBased(image.getICCProfile());
                    PdfIndirectReference iccRef = this.add(icc);
                    PdfArray iccArray = new PdfArray();
                    iccArray.add(PdfName.ICCBASED);
                    iccArray.add(iccRef);
                    PdfObject colorspace = i.get(PdfName.COLORSPACE);
                    if (colorspace != null && colorspace.type() == 5) {
                        ArrayList ar = ((PdfArray)colorspace).getArrayList();
                        if (ar.size() > 1 && PdfName.INDEXED.equals(ar.get(0))) {
                            ar.set(1, iccArray);
                        } else {
                            i.put(PdfName.COLORSPACE, iccArray);
                        }
                    } else {
                        i.put(PdfName.COLORSPACE, iccArray);
                    }
                }
                this.add(i);
                name = i.name();
            }
            this.images.put(image.getMySerialId(), name);
            this.imageFiles.put(image.getMySerialId(), image.getFilePath());
        }
        return name;
    }

    private Object getImageSerialId(Image image) {
        Iterator it = this.imageFiles.entrySet().iterator();
        int n = this.imageFiles.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry pair = it.next();
            Object key = pair.getKey();
            Object value = pair.getValue();
            if (value == null || !((String)value).equals(image.getFilePath())) continue;
            return key;
        }
        return null;
    }

    PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage.name())) {
            PdfIndirectObject object;
            try {
                object = this.body.add(pdfImage);
            }
            catch (IOException ioe) {
                throw new ExceptionConverter(ioe);
            }
            this.imageDictionary.put(pdfImage.name(), object.getIndirectReference());
            return object.getIndirectReference();
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    protected PdfIndirectReference add(PdfICCBased icc) throws PdfException {
        PdfIndirectObject object;
        try {
            object = this.body.add(icc);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
        return object.getIndirectReference();
    }

    PdfIndirectReference getImageReference(PdfName name) {
        return (PdfIndirectReference)this.imageDictionary.get(name);
    }

    @Override
    public void open() {
        super.open();
        try {
            this.os.write(this.HEADER);
            this.body = new PdfBody(this);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        return ((PdfDocument)this.document).getCatalog(rootObj);
    }

    protected void addSharedObjectsToBody() throws IOException {
        Object template;
        for (FontDetails details : this.documentFonts.values()) {
            details.writeFont(this);
        }
        for (Object[] objs : this.formXObjects.values()) {
            template = (PdfTemplate)objs[1];
            if (template != null && ((PdfTemplate)template).getIndirectReference() instanceof PRIndirectReference || template == null || ((PdfTemplate)template).getType() != 1) continue;
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)((PdfTemplate)template).getFormXObject(), ((PdfTemplate)template).getIndirectReference());
        }
        for (PdfReaderInstance this.currentPdfReaderInstance : this.importedPages.values()) {
            this.currentPdfReaderInstance.writeAllPages();
        }
        this.currentPdfReaderInstance = null;
        for (ColorDetails color : this.documentColors.values()) {
            template = this.body.add((PdfObject)color.getSpotColor(this), color.getIndirectReference());
        }
        for (PdfPatternPainter pat : this.documentPatterns.keySet()) {
            template = this.body.add((PdfObject)pat.getPattern(), pat.getIndirectReference());
        }
        for (PdfShadingPattern shadingPattern : this.documentShadingPatterns.keySet()) {
            shadingPattern.addToBody();
        }
        for (PdfShading shading : this.documentShadings.keySet()) {
            shading.addToBody();
        }
        for (PdfDictionary gstate : this.documentExtGState.keySet()) {
            PdfObject[] obj = (PdfObject[])this.documentExtGState.get(gstate);
            this.addToBody((PdfObject)gstate, (PdfIndirectReference)obj[1]);
        }
    }

    @Override
    public synchronized void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            this.pdf.close();
            try {
                this.addSharedObjectsToBody();
                PdfIndirectReference rootRef = this.root.writePageTree();
                PdfDictionary catalog = this.getCatalog(rootRef);
                if (this.extraCatalog != null) {
                    catalog.mergeDifferent(this.extraCatalog);
                }
                PdfIndirectObject indirectCatalog = this.body.add(catalog);
                PdfIndirectObject info = this.body.add(((PdfDocument)this.document).getInfo());
                PdfIndirectReference encryption = null;
                PdfObject fileID = null;
                if (this.crypto != null) {
                    PdfIndirectObject encryptionObject = this.body.add(this.crypto.getEncryptionDictionary());
                    encryption = encryptionObject.getIndirectReference();
                    fileID = this.crypto.getFileID();
                } else {
                    fileID = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
                }
                this.body.writeCrossReferenceTable(this.os);
                PdfTrailer trailer = new PdfTrailer(this.body.size(), this.body.offset(), indirectCatalog.getIndirectReference(), info.getIndirectReference(), encryption, fileID);
                trailer.toPdf(this, this.os);
                super.close();
            }
            catch (IOException ioe) {
                throw new ExceptionConverter(ioe);
            }
        }
    }

    int size() {
        return this.body.size();
    }

    public float getTableBottom(Table table) {
        return this.pdf.bottom(table) - this.pdf.indentBottom();
    }

    public boolean fitsPage(Table table, float margin) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + margin;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean fitsPage(PdfPTable table, float margin) {
        return this.pdf.fitsPage(table, margin);
    }

    public boolean fitsPage(PdfPTable table) {
        return this.pdf.fitsPage(table, 0.0f);
    }

    boolean isPaused() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContentUnder;
    }

    void resetContent() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    public PdfAcroForm getAcroForm() {
        return this.pdf.getAcroForm();
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    OutputStreamCounter getOs() {
        return this.os;
    }

    FontDetails addSimple(BaseFont bf) {
        if (bf.getFontType() == 4) {
            return new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), bf);
        }
        FontDetails ret = (FontDetails)this.documentFonts.get(bf);
        if (ret == null) {
            ret = new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), bf);
            this.documentFonts.put(bf, ret);
        }
        return ret;
    }

    void eliminateFontSubset(PdfDictionary fonts) {
        for (FontDetails ft : this.documentFonts.values()) {
            if (fonts.get(ft.getFontName()) == null) continue;
            ft.setSubset(false);
        }
    }

    ColorDetails addSimple(PdfSpotColor spc) {
        ColorDetails ret = (ColorDetails)this.documentColors.get(spc);
        if (ret == null) {
            ret = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), spc);
            this.documentColors.put(spc, ret);
        }
        return ret;
    }

    ColorDetails addSimplePatternColorspace(Color color) {
        int type = ExtendedColor.getType(color);
        if (type == 4 || type == 5) {
            throw new RuntimeException("An uncolored tile pattern can not have another pattern or shading as color.");
        }
        try {
            switch (type) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray array = new PdfArray(PdfName.PATTERN);
                        array.add(PdfName.DEVICERGB);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)array, this.patternColorspaceRGB.getIndirectReference());
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray array = new PdfArray(PdfName.PATTERN);
                        array.add(PdfName.DEVICECMYK);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)array, this.patternColorspaceCMYK.getIndirectReference());
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray array = new PdfArray(PdfName.PATTERN);
                        array.add(PdfName.DEVICEGRAY);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)array, this.patternColorspaceGRAY.getIndirectReference());
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    ColorDetails details = this.addSimple(((SpotColor)color).getPdfSpotColor());
                    ColorDetails patternDetails = (ColorDetails)this.documentSpotPatterns.get(details);
                    if (patternDetails == null) {
                        patternDetails = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray array = new PdfArray(PdfName.PATTERN);
                        array.add(details.getIndirectReference());
                        PdfIndirectObject cobj = this.body.add((PdfObject)array, patternDetails.getIndirectReference());
                        this.documentSpotPatterns.put(details, patternDetails);
                    }
                    return patternDetails;
                }
            }
            throw new RuntimeException("Invalid color type in PdfWriter.addSimplePatternColorspace().");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void addSimpleShadingPattern(PdfShadingPattern shading) {
        if (!this.documentShadingPatterns.containsKey(shading)) {
            shading.setName(this.patternNumber);
            ++this.patternNumber;
            this.documentShadingPatterns.put(shading, null);
            this.addSimpleShading(shading.getShading());
        }
    }

    void addSimpleShading(PdfShading shading) {
        if (!this.documentShadings.containsKey(shading)) {
            this.documentShadings.put(shading, null);
            shading.setName(this.documentShadings.size());
        }
    }

    PdfObject[] addSimpleExtGState(PdfDictionary gstate) {
        if (!this.documentExtGState.containsKey(gstate)) {
            this.documentExtGState.put(gstate, new PdfObject[]{new PdfName("GS" + (this.documentExtGState.size() + 1)), this.getPdfIndirectReference()});
        }
        return (PdfObject[])this.documentExtGState.get(gstate);
    }

    PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public PdfIndirectReference getPdfIndirectReference() {
        return this.body.getPdfIndirectReference();
    }

    int getIndirectReferenceNumber() {
        return this.body.getIndirectReferenceNumber();
    }

    PdfName addSimplePattern(PdfPatternPainter painter) {
        PdfName name = (PdfName)this.documentPatterns.get(painter);
        try {
            if (name == null) {
                name = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(painter, name);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        return name;
    }

    PdfName addDirectTemplateSimple(PdfTemplate template) {
        PdfIndirectReference ref = template.getIndirectReference();
        Object[] obj = (Object[])this.formXObjects.get(ref);
        PdfName name = null;
        try {
            if (obj == null) {
                name = new PdfName("Xf" + this.formXObjectsCounter);
                ++this.formXObjectsCounter;
                if (template.getType() == 2) {
                    template = null;
                }
                this.formXObjects.put(ref, new Object[]{name, template});
            } else {
                name = (PdfName)obj[0];
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        return name;
    }

    public void setPageEvent(PdfPageEvent pageEvent) {
        this.pageEvent = pageEvent;
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    void addLocalDestinations(TreeMap dest) throws IOException {
        for (String name : dest.keySet()) {
            Object[] obj = (Object[])dest.get(name);
            PdfDestination destination = (PdfDestination)obj[2];
            if (destination == null) {
                throw new RuntimeException("The name '" + name + "' has no local destination.");
            }
            if (obj[1] == null) {
                obj[1] = this.getPdfIndirectReference();
            }
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)destination, (PdfIndirectReference)obj[1]);
        }
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    public void setViewerPreferences(int preferences) {
        this.pdf.setViewerPreferences(preferences);
    }

    public void setEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        this.crypto.setupAllKeys(userPassword, ownerPassword, permissions, strength128Bits);
    }

    public void setEncryption(boolean strength, String userPassword, String ownerPassword, int permissions) throws DocumentException {
        this.setEncryption(PdfWriter.getISOBytes(userPassword), PdfWriter.getISOBytes(ownerPassword), permissions, strength);
    }

    public PdfIndirectObject addToBody(PdfObject object) throws IOException {
        PdfIndirectObject iobj = this.body.add(object);
        return iobj;
    }

    public PdfIndirectObject addToBody(PdfObject object, PdfIndirectReference ref) throws IOException {
        PdfIndirectObject iobj = this.body.add(object, ref);
        return iobj;
    }

    public PdfIndirectObject addToBody(PdfObject object, int refNumber) throws IOException {
        PdfIndirectObject iobj = this.body.add(object, refNumber);
        return iobj;
    }

    public void setOpenAction(String name) {
        this.pdf.setOpenAction(name);
    }

    public void setAdditionalAction(PdfName actionType, PdfAction action) throws PdfException {
        if (!(actionType.equals(DOCUMENT_CLOSE) || actionType.equals(WILL_SAVE) || actionType.equals(DID_SAVE) || actionType.equals(WILL_PRINT) || actionType.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + actionType.toString());
        }
        this.pdf.addAdditionalAction(actionType, action);
    }

    public void setOpenAction(PdfAction action) {
        this.pdf.setOpenAction(action);
    }

    public void setPageLabels(PdfPageLabels pageLabels) {
        this.pdf.setPageLabels(pageLabels);
    }

    PdfEncryption getEncryption() {
        return this.crypto;
    }

    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        return this.currentPdfReaderInstance.getReaderFile();
    }

    int getNewObjectNumber(PdfReader reader, int number, int generation) {
        return this.currentPdfReaderInstance.getNewObjectNumber(number, generation);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        PdfReaderInstance inst = (PdfReaderInstance)this.importedPages.get(reader);
        if (inst == null) {
            inst = reader.getPdfReaderInstance(this);
            this.importedPages.put(reader, inst);
        }
        return inst.getImportedPage(pageNumber);
    }

    public void addJavaScript(PdfAction js) {
        this.pdf.addJavaScript(js);
    }

    public void addJavaScript(String code, boolean unicode) {
        this.addJavaScript(PdfAction.javaScript(code, this, unicode));
    }

    public void addJavaScript(String code) {
        this.addJavaScript(code, false);
    }

    public void setCropBoxSize(Rectangle crop) {
        this.pdf.setCropBoxSize(crop);
    }

    public PdfIndirectReference getPageReference(int page) {
        PdfIndirectReference ref;
        if (--page < 0) {
            throw new IndexOutOfBoundsException("The page numbers start at 1.");
        }
        if (page < this.pageReferences.size()) {
            ref = (PdfIndirectReference)this.pageReferences.get(page);
            if (ref == null) {
                ref = this.body.getPdfIndirectReference();
                this.pageReferences.set(page, ref);
            }
        } else {
            int empty = page - this.pageReferences.size();
            for (int k = 0; k < empty; ++k) {
                this.pageReferences.add(null);
            }
            ref = this.body.getPdfIndirectReference();
            this.pageReferences.add(ref);
        }
        return ref;
    }

    PdfIndirectReference getCurrentPage() {
        return this.getPageReference(this.currentPageNumber);
    }

    int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void addCalculationOrder(PdfFormField annot) {
        this.pdf.addCalculationOrder(annot);
    }

    public void setSigFlags(int f) {
        this.pdf.setSigFlags(f);
    }

    public void addAnnotation(PdfAnnotation annot) {
        this.pdf.addAnnotation(annot);
    }

    public void setPdfVersion(char version) {
        this.HEADER[7] = (byte)version;
    }

    public int reorderPages(int[] order) throws DocumentException {
        return this.root.reorderPages(order);
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float spaceCharRatio) {
        this.spaceCharRatio = spaceCharRatio < 0.001f ? 0.001f : spaceCharRatio;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 1 || runDirection > 3) {
            throw new RuntimeException("Invalid run direction: " + runDirection);
        }
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public void setDuration(int seconds) {
        this.pdf.setDuration(seconds);
    }

    public void setTransition(PdfTransition transition) {
        this.pdf.setTransition(transition);
    }

    public void freeReader(PdfReader reader) throws IOException {
        this.currentPdfReaderInstance = (PdfReaderInstance)this.importedPages.get(reader);
        if (this.currentPdfReaderInstance == null) {
            return;
        }
        this.currentPdfReaderInstance.writeAllPages();
        this.currentPdfReaderInstance = null;
        this.importedPages.remove(reader);
    }

    public void setPageAction(PdfName actionType, PdfAction action) throws PdfException {
        if (!actionType.equals(PAGE_OPEN) && !actionType.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + actionType.toString());
        }
        this.pdf.setPageAction(actionType, action);
    }

    public int getCurrentDocumentSize() {
        return this.body.offset() + this.body.size() * 20 + 72;
    }

    public boolean isStrictImageSequence() {
        return this.pdf.isStrictImageSequence();
    }

    public void setStrictImageSequence(boolean strictImageSequence) {
        this.pdf.setStrictImageSequence(strictImageSequence);
    }

    public void setPageEmpty(boolean pageEmpty) {
        this.pdf.setPageEmpty(pageEmpty);
    }

    public PdfDictionary getInfo() {
        return ((PdfDocument)this.document).getInfo();
    }

    public PdfDictionary getExtraCatalog() {
        return this.extraCatalog;
    }

    public void setExtraCatalog(PdfDictionary extraCatalog) {
        this.extraCatalog = extraCatalog;
    }

    public void setLinearPageMode() {
        this.root.setLinearMode(null);
    }

    public PdfDictionary getGroup() {
        return this.group;
    }

    public void setGroup(PdfDictionary group) {
        this.group = group;
    }

    static class PdfTrailer
    extends PdfDictionary {
        int offset;

        PdfTrailer(int size, int offset, PdfIndirectReference root, PdfIndirectReference info, PdfIndirectReference encryption, PdfObject fileID) {
            this.offset = offset;
            this.put(PdfName.SIZE, new PdfNumber(size));
            this.put(PdfName.ROOT, root);
            if (info != null) {
                this.put(PdfName.INFO, info);
            }
            if (encryption != null) {
                this.put(PdfName.ENCRYPT, encryption);
            }
            if (fileID != null) {
                this.put(PdfName.ID, fileID);
            }
        }

        @Override
        public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
            os.write(DocWriter.getISOBytes("trailer\n"));
            super.toPdf(null, os);
            os.write(DocWriter.getISOBytes("\nstartxref\n"));
            os.write(DocWriter.getISOBytes(String.valueOf(this.offset)));
            os.write(DocWriter.getISOBytes("\n%%EOF\n"));
        }
    }

    public static class PdfBody {
        private ArrayList xrefs = new ArrayList();
        private int position;
        private PdfWriter writer;

        PdfBody(PdfWriter writer) {
            this.xrefs.add(new PdfCrossReference(0, 65535));
            this.position = writer.getOs().getCounter();
            this.writer = writer;
        }

        PdfIndirectObject add(PdfObject object) throws IOException {
            PdfIndirectObject indirect = new PdfIndirectObject(this.size(), object, this.writer);
            this.xrefs.add(new PdfCrossReference(this.position));
            indirect.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return indirect;
        }

        PdfIndirectReference getPdfIndirectReference() {
            this.xrefs.add(new PdfCrossReference(0));
            return new PdfIndirectReference(0, this.size() - 1);
        }

        int getIndirectReferenceNumber() {
            this.xrefs.add(new PdfCrossReference(0));
            return this.size() - 1;
        }

        PdfIndirectObject add(PdfObject object, PdfIndirectReference ref) throws IOException {
            PdfIndirectObject indirect = new PdfIndirectObject(ref.getNumber(), object, this.writer);
            this.xrefs.set(ref.getNumber(), new PdfCrossReference(this.position));
            indirect.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return indirect;
        }

        PdfIndirectObject add(PdfObject object, int refNumber) throws IOException {
            PdfIndirectObject indirect = new PdfIndirectObject(refNumber, object, this.writer);
            this.xrefs.set(refNumber, new PdfCrossReference(this.position));
            indirect.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return indirect;
        }

        int offset() {
            return this.position;
        }

        int size() {
            return this.xrefs.size();
        }

        void writeCrossReferenceTable(OutputStream os) throws IOException {
            os.write(DocWriter.getISOBytes("xref\n0 "));
            os.write(DocWriter.getISOBytes(String.valueOf(this.size())));
            os.write(10);
            for (PdfCrossReference entry : this.xrefs) {
                entry.toPdf(null, os);
            }
        }

        static class PdfCrossReference {
            private int offset;
            private int generation;

            PdfCrossReference(int offset, int generation) {
                this.offset = offset;
                this.generation = generation;
            }

            PdfCrossReference(int offset) {
                this(offset, 0);
            }

            public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
                String s = "0000000000" + this.offset;
                StringBuffer off = new StringBuffer(s.substring(s.length() - 10));
                s = "00000" + this.generation;
                String gen = s.substring(s.length() - 5);
                if (this.generation == 65535) {
                    os.write(DocWriter.getISOBytes(off.append(' ').append(gen).append(" f \n").toString()));
                } else {
                    os.write(DocWriter.getISOBytes(off.append(' ').append(gen).append(" n \n").toString()));
                }
            }
        }
    }
}

