/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf.hyphenation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import quadbase.common.util.output.pdf.hyphenation.Hyphenation;
import quadbase.common.util.output.pdf.hyphenation.HyphenationException;
import quadbase.common.util.output.pdf.hyphenation.HyphenationTree;

public class Hyphenator {
    static Hashtable hyphenTrees = new Hashtable();
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump = false;
    private static String hyphenDir = "";

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
        this.remainCharCount = leftMin;
        this.pushCharCount = rightMin;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country) {
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = key + "_" + country;
        }
        if (hyphenTrees.containsKey(key)) {
            return (HyphenationTree)hyphenTrees.get(key);
        }
        if (hyphenTrees.containsKey(lang)) {
            return (HyphenationTree)hyphenTrees.get(lang);
        }
        HyphenationTree hTree = Hyphenator.getFopHyphenationTree(key);
        if (hTree == null && hyphenDir != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, hyphenDir);
        }
        if (hTree != null) {
            hyphenTrees.put(key, hTree);
        } else {
            System.out.println("Couldn't find hyphenation pattern " + key);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            is = Hyphenator.class.getResourceAsStream("hyph/" + key + ".hyp");
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        HyphenationTree hTree = null;
        InputStream is = null;
        try {
            block24: {
                is = Hyphenator.getResourceStream(key);
                if (is == null) {
                    if (key.length() == 5) {
                        is = Hyphenator.getResourceStream(key.substring(0, 2));
                        if (is != null) {
                            System.out.println("Couldn't find hyphenation pattern  " + key + "\nusing general language pattern " + key.substring(0, 2) + " instead.");
                            break block24;
                        } else {
                            if (errorDump) {
                                System.out.println("Couldn't find precompiled hyphenation pattern " + key + ".hyp");
                            }
                            HyphenationTree hyphenationTree = null;
                            return hyphenationTree;
                        }
                    }
                    if (errorDump) {
                        System.out.println("Couldn't find precompiled hyphenation pattern " + key + ".hyp");
                    }
                    HyphenationTree hyphenationTree = null;
                    return hyphenationTree;
                }
            }
            hTree = new HyphenationTree();
            hTree.loadInternalPatterns(is);
            return hTree;
        }
        catch (Exception e) {
            e.printStackTrace();
            return hTree;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.out.println("can't close hyphenation stream");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getUserHyphenationTree(String key, String hyphenDir) {
        HyphenationTree hTree = null;
        File hyphenFile = new File(hyphenDir, key + ".hyp");
        if (hyphenFile.exists()) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(hyphenFile));
                hTree = (HyphenationTree)ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return hTree;
        }
        hyphenFile = new File(hyphenDir, key + ".hyp");
        if (hyphenFile.exists()) {
            hTree = new HyphenationTree();
            if (errorDump) {
                System.out.println("reading " + hyphenDir + key + ".hyp");
            }
            try {
                hTree.loadInternalPatterns(hyphenFile.getPath());
                if (errorDump) {
                    System.out.println("Stats: ");
                    hTree.printStats();
                }
                return hTree;
            }
            catch (HyphenationException ex) {
                if (errorDump) {
                    System.out.println("Can't load user patterns from file " + hyphenDir + key + ".hyp");
                }
                return null;
            }
        }
        if (errorDump) {
            System.out.println("Tried to load " + hyphenFile.toString() + "\nCannot find compiled nor xml file for hyphenation pattern" + key);
        }
        return null;
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            System.out.println("Error building hyphenation tree for language " + lang);
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, char[] word, int offset, int len, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            System.out.println("Error building hyphenation tree for language " + lang);
            return null;
        }
        return hTree.hyphenate(word, offset, len, leftMin, rightMin);
    }

    public void setMinRemainCharCount(int min) {
        this.remainCharCount = min;
    }

    public void setMinPushCharCount(int min) {
        this.pushCharCount = min;
    }

    public void setLanguage(String lang, String country) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
    }

    public Hyphenation hyphenate(char[] word, int offset, int len) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, offset, len, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String word) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, this.remainCharCount, this.pushCharCount);
    }

    public static String getHyphenDir() {
        return hyphenDir;
    }

    public static void setHyphenDir(String _hyphenDir) {
        hyphenDir = _hyphenDir;
    }
}

