/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf.hyphenation;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.pdf.hyphenation.Hyphen;
import quadbase.common.util.output.pdf.hyphenation.PatternConsumer;

public class PatternInternalParser
implements PatternConsumer {
    PatternConsumer consumer;

    public PatternInternalParser() {
    }

    public PatternInternalParser(PatternConsumer consumer) {
        this.consumer = consumer;
    }

    public void setConsumer(PatternConsumer consumer) {
        this.consumer = consumer;
    }

    protected String getHyphString(InputStream is) throws IOException {
        int n;
        InputStreamReader isr = new InputStreamReader(is, "UTF8");
        char[] c = new char[4000];
        StringBuffer buf = new StringBuffer();
        while ((n = isr.read(c)) >= 0) {
            buf.append(c, 0, n);
        }
        isr.close();
        return buf.toString();
    }

    public void parse(String filename) {
        FileInputStream is;
        try {
            is = new FileInputStream(filename);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
        this.parse(is);
    }

    public void parse(InputStream is) {
        String hyphs;
        try {
            hyphs = this.getHyphString(is);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
        this.parseString(hyphs);
    }

    public void parseString(String hyphs) {
        StringTokenizer tk = new StringTokenizer(hyphs);
        this.readClasses(tk);
        this.readExceptions(tk);
        this.readPatterns(tk);
    }

    protected void readClasses(StringTokenizer tk) {
        String token = "";
        while (tk.hasMoreTokens() && !(token = tk.nextToken()).equals("*")) {
            this.consumer.addClass(token);
        }
    }

    protected void readExceptions(StringTokenizer tk) {
        String token = "";
        while (tk.hasMoreTokens() && !(token = tk.nextToken()).equals("*")) {
            String word = token;
            Vector<Object> vec = new Vector<Object>();
            while (tk.hasMoreTokens()) {
                token = tk.nextToken();
                if (token.equals("{")) {
                    String t3;
                    String t2;
                    String t1 = tk.nextToken();
                    if (t1.equals("N")) {
                        t1 = null;
                    }
                    if ((t2 = tk.nextToken()).equals("N")) {
                        t2 = null;
                    }
                    if ((t3 = tk.nextToken()).equals("N")) {
                        t3 = null;
                    }
                    Hyphen hy = new Hyphen(t2, t1, t3);
                    vec.addElement(hy);
                    continue;
                }
                if (token.equals("#")) break;
                vec.addElement(token);
            }
            this.consumer.addException(word, vec);
        }
    }

    protected void readPatterns(StringTokenizer tk) {
        String token = "";
        while (tk.hasMoreTokens()) {
            token = tk.nextToken();
            this.consumer.addPattern(token, tk.nextToken());
        }
    }

    @Override
    public void addClass(String c) {
        System.out.println("class: " + c);
    }

    @Override
    public void addException(String w, Vector e) {
        System.out.println("exception: " + w + " : " + e.toString());
    }

    @Override
    public void addPattern(String p, String v) {
        System.out.println("pattern: " + p + " : " + v);
    }
}

