/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Enumeration;
import quadbase.queryproc.Aggregator;
import quadbase.queryproc.IAggregatorFactory;
import quadbase.queryproc.ICollationKey;
import quadbase.queryproc.IRoundingFunc;
import quadbase.queryproc.ITreeNodeFactory;
import quadbase.queryproc.TreeLevelInfo;
import quadbase.util.IRow;

public abstract class ATreeNode {
    protected static ITreeNodeFactory nodeFactory;
    protected static IAggregatorFactory aggrFactory;
    ICollationKey key;
    TreeLevelInfo info;
    Aggregator[] aggregator;
    IRoundingFunc childRoundingFunc;
    int childColId;
    boolean drawNullColumn;
    String nullHandleName;

    public ATreeNode(TreeLevelInfo nodeInfo, ICollationKey keyId, boolean drawNullColumn, String nullHandleName) throws Exception {
        if (nodeInfo == null || keyId == null) {
            throw new IllegalArgumentException("Null tree node information");
        }
        this.info = nodeInfo;
        this.key = keyId;
        this.drawNullColumn = drawNullColumn;
        this.nullHandleName = nullHandleName;
        if (this.info.isLeaf()) {
            this.aggregator = new Aggregator[this.info.getAggregateCount()];
            for (int i = 0; i < this.aggregator.length; ++i) {
                int colId = this.info.getAggregateCol(i);
                this.aggregator[i] = aggrFactory.createAggregator(this.info.getAggregateOp(i), this.info.getColType(colId));
            }
        } else {
            TreeLevelInfo childInfo = this.info.getChildInfo();
            this.childColId = childInfo.getIdCol();
            this.childRoundingFunc = childInfo.getRoundingFunc();
        }
    }

    public ICollationKey getKey() {
        return this.key;
    }

    public Object getId() {
        return this.key.getSourceObject();
    }

    public TreeLevelInfo getInfo() {
        return this.info;
    }

    public void addRow(IRow row) throws Exception {
        Object newChildId;
        if (this.info.isLeaf()) {
            this.performAggregate(row);
            return;
        }
        Object childId = row.getObject(this.childColId);
        if (childId == null) {
            if (!this.drawNullColumn) {
                return;
            }
            childId = this.nullHandleName;
        }
        Object object = newChildId = this.childRoundingFunc == null ? childId : this.childRoundingFunc.roundOff(childId);
        if (newChildId != null) {
            ATreeNode b = this.getChild(newChildId);
            if (b != null) {
                b.addRow(row);
            }
            return;
        }
    }

    protected void performAggregate(IRow row) throws Exception {
        for (int i = 0; i < this.aggregator.length; ++i) {
            this.aggregator[i].aggregate(row.getObject(this.info.getAggregateCol(i)));
        }
    }

    public Object getAggregateResult(int index) {
        if (index < 0 || index > this.aggregator.length) {
            throw new IllegalArgumentException("No aggregate at index :" + index);
        }
        return this.aggregator[index].getResult();
    }

    public static synchronized void setNodeFactory(ITreeNodeFactory fac) {
        nodeFactory = fac;
    }

    protected static ITreeNodeFactory getNodeFactory() {
        return nodeFactory;
    }

    public static synchronized void setAggrFactory(IAggregatorFactory fac) {
        aggrFactory = fac;
    }

    protected static IAggregatorFactory getAggrFactory() {
        return aggrFactory;
    }

    public abstract int getChildCount();

    public abstract int getSubTreeCount();

    protected abstract ATreeNode getChild(Object var1) throws Exception;

    public abstract ATreeNode getSmallestChild();

    public abstract ATreeNode getLargestChild();

    public abstract Enumeration sortedChildren();
}

