/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Date;
import quadbase.common.util.internal.DataType;
import quadbase.queryproc.Aggregator;

public class AggrFirstLast
extends Aggregator {
    double d;
    int aggrType;
    boolean hasValues = false;
    boolean isInt = false;

    public AggrFirstLast(int sqlType, int firstLastType) {
        super(sqlType);
        if (firstLastType != 5 && firstLastType != 6) {
            throw new IllegalArgumentException("Invalid aggregate type :" + firstLastType);
        }
        int datatype = DataType.mapType(sqlType);
        this.isInt = datatype == 0 || datatype == 2 || datatype == 11 || datatype == 12;
        this.aggrType = firstLastType;
    }

    @Override
    public void aggregate(Object p) {
        if (p == null) {
            return;
        }
        double x = 0.0;
        if (p instanceof Number) {
            x = ((Number)p).doubleValue();
        } else if (p instanceof Date) {
            x = ((Date)p).getTime();
        } else {
            throw new IllegalArgumentException("Attempt to perform max/min on non-numeric object: " + p);
        }
        if (!this.hasValues && this.aggrType == 5) {
            this.d = x;
        }
        this.hasValues = true;
        if (this.aggrType == 6) {
            this.d = x;
        }
    }

    @Override
    public Object getResult() {
        if (!this.hasValues) {
            return null;
        }
        if (this.isInt) {
            return (int)this.d;
        }
        return this.d;
    }
}

