/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Date;
import quadbase.common.util.internal.DataType;
import quadbase.queryproc.Aggregator;

public class AggrMinMax
extends Aggregator {
    double d;
    int aggrType;
    boolean hasValues = false;
    boolean isInt = false;

    public AggrMinMax(int sqlType, int minMaxType) {
        super(sqlType);
        if (minMaxType != 1 && minMaxType != 2) {
            throw new IllegalArgumentException("Invalid aggregate type :" + minMaxType);
        }
        this.aggrType = minMaxType;
        this.d = this.aggrType == 1 ? Double.MIN_VALUE : Double.MAX_VALUE;
        int datatype = DataType.mapType(sqlType);
        this.isInt = datatype == 0 || datatype == 2 || datatype == 11 || datatype == 12;
    }

    @Override
    public void aggregate(Object p) {
        if (p == null) {
            return;
        }
        double x = 0.0;
        if (p instanceof Number) {
            x = ((Number)p).doubleValue();
        } else if (p instanceof Date) {
            x = ((Date)p).getTime();
        } else {
            throw new IllegalArgumentException("Attempt to perform max/min on non-numeric object: " + p);
        }
        this.hasValues = true;
        if (this.aggrType == 2 && x < this.d) {
            this.d = x;
        }
        if (this.aggrType == 1 && x > this.d) {
            this.d = x;
        }
    }

    @Override
    public Object getResult() {
        if (!this.hasValues) {
            return null;
        }
        if (this.isInt) {
            return (int)this.d;
        }
        return this.d;
    }
}

