/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Date;
import quadbase.common.util.internal.DataType;
import quadbase.queryproc.Aggregator;

public class AggrSum
extends Aggregator {
    double d;
    boolean isNull = true;
    boolean isInt = false;

    public AggrSum(int sqlType) {
        super(sqlType);
        int datatype = DataType.mapType(sqlType);
        this.isInt = datatype == 0 || datatype == 2 || datatype == 11 || datatype == 12;
    }

    @Override
    public void aggregate(Object p) {
        if (p == null) {
            return;
        }
        this.isNull = false;
        if (p instanceof Number) {
            this.d += ((Number)p).doubleValue();
        } else if (p instanceof Date) {
            this.d += (double)((Date)p).getTime();
        } else {
            throw new IllegalArgumentException("Attempt to perform sum on non-numeric object: " + p);
        }
    }

    @Override
    public Object getResult() {
        if (this.isNull) {
            return null;
        }
        if (this.isInt) {
            return (int)this.d;
        }
        return this.d;
    }
}

