/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import quadbase.common.util.internal.DataType;

public abstract class Aggregator {
    public static final int COUNT = 0;
    public static final int MAX = 1;
    public static final int MIN = 2;
    public static final int SUM = 3;
    public static final int AVG = 4;
    public static final int FIRST = 5;
    public static final int LAST = 6;
    public static final int SUMSQUARE = 7;
    public static final int VARIANCE = 8;
    public static final int STDDEV = 9;
    public static final int COUNTDISTINCT = 10;
    public static final int MAX_FUNCS = 11;
    public int sqlType;

    public static String getName(int opType) {
        switch (opType) {
            case 0: {
                return "count";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "min";
            }
            case 3: {
                return "sum";
            }
            case 4: {
                return "avg";
            }
            case 5: {
                return "first";
            }
            case 6: {
                return "last";
            }
            case 7: {
                return "sumsquare";
            }
            case 8: {
                return "variance";
            }
            case 9: {
                return "stddev";
            }
            case 10: {
                return "countdistinct";
            }
        }
        throw new IllegalArgumentException("Invalid aggregate type :" + opType);
    }

    public static int getResultType(int opType, int sqlType) {
        switch (opType) {
            case 0: 
            case 10: {
                return 4;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                int datatype = DataType.mapType(sqlType);
                if (datatype == 0 || datatype == 2 || datatype == 11 || datatype == 12) {
                    return 4;
                }
            }
            case 4: 
            case 8: 
            case 9: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid aggregate type :" + opType);
    }

    public Aggregator(int sqlType) {
        this.sqlType = sqlType;
    }

    public abstract void aggregate(Object var1);

    public abstract Object getResult();
}

