/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import java.util.Enumeration;
import quadbase.queryproc.ICollationKey;
import quadbase.queryproc.ICollator;
import quadbase.queryproc.IRECProvider;
import quadbase.queryproc.IRoundingFunc;

class FloatRECProvider
implements IRECProvider,
ICollator,
IRoundingFunc,
Enumeration {
    int sqlType;
    double lbVal = -1.7976931348623157E308;
    double ubVal = Double.MAX_VALUE;
    double refVal;
    double increment;
    double nextVal;
    Number nextObj;
    double eubVal;
    boolean bRangeOnly;
    boolean complete = false;
    int count = 0;

    public FloatRECProvider(Number lBound, Number uBound, double incr, int type) {
        this.increment = incr > 0.0 ? incr : 0.0;
        this.sqlType = type;
        if (lBound != null) {
            this.refVal = this.lbVal = lBound.doubleValue();
        }
        if (uBound != null) {
            this.ubVal = uBound.doubleValue();
            if (lBound != null) {
                this.ubVal += 1.0;
                Number ut = (Number)this.roundOff(uBound);
                this.ubVal = ut.doubleValue();
                this.ubVal += this.increment;
            } else {
                this.refVal = this.ubVal;
            }
        }
    }

    @Override
    public boolean isRangeOnly() {
        return this.bRangeOnly;
    }

    @Override
    public void setRangeOnly(boolean b) {
        this.bRangeOnly = b;
    }

    @Override
    public Object roundOff(Object p0) {
        if (!(p0 instanceof Number)) {
            return p0;
        }
        double l0 = this.toNumber(p0).doubleValue();
        if (l0 < this.lbVal || l0 >= this.ubVal) {
            return null;
        }
        if (this.bRangeOnly || this.increment == 0.0) {
            return p0;
        }
        long diff = (long)((l0 - this.refVal) / this.increment);
        double d = this.refVal + this.increment * (double)diff;
        return this.getNumericValue(d);
    }

    Number getNumericValue(double d) {
        switch (this.sqlType) {
            case 7: {
                return Float.valueOf((float)d);
            }
            case 6: 
            case 8: {
                return d;
            }
        }
        throw new IllegalArgumentException("Invalid SQL type: " + this.sqlType);
    }

    @Override
    public ICollator getCollator() {
        return this;
    }

    @Override
    public IRoundingFunc getRoundingFunc() {
        return this;
    }

    @Override
    public Enumeration getEnumeration(Object l, Object u) {
        if (l == null || u == null) {
            throw new IllegalArgumentException("Bounds for enumeration may not be null!");
        }
        if (!(l instanceof Number) || !(u instanceof Number)) {
            throw new IllegalArgumentException("Non-numeric bounds specified!");
        }
        Number elb = (Number)l;
        Number eub = (Number)u;
        this.nextObj = elb;
        this.nextVal = elb.doubleValue();
        this.eubVal = eub.doubleValue();
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.complete;
    }

    public Object nextElement() {
        if (this.complete) {
            return null;
        }
        Number retObject = this.nextObj;
        this.nextVal += this.increment;
        this.nextObj = this.getNumericValue(this.nextVal);
        boolean bl = this.complete = this.nextVal >= this.eubVal;
        if (++this.count > 100) {
            this.complete = true;
        }
        return retObject;
    }

    @Override
    public ICollationKey getCollationKey(Object x) {
        return new FloatCollationKey(x);
    }

    private Number toNumber(Object obj) {
        if (obj instanceof Number) {
            return (Number)obj;
        }
        return Float.valueOf(Float.MAX_VALUE);
    }

    public class FloatCollationKey
    implements ICollationKey {
        Object source;
        double value;
        double DIFF = 1.0E-13;

        public FloatCollationKey(Object d) {
            this.source = d;
            this.value = FloatRECProvider.this.toNumber(this.source).doubleValue();
        }

        @Override
        public int compareTo(ICollationKey key) {
            double delta = this.value - ((FloatCollationKey)key).value;
            if (Math.abs(delta) < this.DIFF) {
                return 0;
            }
            return delta > 0.0 ? 1 : -1;
        }

        @Override
        public boolean equals(Object key) {
            return Math.abs(((FloatCollationKey)key).value - this.value) < this.DIFF;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public Object getSourceObject() {
            return this.source;
        }
    }
}

