/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import quadbase.queryproc.BigDecRECProvider;
import quadbase.queryproc.FloatRECProvider;
import quadbase.queryproc.IRECProvider;
import quadbase.queryproc.IntRECProvider;
import quadbase.queryproc.QueryProc;

public class NumberQueryProc
extends QueryProc {
    int mainColType;
    Number incrNum;

    public NumberQueryProc(boolean useObjectBuffer) {
        super(useObjectBuffer);
    }

    @Override
    public void setRoundingIntervalSize(Number incr) {
        this.incrNum = incr;
        if (this.incrNum.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Rounding interval must be positive");
        }
    }

    @Override
    public Number getRoundingIntervalSize() {
        return this.incrNum;
    }

    @Override
    public int getRoundingIntervalUnit() {
        return -1;
    }

    @Override
    public void setRoundingIntervalUnit(int x) {
    }

    @Override
    void verifyInput() throws Exception {
        super.verifyInput();
        this.mainColType = this.md.getColumnType(this.mainCol);
        if (this.isRounded() && this.incrNum == null) {
            throw new IllegalArgumentException("Rounding interval not specified.");
        }
        if (!this.isNumeric(this.mainColType)) {
            throw new IllegalArgumentException("Invalid numeric column :" + this.mainCol);
        }
    }

    @Override
    IRECProvider newRECProvider() {
        switch (this.mainColType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return new IntRECProvider((Number)this.lBoundVal, (Number)this.uBoundVal, this.isRounded() ? this.incrNum.longValue() : 0L, this.mainColType);
            }
            case 6: 
            case 7: 
            case 8: {
                return new FloatRECProvider((Number)this.lBoundVal, (Number)this.uBoundVal, this.isRounded() ? this.incrNum.doubleValue() : 0.0, this.mainColType);
            }
            case 2: 
            case 3: {
                return new BigDecRECProvider((Number)this.lBoundVal, (Number)this.uBoundVal, this.isRounded() ? this.incrNum.doubleValue() : 0.0, this.mainColType);
            }
        }
        throw new IllegalArgumentException("Invalid SQL type: " + this.mainColType);
    }
}

