/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc;

import quadbase.queryproc.ICollationKey;
import quadbase.queryproc.ICollator;
import quadbase.queryproc.IRoundingFunc;
import quadbase.queryproc.StringCollationKey;
import quadbase.util.IRSMetaData;

public class TreeLevelInfo
implements ICollator {
    static final int MAX_CHILDREN = 50;
    int colNo;
    IRSMetaData md;
    TreeLevelInfo childInfo;
    int maxChildren;
    IRoundingFunc rndFunc;
    ICollator collator;
    int[] aggrColNo;
    int[] aggrOp;

    public TreeLevelInfo(IRSMetaData md, int colNo) {
        this.md = md;
        this.colNo = colNo;
        this.collator = this;
        this.maxChildren = 50;
    }

    public int getIdCol() {
        return this.colNo;
    }

    public boolean isLeaf() {
        return this.childInfo == null;
    }

    public TreeLevelInfo getChildInfo() {
        return this.childInfo;
    }

    public int getChildCol() {
        return this.childInfo.colNo;
    }

    public void setChildCol(int childCol) {
        this.childInfo = new TreeLevelInfo(this.md, childCol);
    }

    public void setAggregateList(int[] col, int[] aggr) {
        if (col == null || aggr == null) {
            return;
        }
        if (col.length != aggr.length) {
            throw new IllegalArgumentException("Number of aggregate columns don't match operators.");
        }
        this.aggrColNo = col;
        this.aggrOp = aggr;
    }

    public int getAggregateCount() {
        return this.aggrColNo.length;
    }

    public int getAggregateCol(int index) {
        return this.aggrColNo[index];
    }

    public int getAggregateOp(int index) {
        return this.aggrOp[index];
    }

    public String getColName(int index) throws Exception {
        return this.md.getColumnName(index);
    }

    public int getColType(int index) throws Exception {
        return this.md.getColumnType(index);
    }

    public void setRoundingFunc(IRoundingFunc f) {
        this.rndFunc = f;
    }

    public IRoundingFunc getRoundingFunc() {
        return this.rndFunc;
    }

    public void setCollator(ICollator c) {
        this.collator = c;
    }

    public ICollator getCollator() {
        return this.collator;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int c) {
        this.maxChildren = c;
    }

    @Override
    public ICollationKey getCollationKey(Object x) {
        return new StringCollationKey(x);
    }
}

