/*
 * Decompiled with CFR 0.152.
 */
package quadbase.queryproc.filter;

import java.util.Vector;
import quadbase.queryproc.filter.IFilter;
import quadbase.util.IRow;

public abstract class AFilterNode {
    IFilter filter;
    int col;

    public AFilterNode(IFilter f) {
        this.filter = f;
        this.col = f.getColumnIndex();
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public boolean pass(IRow row) throws Exception {
        Object x = row.getObject(this.col);
        if (!this.getFilter().pass(x)) {
            return false;
        }
        if (this.isLeaf()) {
            return true;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            AFilterNode node = this.getChild(i);
            if (!node.pass(row)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isLeaf();

    public abstract int getChildCount();

    public abstract AFilterNode getChild(int var1);

    protected Vector getColumnVector(Vector vector) {
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                vector = this.getChild(i).getColumnVector(vector);
            }
        }
        vector.addElement(this.col);
        return vector;
    }
}

