/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.internal;

import java.awt.Color;
import java.util.Vector;
import quadbase.common.formula.Formula;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.DataType;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.util.IDatabaseInfo;
import quadbase.reportdesigner.util.IJNDIDatabaseInfo;
import quadbase.reportdesigner.util.IQbQueryFileInfo;
import quadbase.reportdesigner.util.IQueryFileInfo;
import quadbase.reportdesigner.util.IQueryInParam;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class ReportUtil {
    public static IQueryFileInfo cast(quadbase.common.util.IQueryFileInfo dbInfo) {
        if (dbInfo instanceof IQueryFileInfo) {
            return (IQueryFileInfo)dbInfo;
        }
        return new CQueryFileInfo(dbInfo);
    }

    public static IQbQueryFileInfo cast2(quadbase.common.util.IQueryFileInfo dbInfo) {
        if (dbInfo instanceof IQbQueryFileInfo) {
            return (IQbQueryFileInfo)dbInfo;
        }
        return new CQbQueryFileInfo(dbInfo);
    }

    public static IDatabaseInfo cast(quadbase.common.util.IDatabaseInfo dbInfo) {
        return new CDatabaseInfo(dbInfo);
    }

    public static IJNDIDatabaseInfo cast(quadbase.common.util.IJNDIDatabaseInfo jndiInfo) {
        return new CDatabaseInfo(jndiInfo);
    }

    public static IQueryInParam cast(quadbase.common.util.IQueryInParam dbInfo) {
        if (dbInfo instanceof IQueryMultiValueInParam) {
            return new CQueryMultiValueInParam((IQueryMultiValueInParam)dbInfo);
        }
        return new CQueryInParam(dbInfo);
    }

    public static IQueryInParam[] getInParam(Object obj) {
        if (obj instanceof quadbase.common.util.IQueryFileInfo) {
            return ReportUtil.cast((quadbase.common.util.IQueryFileInfo)obj).getInParam();
        }
        return null;
    }

    public static IQueryInParam[][] getParamInSequence(Object obj) {
        if (obj instanceof quadbase.common.util.IQueryFileInfo) {
            return ReportUtil.cast2((quadbase.common.util.IQueryFileInfo)obj).getParameterInPromptSequence();
        }
        return null;
    }

    public static quadbase.common.util.IQueryInParam[] getUnSelectedParams(quadbase.common.util.IQueryInParam[] masterParams, quadbase.common.util.IQueryInParam[] securityParams, boolean resetMasterParams) {
        if (masterParams == null || securityParams == null) {
            return masterParams;
        }
        Vector<quadbase.common.util.IQueryInParam> unselectedParameters = new Vector<quadbase.common.util.IQueryInParam>();
        boolean different = false;
        for (int i = 0; i < masterParams.length; ++i) {
            Vector<Object> destObj;
            Vector<Object> sourceObj;
            if (masterParams[i] instanceof IQueryMultiValueInParam) {
                sourceObj = ((IQueryMultiValueInParam)securityParams[i]).getValues();
                if (!different) {
                    destObj = ((IQueryMultiValueInParam)masterParams[i]).getValues();
                    if (sourceObj != null && destObj != null) {
                        if (!((Object)sourceObj).equals(destObj)) {
                            different = true;
                        }
                    } else if (sourceObj != null || destObj != null) {
                        different = true;
                    }
                }
                if (sourceObj == null) {
                    unselectedParameters.addElement(masterParams[i]);
                }
                if (!resetMasterParams || sourceObj == null) continue;
                ((IQueryMultiValueInParam)masterParams[i]).setValues(sourceObj);
                continue;
            }
            sourceObj = securityParams[i].getValue();
            if (!different) {
                destObj = masterParams[i].getValue();
                if (sourceObj != null && destObj != null) {
                    if (!((Object)sourceObj).equals(destObj)) {
                        different = true;
                    }
                } else if (sourceObj != null || destObj != null) {
                    different = true;
                }
            }
            if (sourceObj == null) {
                unselectedParameters.addElement(masterParams[i]);
            }
            if (!resetMasterParams || sourceObj == null) continue;
            masterParams[i].setValue(sourceObj);
        }
        if (unselectedParameters.size() > 0) {
            quadbase.common.util.IQueryInParam[] unselectedParams = new quadbase.common.util.IQueryInParam[unselectedParameters.size()];
            for (int i = 0; i < unselectedParams.length; ++i) {
                unselectedParams[i] = (quadbase.common.util.IQueryInParam)unselectedParameters.elementAt(i);
            }
            return unselectedParams;
        }
        return null;
    }

    public static boolean queryParamIsNotSelected(quadbase.common.util.IQueryInParam param, quadbase.common.util.IQueryInParam[] unselectedParams) {
        if (unselectedParams == null) {
            return false;
        }
        for (quadbase.common.util.IQueryInParam unselectedParam : unselectedParams) {
            if (!param.equals(unselectedParam)) continue;
            return true;
        }
        return false;
    }

    public static Vector<Object> getMultiValueObject(int sqlType, String[] strValues) {
        return ReportUtil.getMultiValueObject(sqlType, strValues, null);
    }

    public static Vector<Object> getMultiValueObject(int sqlType, Object[] strValues, String dateFormat) {
        Vector<Object> valueObjects = new Vector<Object>();
        for (Object strValue : strValues) {
            valueObjects.addElement(ReportUtil.getValueObject(sqlType, strValue, dateFormat));
        }
        return valueObjects;
    }

    public static Object getValueObject(int sqlType, Object strValue) {
        return ReportUtil.getValueObject(sqlType, strValue, null);
    }

    public static Object getValueObject(int sqlType, Object strValue, String dateFormat) {
        if (DataType.match(sqlType, strValue)) {
            return strValue;
        }
        Object obj = null;
        int mapType = DataType.mapType(sqlType);
        try {
            obj = DataType.createObject(strValue.toString(), mapType, dateFormat);
        }
        catch (Exception e) {
            if (DataType.isDateTime(mapType) && strValue instanceof String && !strValue.equals("NULL")) {
                try {
                    Formula formula = new Formula(null, (String)strValue);
                    obj = formula.getValue();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        return obj;
    }

    public static void setBorderThickness(ReportElement elt, int thickness, boolean forLine, BorderSide borderSide) {
        if (elt instanceof TableOfContents) {
            return;
        }
        if (forLine) {
            if (elt instanceof ReportLine) {
                elt.setBorderThickness(thickness);
            }
        } else if (!(elt instanceof ReportLine)) {
            elt.setBorderThickness(thickness, borderSide);
        }
    }

    public static void setBgColor(ReportElement elt, Color bgColor, boolean forLine) {
        if (forLine) {
            if (elt instanceof ReportLine) {
                elt.setBgColor(bgColor);
            }
        } else if (!(elt instanceof ReportLine)) {
            elt.setBgColor(bgColor);
        }
    }
}

