/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import quadbase.util.IFormat;

public class LocaleDateTimeFormat
implements IFormat {
    public static int DATE = 0;
    public static int TIME = 1;
    public static int DATETIME = 2;
    private DateFormat df;
    private int type;
    private int style1;
    private int style2;

    private LocaleDateTimeFormat(int type, DateFormat df, int style) {
        this.type = type;
        this.df = df;
        this.style1 = style;
    }

    private LocaleDateTimeFormat(int type, DateFormat df, int style1, int style2) {
        this.type = type;
        this.df = df;
        this.style1 = style1;
        this.style2 = style2;
    }

    public void setLocale(Locale locale) {
        TimeZone zone = this.df.getTimeZone();
        if (this.type == DATE) {
            this.df = DateFormat.getDateInstance(this.style1, locale);
        } else if (this.type == DATETIME) {
            this.df = DateFormat.getDateTimeInstance(this.style1, this.style2, locale);
        } else if (this.type == TIME) {
            this.df = DateFormat.getTimeInstance(this.style1, locale);
        }
        if (zone != null) {
            this.setTimeZone(zone);
        }
    }

    public void setTimeZone(TimeZone zone) {
        this.df.setTimeZone(zone);
    }

    public TimeZone getTimeZone() {
        return this.df.getTimeZone();
    }

    @Override
    public int getFormatType() {
        return 4;
    }

    @Override
    public String format(Object obj) {
        if (obj instanceof Date) {
            return this.df.format(obj);
        }
        return obj.toString();
    }

    public static LocaleDateTimeFormat getDateInstance() {
        return LocaleDateTimeFormat.getDateInstance(2);
    }

    public static LocaleDateTimeFormat getDateInstance(int style) {
        return new LocaleDateTimeFormat(DATE, DateFormat.getDateInstance(style), style);
    }

    public static LocaleDateTimeFormat getDateInstance(Locale locale) {
        return LocaleDateTimeFormat.getDateInstance(2, locale);
    }

    public static LocaleDateTimeFormat getDateInstance(int style, Locale locale) {
        return new LocaleDateTimeFormat(DATE, DateFormat.getDateInstance(style, locale), style);
    }

    public static LocaleDateTimeFormat getDateTimeInstance() {
        return LocaleDateTimeFormat.getDateTimeInstance(2, 2);
    }

    public static LocaleDateTimeFormat getDateTimeInstance(Locale locale) {
        return LocaleDateTimeFormat.getDateTimeInstance(2, 2, locale);
    }

    public static LocaleDateTimeFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return new LocaleDateTimeFormat(DATETIME, DateFormat.getDateTimeInstance(dateStyle, timeStyle), dateStyle, timeStyle);
    }

    public static LocaleDateTimeFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return new LocaleDateTimeFormat(DATETIME, DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale), dateStyle, timeStyle);
    }

    public static LocaleDateTimeFormat getTimeInstance() {
        return LocaleDateTimeFormat.getTimeInstance(2);
    }

    public static LocaleDateTimeFormat getTimeInstance(int style) {
        return new LocaleDateTimeFormat(TIME, DateFormat.getTimeInstance(style), style);
    }

    public static LocaleDateTimeFormat getTimeInstance(Locale locale) {
        return LocaleDateTimeFormat.getTimeInstance(2, locale);
    }

    public static LocaleDateTimeFormat getTimeInstance(int style, Locale locale) {
        return new LocaleDateTimeFormat(TIME, DateFormat.getTimeInstance(style, locale), style);
    }

    public int getInstanceType() {
        return this.type;
    }

    public int getDateStyle() {
        if (this.type == DATE || this.type == DATETIME) {
            return this.style1;
        }
        return -1;
    }

    public int getTimeStyle() {
        if (this.type == TIME) {
            return this.style1;
        }
        if (this.type == DATETIME) {
            return this.style2;
        }
        return -1;
    }
}

