/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import quadbase.util.IFormat;

public class LocaleNumericFormat
implements IFormat {
    public static final int CURRENCY = 0;
    public static final int NUMBER = 1;
    public static final int PERCENT = 2;
    private int type;
    private NumberFormat nf;

    private LocaleNumericFormat(int type, NumberFormat nf) {
        this.type = type;
        this.nf = nf;
    }

    public void setLocale(Locale locale) {
        if (this.type == 0) {
            this.nf = NumberFormat.getCurrencyInstance(locale);
        } else if (this.type == 1) {
            this.nf = NumberFormat.getNumberInstance(locale);
        } else if (this.type == 2) {
            this.nf = NumberFormat.getPercentInstance(locale);
        }
    }

    @Override
    public int getFormatType() {
        return 2;
    }

    @Override
    public String format(Object obj) {
        if (obj instanceof Number) {
            if (obj instanceof Double || obj instanceof Float || obj instanceof BigDecimal) {
                double value = ((Number)obj).doubleValue();
                if (value == 0.0) {
                    return this.nf.format(0L);
                }
                if (this.getInstanceType() == 2) {
                    return this.nf.format(value / 100.0);
                }
                return this.nf.format(value);
            }
            long value = ((Number)obj).longValue();
            if (value == 0L) {
                return this.nf.format(0L);
            }
            if (this.getInstanceType() == 2) {
                return this.nf.format((double)value / 100.0);
            }
            return this.nf.format(value);
        }
        return obj.toString();
    }

    public static LocaleNumericFormat getCurrencyInstance() {
        return new LocaleNumericFormat(0, NumberFormat.getCurrencyInstance());
    }

    public static LocaleNumericFormat getCurrencyInstance(Locale locale) {
        return new LocaleNumericFormat(0, NumberFormat.getCurrencyInstance(locale));
    }

    public static LocaleNumericFormat getNumberInstance() {
        return new LocaleNumericFormat(1, NumberFormat.getNumberInstance());
    }

    public static LocaleNumericFormat getNumberInstance(Locale locale) {
        return new LocaleNumericFormat(1, NumberFormat.getNumberInstance(locale));
    }

    public static LocaleNumericFormat getPercentInstance() {
        return new LocaleNumericFormat(2, NumberFormat.getPercentInstance());
    }

    public static LocaleNumericFormat getPercentInstance(Locale locale) {
        return new LocaleNumericFormat(2, NumberFormat.getPercentInstance(locale));
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public int getInstanceType() {
        return this.type;
    }

    public void setFormat(LocaleNumericFormat obj) {
        NumberFormat temp = obj.getNumberFormat();
        this.nf.setMaximumFractionDigits(temp.getMaximumFractionDigits());
        this.nf.setMaximumIntegerDigits(temp.getMaximumIntegerDigits());
        this.nf.setMinimumFractionDigits(temp.getMinimumFractionDigits());
        this.nf.setMinimumIntegerDigits(temp.getMinimumIntegerDigits());
        this.nf.setGroupingUsed(temp.isGroupingUsed());
        this.nf.setParseIntegerOnly(temp.isParseIntegerOnly());
    }
}

