/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import quadbase.util.Point_2D;
import quadbase.util.Point_3D;
import quadbase.util.internal.IOUtil;

public class PolyLine {
    Color color;
    Vector points = new Vector();
    Vector point2ds = new Vector();
    boolean fillArea = false;
    int thickness = 1;
    int lineStyle = 0;
    boolean drawStartArrow = false;
    boolean drawEndArrow = false;

    public PolyLine() {
    }

    public PolyLine(PolyLine p) {
        this.set(p.elements(), p.getColor(), p.getThickness(), p.getLineStyle(), p.isFillArea(), p.isArrowAtStartPointVisible(), p.isArrowAtEndPointVisible());
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public final boolean isFillArea() {
        return this.fillArea;
    }

    public final void setFillArea(boolean state) {
        this.fillArea = state;
    }

    public final int getThickness() {
        return this.thickness;
    }

    public final void setThickness(int t) {
        this.thickness = t;
    }

    public final int getLineStyle() {
        return this.lineStyle;
    }

    public final void setLineStyle(int s) {
        this.lineStyle = s;
    }

    public final boolean isArrowAtStartPointVisible() {
        return this.drawStartArrow;
    }

    public final void setArrowAtStartPointVisible(boolean state) {
        this.drawStartArrow = state;
    }

    public final boolean isArrowAtEndPointVisible() {
        return this.drawEndArrow;
    }

    public final void setArrowAtEndPointVisible(boolean state) {
        this.drawEndArrow = state;
    }

    public final Enumeration elements() {
        if (this.point2ds.size() > 0) {
            return this.point2ds.elements();
        }
        return this.points.elements();
    }

    public final void set(Enumeration e, Color c) {
        this.set(e, c, this.thickness, this.lineStyle, this.fillArea, this.drawStartArrow, this.drawEndArrow);
    }

    public final void set(Enumeration e, Color color, int thickness, int style, boolean fillArea, boolean startArrow, boolean endArrow) {
        this.color = color;
        this.thickness = thickness;
        this.lineStyle = style;
        this.fillArea = fillArea;
        this.drawStartArrow = startArrow;
        this.drawEndArrow = endArrow;
        this.points.removeAllElements();
        while (e.hasMoreElements()) {
            Object x = e.nextElement();
            if (x instanceof Point_3D) {
                this.points.addElement(x);
                continue;
            }
            if (x instanceof Point_2D) {
                this.point2ds.addElement(x);
                continue;
            }
            throw new IllegalArgumentException("Invalid point datatype");
        }
    }

    public final Vector getPoints() {
        if (this.point2ds.size() > 0) {
            return this.point2ds;
        }
        return this.points;
    }

    public final void write(DataOutput out) throws IOException {
        out.writeBoolean(this.point2ds.size() > 0);
        if (this.point2ds.size() > 0) {
            out.writeInt(this.point2ds.size());
            for (int i = 0; i < this.point2ds.size(); ++i) {
                Point_2D p = (Point_2D)this.point2ds.elementAt(i);
                out.writeFloat(p.getX());
                out.writeFloat(p.getY());
            }
        } else {
            out.writeInt(this.points.size());
            for (int i = 0; i < this.points.size(); ++i) {
                Point_3D p = (Point_3D)this.points.elementAt(i);
                out.writeFloat(p.getX());
                out.writeFloat(p.getY());
                out.writeFloat(p.getZ());
            }
        }
        IOUtil.writeColor(out, this.color);
        out.writeInt(this.thickness);
        out.writeInt(this.lineStyle);
        out.writeBoolean(this.fillArea);
        out.writeBoolean(this.drawStartArrow);
        out.writeBoolean(this.drawEndArrow);
    }

    public static PolyLine read(DataInput in, int version) throws IOException {
        int i;
        PolyLine line = new PolyLine();
        boolean usePoint_2D = false;
        if (version >= 169) {
            usePoint_2D = in.readBoolean();
        }
        int count = in.readInt();
        Vector<Cloneable> pts = new Vector<Cloneable>(count);
        if (usePoint_2D) {
            for (i = 0; i < count; ++i) {
                pts.addElement(new Point_2D(in.readFloat(), in.readFloat()));
            }
        } else {
            for (i = 0; i < count; ++i) {
                pts.addElement(new Point_3D(in.readFloat(), in.readFloat(), in.readFloat()));
            }
        }
        Color color = IOUtil.readColor(in);
        if (version >= 165) {
            int thickness = in.readInt();
            int lineStyle = in.readInt();
            boolean fillArea = in.readBoolean();
            boolean startArrow = in.readBoolean();
            boolean endArrow = in.readBoolean();
            line.set(pts.elements(), color, thickness, lineStyle, fillArea, startArrow, endArrow);
        } else {
            line.set(pts.elements(), color);
        }
        return line;
    }
}

