/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.gif;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import quadbase.util.gif.ColorQuantizer;
import quadbase.util.gif.ColorReduceFilter;

public class GifEncoder {
    private boolean interlace = false;
    int noiselevel = 1;
    byte[] indexMap = null;
    int width;
    int height;
    int[] rgbPixels;
    OutputStream out;
    int tRed = -1;
    int tGreen = -1;
    int tBlue = -1;
    int minX;
    int minY;
    int maxX;
    int maxY = -1;
    int backgroundColor;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GifEncoder(Image image, OutputStream out) throws Exception {
        this(image, image.getWidth(null), image.getHeight(null), out);
    }

    public GifEncoder(Image image, int width, int height, OutputStream out) throws Exception {
        this.out = out;
        this.width = width;
        this.height = height;
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, true);
        try {
            if (!grabber.grabPixels()) {
                throw new Exception("Grabber returned false: " + grabber.status());
            }
            this.rgbPixels = (int[])grabber.getPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public GifEncoder(int[] values, int width, int height, OutputStream out) {
        this.out = out;
        this.width = width;
        this.height = height;
        this.rgbPixels = values;
    }

    public GifEncoder(Image image, int width, int height, int minX, int minY, int maxX, int maxY, int backgroundColor, OutputStream out) throws Exception {
        this.out = out;
        this.width = width;
        this.height = height;
        int plotWidth = maxX - minX;
        int plotHeight = maxY - minY;
        if (plotWidth == 0 || plotHeight == 0) {
            PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, true);
            try {
                if (!grabber.grabPixels()) {
                    throw new Exception("Grabber returned false: " + grabber.status());
                }
                this.rgbPixels = (int[])grabber.getPixels();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            PixelGrabber grabber = new PixelGrabber(image, minX, minY, plotWidth, plotHeight, true);
            try {
                if (!grabber.grabPixels()) {
                    throw new Exception("Grabber returned false: " + grabber.status());
                }
                this.rgbPixels = (int[])grabber.getPixels();
                this.minX = minX;
                this.minY = minY;
                this.maxX = maxX;
                this.maxY = maxY;
                this.backgroundColor = backgroundColor;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public GifEncoder(int[] values, int width, int height, int minX, int minY, int maxX, int maxY, int backgroundColor, OutputStream out) {
        this.out = out;
        this.width = width;
        this.height = height;
        this.rgbPixels = values;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.backgroundColor = backgroundColor;
    }

    public GifEncoder(Image img, OutputStream out, boolean interlace) throws Exception {
        this(img, out);
        this.interlace = interlace;
    }

    public void setTransparentColor(Color c) {
        if (c == null) {
            this.tBlue = -1;
            this.tGreen = -1;
            this.tRed = -1;
        } else {
            this.tRed = c.getRed();
            this.tGreen = c.getGreen();
            this.tBlue = c.getBlue();
        }
    }

    private boolean isTransparent(int rgb) {
        if (this.tRed == -1 || this.tBlue == -1 || this.tGreen == -1) {
            return false;
        }
        int r = rgb >> 16 & 0xFF;
        if ((r = Math.abs(r - this.tRed)) > 7) {
            return false;
        }
        int g = rgb >> 8 & 0xFF;
        if ((g = Math.abs(g - this.tGreen)) > 7) {
            return false;
        }
        int b = rgb & 0xFF;
        if ((b = Math.abs(b - this.tBlue)) > 7) {
            return false;
        }
        return r + g + b <= 15;
    }

    public void encode() throws IOException {
        int transparentIndex = -1;
        int transparentRgb = -1;
        this.indexMap = new byte[this.width * this.height];
        int mapSize = 256;
        byte[] reds = new byte[mapSize];
        byte[] grns = new byte[mapSize];
        byte[] blus = new byte[mapSize];
        boolean notfind = true;
        int colornum = 0;
        int[] colorBuffer = new int[256];
        int t = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int search;
                int value;
                int i = y * this.width + x;
                notfind = true;
                if (this.maxY != -1 && (y < this.minY || y >= this.maxY || x < this.minX || x >= this.maxX)) {
                    value = this.backgroundColor;
                } else {
                    value = this.rgbPixels[t];
                    ++t;
                }
                boolean isTransparent = this.isTransparent(value);
                if (isTransparent) {
                    if (transparentIndex < 0) {
                        transparentIndex = colornum;
                        transparentRgb = value;
                    } else {
                        this.indexMap[i] = (byte)transparentIndex;
                        notfind = false;
                    }
                }
                if (!notfind) continue;
                for (search = 0; search < colornum; ++search) {
                    if (colorBuffer[search] != value) continue;
                    this.indexMap[i] = (byte)search;
                    notfind = false;
                    break;
                }
                if (!notfind) continue;
                if (search >= 256) {
                    System.out.println("Please turn down number colors to 256 to get better result!");
                    this.toIndexedColor();
                    return;
                }
                this.indexMap[i] = (byte)search;
                reds[search] = (byte)(value >> 16 & 0xFF);
                grns[search] = (byte)(value >> 8 & 0xFF);
                blus[search] = (byte)(value & 0xFF);
                colorBuffer[colornum] = value;
                ++colornum;
            }
        }
        int logColors = colornum <= 2 ? 1 : (colornum <= 4 ? 2 : (colornum <= 16 ? 4 : 8));
        this.gifEncode(this.out, this.width, this.height, this.interlace, (byte)0, transparentIndex, logColors, reds, grns, blus);
    }

    byte getPixel(int x, int y) {
        return this.indexMap[y * this.width + x];
    }

    final void toIndexedColor() {
        try {
            int i;
            int index = 0;
            int size = this.width * this.height;
            byte[] red = new byte[size];
            byte[] green = new byte[size];
            byte[] blue = new byte[size];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int value;
                    i = y * this.width + x;
                    if (this.maxY != -1 && (y < this.minY || y >= this.maxY || x < this.minX || x >= this.maxX)) {
                        value = this.backgroundColor;
                    } else {
                        value = this.rgbPixels[index];
                        ++index;
                    }
                    red[i] = (byte)(value >> 16 & 0xFF);
                    green[i] = (byte)(value >> 8 & 0xFF);
                    blue[i] = (byte)(value & 0xFF);
                }
            }
            ColorReduceFilter filter = new ColorReduceFilter(red, green, blue, this.width, this.height);
            filter.reduce(this.noiselevel);
            ColorQuantizer cq = new ColorQuantizer(filter.getRed(), filter.getGreen(), filter.getBlue(), size);
            cq.quantize(256);
            for (i = 0; i < size; ++i) {
                this.indexMap[i] = this.indexMap[i];
            }
            byte[] rmap = cq.getRedMap();
            byte[] gmap = cq.getGreenMap();
            byte[] bmap = cq.getBlueMap();
            this.gifEncode(this.out, this.width, this.height, this.interlace, (byte)0, -1, 8, rmap, gmap, bmap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void setNoiseLevel(int noiselevel) {
        this.noiselevel = noiselevel;
    }

    static void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void gifEncode(OutputStream outs, int Width, int Height, boolean Interlace, byte Background, int Transparent, int BitsPerPixel, byte[] Red, byte[] Green, byte[] Blue) throws IOException {
        this.Width = Width;
        this.Height = Height;
        this.Interlace = Interlace;
        int ColorMapSize = 1 << BitsPerPixel;
        int TopOfs = 0;
        int LeftOfs = 0;
        this.CountDown = Width * Height;
        this.Pass = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        this.curx = 0;
        this.cury = 0;
        GifEncoder.writeString(outs, "GIF89a");
        this.putword(Width, outs);
        this.putword(Height, outs);
        byte B = -128;
        B = (byte)(B | 0x70);
        B = (byte)(B | (byte)(BitsPerPixel - 1));
        this.putbyte(B, outs);
        this.putbyte(Background, outs);
        this.putbyte((byte)0, outs);
        for (int i = 0; i < ColorMapSize; ++i) {
            this.putbyte(Red[i], outs);
            this.putbyte(Green[i], outs);
            this.putbyte(Blue[i], outs);
        }
        if (Transparent != -1) {
            this.putbyte((byte)33, outs);
            this.putbyte((byte)-7, outs);
            this.putbyte((byte)4, outs);
            this.putbyte((byte)1, outs);
            this.putbyte((byte)0, outs);
            this.putbyte((byte)0, outs);
            this.putbyte((byte)Transparent, outs);
            this.putbyte((byte)0, outs);
        }
        this.putbyte((byte)44, outs);
        this.putword(LeftOfs, outs);
        this.putword(TopOfs, outs);
        this.putword(Width, outs);
        this.putword(Height, outs);
        if (Interlace) {
            this.putbyte((byte)64, outs);
        } else {
            this.putbyte((byte)0, outs);
        }
        this.putbyte((byte)InitCodeSize, outs);
        this.compress(InitCodeSize + 1, outs);
        this.putbyte((byte)0, outs);
        this.putbyte((byte)59, outs);
    }

    void bumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int gifNextPixel() {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte r = this.getPixel(this.curx, this.cury);
        this.bumpPixel();
        return r & 0xFF;
    }

    void putword(int w, OutputStream outs) throws IOException {
        this.putbyte((byte)(w & 0xFF), outs);
        this.putbyte((byte)(w >> 8 & 0xFF), outs);
    }

    void putbyte(byte b, OutputStream outs) throws IOException {
        outs.write(b);
    }

    final int maxCode(int n_bits) {
        return (1 << n_bits) - 1;
    }

    void compress(int init_bits, OutputStream outs) throws IOException {
        int c;
        int fcode;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.maxCode(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int ent = this.gifNextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.ClearCode, outs);
        block1: while ((c = this.gifNextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        this.output(this.EOFCode, outs);
    }

    void output(int code, OutputStream outs) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.maxCode(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.maxCode(this.n_bits);
            }
        }
        if (code == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outs);
        }
    }

    void cl_block(OutputStream outs) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outs);
    }

    void cl_hash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte c, OutputStream outs) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char(outs);
        }
    }

    void flush_char(OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            outs.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

