/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.gif;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import quadbase.util.gif.BitUtils;
import quadbase.util.gif.ColorQuantizer;
import quadbase.util.gif.ColorReduceFilter;
import quadbase.util.gif.ImageDescriptor;
import quadbase.util.gif.LZWCompressor;
import quadbase.util.gif.ScreenDescriptor;

public class GifEncoder87a {
    short width_;
    short height_;
    int numColors_;
    byte[] pixels_;
    byte[] colors_;
    ScreenDescriptor sd_;
    ImageDescriptor id_;
    int noiselevel = 1;

    public GifEncoder87a(Image image) throws AWTException {
        this(image, image.getWidth(null), image.getHeight(null));
    }

    public GifEncoder87a(Image image, int width, int height) throws AWTException {
        this.width_ = (short)width;
        this.height_ = (short)height;
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.width_, this.height_, true);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + grabber.status());
            }
            int[] values = (int[])grabber.getPixels();
            this.setParams(values);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public GifEncoder87a(Image image, int width, int height, int minX, int minY, int maxX, int maxY, int backgroundColor) throws AWTException {
        this.width_ = (short)width;
        this.height_ = (short)height;
        int plotWidth = maxX - minX;
        int plotHeight = maxY - minY;
        if (plotWidth == 0 || plotHeight == 0) {
            PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.width_, this.height_, true);
            try {
                if (!grabber.grabPixels()) {
                    throw new AWTException("Grabber returned false: " + grabber.status());
                }
                int[] values = (int[])grabber.getPixels();
                this.setParams(values);
            }
            catch (InterruptedException values) {}
        } else {
            PixelGrabber grabber = new PixelGrabber(image, minX, minY, plotWidth, plotHeight, true);
            try {
                if (!grabber.grabPixels()) {
                    throw new AWTException("Grabber returned false: " + grabber.status());
                }
                int[] values = (int[])grabber.getPixels();
                this.toIndexedColor(values, minX, minY, maxX, maxY, backgroundColor);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public GifEncoder87a(int[] values, int width_, int height_) {
        this.width_ = (short)width_;
        this.height_ = (short)height_;
        this.setParams(values);
    }

    public GifEncoder87a(int[] values, int width, int height, int minX, int minY, int maxX, int maxY, int backgroundColor) {
        this.width_ = (short)width;
        this.height_ = (short)height;
        this.toIndexedColor(values, minX, minY, maxX, maxY, backgroundColor);
    }

    void setParams(int[] values) {
        this.toIndexedColor(values);
    }

    public GifEncoder87a(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.width_ = (short)r.length;
        this.height_ = (short)r[0].length;
        this.toIndexedColor(r, g, b);
    }

    public final void write(OutputStream output) throws IOException {
        BitUtils.writeString(output, "GIF87a");
        ScreenDescriptor sd = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        sd.Write(output);
        output.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor id = new ImageDescriptor(this.width_, this.height_, ',');
        id.Write(output);
        byte codesize = BitUtils.bitsNeeded(this.numColors_);
        if (codesize == 1) {
            codesize = (byte)(codesize + 1);
        }
        output.write(codesize);
        LZWCompressor.LZWCompress(output, codesize, this.pixels_);
        output.write(0);
        id = new ImageDescriptor(0, 0, ';');
        id.Write(output);
        output.flush();
    }

    final void toIndexedColor(int[] values) {
        try {
            this.tryToIndexedColor(values);
        }
        catch (Exception ex) {
            byte[][] r = new byte[this.width_][this.height_];
            byte[][] g = new byte[this.width_][this.height_];
            byte[][] b = new byte[this.width_][this.height_];
            int index = 0;
            for (int y = 0; y < this.height_; ++y) {
                for (int x = 0; x < this.width_; ++x) {
                    r[x][y] = (byte)(values[index] >> 16 & 0xFF);
                    g[x][y] = (byte)(values[index] >> 8 & 0xFF);
                    b[x][y] = (byte)(values[index] & 0xFF);
                    ++index;
                }
            }
            this.doException(r, g, b);
        }
    }

    final void toIndexedColor(int[] values, int minX, int minY, int maxX, int maxY, int backgroundColor) {
        try {
            this.tryToIndexedColor(values, minX, minY, maxX, maxY, backgroundColor);
        }
        catch (Exception ex) {
            byte[][] r = new byte[this.width_][this.height_];
            byte[][] g = new byte[this.width_][this.height_];
            byte[][] b = new byte[this.width_][this.height_];
            int index = 0;
            for (int y = 0; y < this.height_; ++y) {
                for (int x = 0; x < this.width_; ++x) {
                    int value;
                    if (y < minY || y >= maxY || x < minX || x >= maxX) {
                        value = backgroundColor;
                    } else {
                        value = values[index];
                        ++index;
                    }
                    r[x][y] = (byte)(value >> 16 & 0xFF);
                    g[x][y] = (byte)(value >> 8 & 0xFF);
                    b[x][y] = (byte)(value & 0xFF);
                }
            }
            this.doException(r, g, b);
        }
    }

    final void toIndexedColor(byte[][] r, byte[][] g, byte[][] b) {
        try {
            this.tryToIndexedColor(r, g, b);
        }
        catch (AWTException ex) {
            this.doException(r, g, b);
        }
    }

    final void doException(byte[][] r, byte[][] g, byte[][] b) {
        int index = 0;
        int size = this.width_ * this.height_;
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        for (int y = 0; y < this.height_; ++y) {
            for (int x = 0; x < this.width_; ++x) {
                red[index] = r[x][y];
                green[index] = g[x][y];
                blue[index] = b[x][y];
                ++index;
            }
        }
        ColorReduceFilter filter = new ColorReduceFilter(red, green, blue, this.width_, this.height_);
        filter.reduce(this.noiselevel);
        ColorQuantizer cq = new ColorQuantizer(filter.getRed(), filter.getGreen(), filter.getBlue(), size);
        cq.quantize(256);
        int[] indexmap = cq.getIndexMap();
        for (int i = 0; i < size; ++i) {
            this.pixels_[i] = (byte)indexmap[i];
        }
        byte[] rmap = cq.getRedMap();
        byte[] gmap = cq.getGreenMap();
        byte[] bmap = cq.getBlueMap();
        index = 0;
        for (int k = 0; k < 256; ++k) {
            this.colors_[index++] = rmap[k];
            this.colors_[index++] = gmap[k];
            this.colors_[index++] = bmap[k];
        }
        this.numColors_ = 1 << BitUtils.bitsNeeded(256);
    }

    public final void setNoiseLevel(int noiselevel) {
        this.noiselevel = noiselevel;
    }

    final void tryToIndexedColor(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.pixels_ = new byte[this.width_ * this.height_];
        this.colors_ = new byte[768];
        int colornum = 0;
        boolean notfind = true;
        for (int x = 0; x < this.width_; ++x) {
            for (int y = 0; y < this.height_; ++y) {
                int index;
                int search;
                byte red = r[x][y];
                byte blue = b[x][y];
                byte green = g[x][y];
                notfind = true;
                for (search = 0; search < colornum; ++search) {
                    index = search * 3;
                    if (this.colors_[index] != red || this.colors_[++index] != green || this.colors_[++index] != blue) continue;
                    this.pixels_[y * this.width_ + x] = (byte)search;
                    notfind = false;
                    break;
                }
                if (!notfind) continue;
                if (search > 255) {
                    throw new AWTException("too many color");
                }
                this.pixels_[y * this.width_ + x] = (byte)search;
                index = search * 3;
                this.colors_[index] = red;
                this.colors_[++index] = green;
                this.colors_[++index] = blue;
                ++colornum;
            }
        }
        this.numColors_ = 1 << BitUtils.bitsNeeded(colornum);
        byte[] copy = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, copy, 0, this.numColors_ * 3);
        this.colors_ = copy;
    }

    final void tryToIndexedColor(int[] values) throws AWTException {
        int nPixel = this.width_ * this.height_;
        this.pixels_ = new byte[nPixel];
        this.colors_ = new byte[768];
        int[] colorBuffer = new int[256];
        int colornum = 0;
        boolean notfind = true;
        for (int i = 0; i < nPixel; ++i) {
            int search;
            notfind = true;
            for (search = 0; search < colornum; ++search) {
                if (colorBuffer[search] != values[i]) continue;
                this.pixels_[i] = (byte)search;
                notfind = false;
                break;
            }
            if (!notfind) continue;
            if (search > 255) {
                throw new AWTException("too many color");
            }
            this.pixels_[i] = (byte)search;
            int index = search * 3;
            this.colors_[index] = (byte)(values[i] >> 16 & 0xFF);
            this.colors_[++index] = (byte)(values[i] >> 8 & 0xFF);
            this.colors_[++index] = (byte)(values[i] & 0xFF);
            colorBuffer[colornum] = values[i];
            ++colornum;
        }
        this.numColors_ = 1 << BitUtils.bitsNeeded(colornum);
        byte[] copy = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, copy, 0, this.numColors_ * 3);
        this.colors_ = copy;
    }

    final void tryToIndexedColor(int[] values, int minX, int minY, int maxX, int maxY, int backgroundColor) throws AWTException {
        int nPixel = this.width_ * this.height_;
        this.pixels_ = new byte[nPixel];
        this.colors_ = new byte[768];
        int[] colorBuffer = new int[256];
        int colornum = 0;
        boolean notfind = true;
        int t = 0;
        for (int y = 0; y < this.height_; ++y) {
            for (int x = 0; x < this.width_; ++x) {
                int search;
                int value;
                notfind = true;
                int i = y * this.width_ + x;
                if (y < minY || y >= maxY || x < minX || x >= maxX) {
                    value = backgroundColor;
                } else {
                    value = values[t];
                    ++t;
                }
                for (search = 0; search < colornum; ++search) {
                    if (colorBuffer[search] != value) continue;
                    this.pixels_[i] = (byte)search;
                    notfind = false;
                    break;
                }
                if (!notfind) continue;
                if (search > 255) {
                    throw new AWTException("too many color");
                }
                this.pixels_[i] = (byte)search;
                int index = search * 3;
                this.colors_[index] = (byte)(value >> 16 & 0xFF);
                this.colors_[++index] = (byte)(value >> 8 & 0xFF);
                this.colors_[++index] = (byte)(value & 0xFF);
                colorBuffer[colornum] = value;
                ++colornum;
            }
        }
        this.numColors_ = 1 << BitUtils.bitsNeeded(colornum);
        byte[] copy = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, copy, 0, this.numColors_ * 3);
        this.colors_ = copy;
    }
}

