/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.StringTokenizer;

public class AffineTransformText {
    public static void setRotateText(Graphics g, String text, double angle, Point pos, Font font, Color color) {
        String[] str = AffineTransformText.tokenizer(text);
        FontMetrics fm = g.getFontMetrics();
        int height = (fm.getMaxAscent() + fm.getMaxDescent()) * str.length;
        int width = AffineTransformText.getCharsWidth(str, fm);
        int degree = ((int)(angle * 180.0 / Math.PI) + 360) % 360;
        g.setFont(font);
        g.setColor(color);
        if (degree >= 0 && degree < 180) {
            ((Graphics2D)g).rotate(-angle, pos.x + width, pos.y);
        } else {
            ((Graphics2D)g).rotate(-angle, pos.x, pos.y);
        }
        int tmpX = pos.x;
        int tmpY = pos.y;
        if (degree >= 20 && degree <= 31) {
            tmpY -= (int)((double)width * Math.sin(angle * (double)(degree - 20) / 65.0));
        } else if (degree >= 32 && degree <= 40) {
            tmpY -= (int)((double)width * Math.sin(angle * (double)(degree - 25) / 65.0));
        } else if (degree > 40 && degree < 95) {
            tmpY -= (int)((double)width * Math.sin(angle * (double)(degree - 30) / 65.0));
            if (degree <= 70) {
                tmpX -= (int)((double)width * Math.sin(angle * (double)(degree - 40) / 50.0) / 2.0);
            } else if (degree > 70 && degree <= 85) {
                tmpX -= (int)((double)width * Math.sin(angle * (double)(degree - 40) / 50.0) * (1.0 - Math.sin(angle * (double)(degree - 40) / 50.0)));
            } else if (degree == 90) {
                tmpX -= height / 2;
            }
        } else if (degree >= 270 && degree < 315) {
            tmpX -= (int)((double)height * Math.sin(angle));
            tmpY += (int)((double)height * Math.sin(angle) * (1.2 * Math.sin(1.5707963267948966 * (double)(315 - degree) / 45.0)));
        } else if (degree >= 315 && degree < 360) {
            tmpX -= (int)((double)height * Math.sin(angle));
        }
        for (int i = 0; i < str.length; ++i) {
            g.drawString(str[i], tmpX, tmpY + (fm.getMaxAscent() + (fm.getMaxAscent() + fm.getMaxDescent()) * i));
        }
        if (degree >= 0 && degree < 180) {
            ((Graphics2D)g).rotate(angle, pos.x + width, pos.y);
        } else {
            ((Graphics2D)g).rotate(angle, pos.x, pos.y);
        }
    }

    private static int getCharsWidth(String[] list, FontMetrics fm) {
        int max = 0;
        for (String element : list) {
            int width = fm.charsWidth(element.toCharArray(), 0, element.length());
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    private static String[] tokenizer(String str) {
        String str2 = "";
        int len = str.length();
        boolean isSlash = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && !isSlash) {
                isSlash = true;
                continue;
            }
            if ((c == 'n' || c == 'r') && isSlash) {
                c = '\n';
            } else if (c != '\\' && isSlash) {
                str2 = str2 + '\\';
            }
            isSlash = false;
            str2 = str2 + c;
        }
        StringTokenizer st = new StringTokenizer(str2, "\r\n");
        if (st.countTokens() <= 0) {
            return new String[]{str};
        }
        int i = 0;
        String[] list = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            list[i++] = st.nextToken();
        }
        return list;
    }
}

