/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

public class Coder0 {
    static final int CONSTANT0 = 87;
    static final String errorStr = "ERROR";
    static final String defaultCodeStr = "U&*W8&^%^#T9vf,d.gm:<<P:lsa[ls[ws,anKJSjdksjfdsfjioKJ73280(**(&(*9>:KM:Lmdsl;dm;}{}7u05HB90-Ay_((7^*sU90iam989x203-9&*7*^a9832";

    public static String getDefaultCodeStr() {
        return defaultCodeStr;
    }

    public static String decode(String str) {
        return Coder0.decode(str, Coder0.getDefaultCodeStr());
    }

    public static String decode(String str, String code) {
        char[] strArray = str.toCharArray();
        int strSize = str.length();
        switch (strArray[strSize - 1]) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                if (strSize < 3) {
                    return errorStr;
                }
                return Coder0.decode(str.substring(0, strSize - 3), code, (char)(strArray[strSize - 1] - 97));
            }
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': {
                if (strSize < 5) {
                    return errorStr;
                }
                return Coder0.decode(str.substring(0, strSize - 5), code, (char)(strArray[strSize - 1] - 103));
            }
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': {
                if (strSize < 9) {
                    return errorStr;
                }
                return Coder0.decode(str.substring(0, strSize - 9), code, (char)(strArray[strSize - 1] - 109));
            }
        }
        return errorStr;
    }

    private static String decode(String str, String code, char group) {
        char tempChar;
        int i;
        int g_Offset;
        switch (group) {
            case '\u0001': {
                g_Offset = 42;
                break;
            }
            case '\u0002': {
                g_Offset = 84;
                break;
            }
            case '\u0003': {
                g_Offset = 126;
                break;
            }
            case '\u0004': {
                g_Offset = 168;
                break;
            }
            case '\u0005': {
                g_Offset = 210;
                break;
            }
            default: {
                g_Offset = 0;
            }
        }
        char A_Offset = (char)(g_Offset + 20);
        char[] strArray = str.toCharArray();
        int strSize = str.length();
        int reduceSpace = 0;
        for (i = 0; i < strSize; ++i) {
            tempChar = strArray[i];
            if (tempChar >= 'g' && tempChar <= 'z' || tempChar >= 'A' && tempChar <= 'Z') continue;
            ++reduceSpace;
            ++i;
        }
        int tempStrSize = strSize - reduceSpace;
        char[] tempStr = new char[tempStrSize];
        int gValue = 103 - g_Offset;
        int aValue = 65 - A_Offset;
        int tempStrIndex = 0;
        for (i = 0; i < strSize; ++i) {
            tempChar = strArray[i];
            if (tempChar >= 'g' && tempChar <= 'z') {
                tempStr[tempStrIndex] = (char)(tempChar - gValue);
            } else if (tempChar >= 'A' && tempChar <= 'Z') {
                tempStr[tempStrIndex] = (char)(tempChar - aValue);
            } else {
                tempStr[tempStrIndex] = Coder0.hexToChar(tempChar, strArray[i + 1]);
                ++i;
            }
            ++tempStrIndex;
        }
        char[] codeArray = code.toCharArray();
        int codeSize = code.length();
        for (i = 0; i < tempStrSize; ++i) {
            tempStr[i] = (char)(tempStr[i] ^ codeArray[i % codeSize]);
        }
        return new String(tempStr);
    }

    private static char hexToChar(char h1, char h2) {
        h1 = h1 >= 'a' && h1 <= 'f' ? (char)(h1 - 87) : (char)(h1 - 48);
        h2 = h2 >= 'a' && h2 <= 'f' ? (char)(h2 - 87) : (char)(h2 - 48);
        return (char)((h1 << 4) + h2);
    }
}

