/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.output.pdf.PdfGraphics2D;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.IWMFGraphics;
import quadbase.util.internal.SVGEncoder;

public class Composite {
    private static java.awt.Composite originalComposite = null;

    public static void setCompositeSrcOver(Graphics g, float alpha) {
        if (g instanceof IWMFGraphics) {
            return;
        }
        if (g instanceof PdfGraphics2D) {
            return;
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setCompositeSrcOver(alpha);
            return;
        }
        if (originalComposite == null && g instanceof Graphics2D) {
            originalComposite = ((Graphics2D)g).getComposite();
        }
        if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).setComposite(AlphaComposite.getInstance(3, 1.0f - alpha));
        } else {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f - alpha));
        }
    }

    public static void setCompositeSrcIn(Graphics g, float alpha) {
        if (g instanceof IWMFGraphics) {
            return;
        }
        if (g instanceof PdfGraphics2D) {
            return;
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setCompositeSrcOver(alpha);
            return;
        }
        if (originalComposite == null && g instanceof Graphics2D) {
            originalComposite = ((Graphics2D)g).getComposite();
        }
        if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).setComposite(AlphaComposite.getInstance(5, alpha));
        } else {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(5, alpha));
        }
    }

    public static void setOriginalComposite(Graphics g) {
        if (g instanceof IWMFGraphics) {
            return;
        }
        if (g instanceof PdfGraphics2D) {
            return;
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setOriginalComposite();
            return;
        }
        if (g instanceof IFlashGraphics) {
            if (originalComposite != null) {
                ((IFlashGraphics)((Object)g)).setComposite(originalComposite);
            }
        } else if (originalComposite != null) {
            ((Graphics2D)g).setComposite(originalComposite);
        }
    }

    public static Image getBufferedImage(Graphics g, int w, int h) {
        if (Composite.checkInstance(g)) {
            return null;
        }
        if (IOUtil.isSVGIncluded() && SVGEncoder.isSVGGraphics(g)) {
            return null;
        }
        return new BufferedImage(w, h, 2);
    }

    public static Graphics createGraphics(Graphics g, Image bufImage) {
        if (Composite.checkInstance(g)) {
            return g;
        }
        if (IOUtil.isSVGIncluded() && SVGEncoder.isSVGGraphics(g)) {
            return g;
        }
        Graphics2D newG = ((BufferedImage)bufImage).createGraphics();
        if (g instanceof Graphics2D) {
            newG.setRenderingHints(((Graphics2D)g).getRenderingHints());
        }
        return newG;
    }

    public static void drawImage(Graphics g, Image bufImage) {
        if (Composite.checkInstance(g)) {
            return;
        }
        if (IOUtil.isSVGIncluded() && SVGEncoder.isSVGGraphics(g)) {
            return;
        }
        ((Graphics2D)g).drawImage(bufImage, 0, 0, null);
    }

    private static boolean checkInstance(Graphics g) {
        return g instanceof IWMFGraphics || g instanceof IFlashGraphics || g instanceof IQbGraphics || g instanceof PdfGraphics2D;
    }

    private static Area intersect(Shape shape1, Shape shape2) {
        Area area1 = new Area(shape1);
        Area area2 = new Area(shape2);
        area1.intersect(area2);
        return area1;
    }

    public static void fillIntersect(Graphics g, Polygon shape1, double x, double y, double w) {
        Ellipse2D.Double shape2 = new Ellipse2D.Double(x, y, w, w);
        Area area = Composite.intersect(shape1, shape2);
        ((Graphics2D)g).fill(area);
    }

    public static void drawIntersect(Graphics g, Polygon shape1, double x, double y, double w, int thickness) {
        Ellipse2D.Double shape2 = new Ellipse2D.Double(x, y, w, w);
        Area area = Composite.intersect(shape1, shape2);
        Stroke orgStroke = ((Graphics2D)g).getStroke();
        BasicStroke basicStroke = new BasicStroke(thickness, 0, 0);
        ((Graphics2D)g).setStroke(basicStroke);
        ((Graphics2D)g).draw(area);
        ((Graphics2D)g).setStroke(orgStroke);
    }

    public static void setGradientPaint(Graphics g, int x1, int y1, Color color1, int x2, int y2, Color color2, boolean cyclic) {
        GradientPaint gradientPaint = new GradientPaint(x1, y1, color1, x2, y2, color2, cyclic);
        ((Graphics2D)g).setPaint(gradientPaint);
    }
}

