/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTime {
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int DYNAMIC = 7;
    public static final int MAX_UNITS = 7;

    public static long getDateVal(Date d, int unit, long value) {
        long dateVal = d.getTime();
        return DateTime.getDateVal(dateVal, unit, value);
    }

    public static Timestamp getTimestamp(long dateVal, int unit, long value) {
        return new Timestamp(DateTime.getDateVal(dateVal, unit, value));
    }

    public static long getDateVal(long dateVal, int unit, long value) {
        switch (unit) {
            case 0: {
                return dateVal + 1000L * value;
            }
            case 1: {
                return dateVal + 60000L * value;
            }
            case 2: {
                return dateVal + 3600000L * value;
            }
            case 3: {
                return dateVal + 86400000L * value;
            }
            case 4: {
                return dateVal + 604800000L * value;
            }
            case 5: {
                Date t = new Date(dateVal);
                t.setMonth(t.getMonth() + (int)value);
                return t.getTime();
            }
            case 6: {
                Date t = new Date(dateVal);
                t.setYear(t.getYear() + (int)value);
                return t.getTime();
            }
        }
        throw new IllegalArgumentException("Invalid time unit :" + unit);
    }

    public static final long getMilliseconds(int unit) {
        switch (unit) {
            case 0: {
                return 1000L;
            }
            case 1: {
                return 60000L;
            }
            case 2: {
                return 3600000L;
            }
            case 3: {
                return 86400000L;
            }
            case 4: {
                return 604800000L;
            }
            case 5: {
                return -1702967296L;
            }
            case 6: {
                return 1471228928L;
            }
        }
        throw new IllegalArgumentException("Invalid time unit :" + unit);
    }

    public static long getTotalSeconds(int number, int unit) {
        long value;
        switch (unit) {
            case 0: {
                value = number;
                break;
            }
            case 1: {
                value = number * 60;
                break;
            }
            case 2: {
                value = number * 60 * 60;
                break;
            }
            case 3: {
                value = number * 86400;
                break;
            }
            case 4: {
                value = number * 7 * 86400;
                break;
            }
            case 5: {
                value = number * 30 * 86400;
                break;
            }
            case 6: {
                value = number * 365 * 86400;
                break;
            }
            default: {
                value = 0L;
            }
        }
        return value;
    }

    public static Date approxDate(Date d0, int unit) {
        if (unit < 0 || unit > 7) {
            throw new IllegalArgumentException("Illegal time unit");
        }
        Date t = new Date(d0.getTime());
        switch (unit) {
            case 6: {
                t.setMonth(0);
            }
            case 4: 
            case 5: {
                long val;
                if (unit != 4) {
                    t.setDate(1);
                } else {
                    val = t.getTime();
                    t.setTime(val -= (long)(t.getDay() * 86400 * 1000));
                }
            }
            case 3: {
                t.setHours(0);
            }
            case 2: {
                t.setMinutes(0);
            }
            case 1: {
                t.setSeconds(0);
            }
            case 0: {
                long val = t.getTime() / 1000L * 1000L;
                t.setTime(val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time unit :" + unit);
            }
        }
        return t;
    }

    public static Date increment(int unit, int inc, Date startPt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startPt);
        switch (unit) {
            case 0: {
                cal.add(13, inc);
                break;
            }
            case 1: {
                cal.add(12, inc);
                break;
            }
            case 2: {
                cal.add(10, inc);
                break;
            }
            case 3: {
                cal.add(6, inc);
                break;
            }
            case 4: {
                cal.add(6, inc * 7);
                break;
            }
            case 5: {
                cal.add(2, inc);
                break;
            }
            case 6: {
                cal.add(1, inc);
            }
        }
        return cal.getTime();
    }

    public static int compare(int unit, Date obj1, Date obj2, int dataType) {
        int value = 0;
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(obj1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(obj2);
        switch (unit) {
            case 0: {
                if (DateTime.getSeconds(cal1) > DateTime.getSeconds(cal2)) {
                    ++value;
                }
                if (DateTime.getSeconds(cal1) < DateTime.getSeconds(cal2)) {
                    --value;
                }
            }
            case 1: {
                if (DateTime.getMinutes(cal1) > DateTime.getMinutes(cal2)) {
                    value += 10;
                }
                if (DateTime.getMinutes(cal1) < DateTime.getMinutes(cal2)) {
                    value -= 10;
                }
            }
            case 2: {
                try {
                    if (DateTime.getHours(cal1) > DateTime.getHours(cal2)) {
                        value += 100;
                    }
                    if (DateTime.getHours(cal1) < DateTime.getHours(cal2)) {
                        value -= 100;
                    }
                    if (dataType == 9) {
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 3: {
                try {
                    if (DateTime.getDate(cal1) > DateTime.getDate(cal2)) {
                        value += 500;
                    }
                    if (DateTime.getDate(cal1) < DateTime.getDate(cal2)) {
                        value -= 500;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 4: {
                try {
                    if (DateTime.getWeek(cal1) > DateTime.getWeek(cal2)) {
                        value += 1500;
                    }
                    if (DateTime.getWeek(cal1) < DateTime.getWeek(cal2)) {
                        value -= 1500;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 5: {
                try {
                    if (DateTime.getMonth(cal1) > DateTime.getMonth(cal2)) {
                        value += 2500;
                    }
                    if (DateTime.getMonth(cal1) < DateTime.getMonth(cal2)) {
                        value -= 2500;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 6: {
                try {
                    if (DateTime.getYear(cal1) > DateTime.getYear(cal2)) {
                        value += 5000;
                    }
                    if (DateTime.getYear(cal1) >= DateTime.getYear(cal2)) break;
                    value -= 5000;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    static int getSeconds(Calendar cal) {
        return cal.get(13);
    }

    static int getMinutes(Calendar cal) {
        return cal.get(12);
    }

    static int getHours(Calendar cal) {
        return cal.get(11);
    }

    static int getWeek(Calendar cal) {
        return cal.get(8);
    }

    static int getDate(Calendar cal) {
        return cal.get(5);
    }

    static int getMonth(Calendar cal) {
        return cal.get(2);
    }

    static int getYear(Calendar cal) {
        return cal.get(1);
    }

    public static int getAutoScaleUnit(Date t1, Date t2) {
        long upperLimit;
        long oneMIN = 60000L;
        long oneHR = oneMIN * 60L;
        long oneDay = oneHR * 24L;
        long lowerLimit = t1.getTime();
        if (lowerLimit > (upperLimit = t2.getTime())) {
            upperLimit = lowerLimit;
            lowerLimit = t2.getTime();
        }
        if (upperLimit - lowerLimit > 2L * oneDay * 365L) {
            return 6;
        }
        if (upperLimit - lowerLimit > 2L * oneDay * 30L) {
            return 5;
        }
        if (upperLimit - lowerLimit > 28L * oneDay) {
            return 4;
        }
        if (upperLimit - lowerLimit > 2L * oneDay) {
            return 3;
        }
        if (upperLimit - lowerLimit > oneHR * 2L) {
            return 2;
        }
        if (upperLimit - lowerLimit > oneMIN * 2L) {
            return 1;
        }
        return 0;
    }
}

