/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import quadbase.chart.Chart;

public class ExcelEncoder {
    public void export(Chart chart, OutputStream out, int width, int height) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(2048);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        chart.draw(graphics, new Panel(), width, height);
        graphics.dispose();
        ImageIO.write((RenderedImage)image, "png", bout);
        HSSFWorkbook wb = new HSSFWorkbook();
        CreationHelper helper = wb.getCreationHelper();
        int pictureIdx = wb.addPicture(bout.toByteArray(), 6);
        Sheet sheet = wb.createSheet();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(0);
        anchor.setRow1(0);
        Picture pict = drawing.createPicture(anchor, pictureIdx);
        pict.resize();
        wb.write(out);
    }
}

