/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImageResample {
    Image image;
    int inwidth;
    int inheight;
    int[] inpixels;

    public ImageResample(Image image) {
        this.image = image;
        this.inwidth = image.getWidth(null);
        this.inheight = image.getHeight(null);
        this.inpixels = new int[this.inwidth * this.inheight];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.inwidth, this.inheight, this.inpixels, 0, this.inwidth);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException("Grabber return false :" + grabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public Image resample(int outwidth, int outheight) {
        double dt;
        int p2;
        int p1;
        int j;
        double t;
        int i;
        int lastj;
        int k;
        int[] pixels = new int[outwidth * this.inheight];
        int red1 = 0;
        int green1 = 0;
        int blue1 = 0;
        int alpha1 = 0;
        int dr = 0;
        int dg = 0;
        int db = 0;
        int da = 0;
        double ratio = (double)(this.inwidth - 1) / (double)(outwidth - 1);
        int w = this.inwidth - 1;
        for (k = 0; k < this.inheight; ++k) {
            int inlen = k * this.inwidth;
            int outlen = k * outwidth;
            lastj = -1;
            for (i = 0; i < outwidth; ++i) {
                t = (double)i * ratio;
                j = (int)t;
                if (j != lastj) {
                    p1 = this.inpixels[inlen + j];
                    red1 = p1 & 0xFF;
                    green1 = p1 >> 8 & 0xFF;
                    blue1 = p1 >> 16 & 0xFF;
                    alpha1 = p1 >>> 24 & 0xFF;
                    if (j < w) {
                        p2 = this.inpixels[inlen + j + 1];
                        dr = (p2 & 0xFF) - red1;
                        dg = (p2 >> 8 & 0xFF) - green1;
                        db = (p2 >> 16 & 0xFF) - blue1;
                        da = (p2 >>> 24 & 0xFF) - alpha1;
                    } else {
                        da = 0;
                        db = 0;
                        dg = 0;
                        dr = 0;
                    }
                    lastj = j;
                }
                dt = t - (double)j;
                pixels[outlen + i] = (int)(dt * (double)da + (double)alpha1) << 24 & 0xFF000000 | (int)(dt * (double)dr + (double)red1) & 0xFF | (int)(dt * (double)dg + (double)green1) << 8 & 0xFF00 | (int)(dt * (double)db + (double)blue1) << 16 & 0xFF0000;
            }
        }
        this.inpixels = null;
        int[] outpixels = new int[outwidth * outheight];
        ratio = (double)(this.inheight - 1) / (double)(outheight - 1);
        w = this.inheight - 1;
        for (k = 0; k < outwidth; ++k) {
            lastj = -1;
            for (i = 0; i < outheight; ++i) {
                t = (double)i * ratio;
                j = (int)t;
                if (j != lastj) {
                    p1 = pixels[j * outwidth + k];
                    red1 = p1 & 0xFF;
                    green1 = p1 >> 8 & 0xFF;
                    blue1 = p1 >> 16 & 0xFF;
                    alpha1 = p1 >>> 24 & 0xFF;
                    if (j < w) {
                        p2 = pixels[(j + 1) * outwidth + k];
                        dr = (p2 & 0xFF) - red1;
                        dg = (p2 >> 8 & 0xFF) - green1;
                        db = (p2 >> 16 & 0xFF) - blue1;
                        da = (p2 >>> 24 & 0xFF) - alpha1;
                    } else {
                        da = 0;
                        db = 0;
                        dg = 0;
                        dr = 0;
                    }
                    lastj = j;
                }
                dt = t - (double)j;
                outpixels[i * outwidth + k] = (int)(dt * (double)da + (double)alpha1) << 24 & 0xFF000000 | (int)(dt * (double)dr + (double)red1) & 0xFF | (int)(dt * (double)dg + (double)green1) << 8 & 0xFF00 | (int)(dt * (double)db + (double)blue1) << 16 & 0xFF0000;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(outwidth, outheight, outpixels, 0, outwidth));
    }
}

