/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.math.BigDecimal;
import quadbase.util.internal.ICompareObject;

public class NumberCompare
implements ICompareObject {
    Number value;
    boolean isBigDecimal;
    int index;

    public NumberCompare(Number value) {
        this.value = value;
        this.isBigDecimal = value instanceof BigDecimal;
    }

    public NumberCompare(Number value, int index) {
        this.value = value;
        this.isBigDecimal = value instanceof BigDecimal;
        this.index = index;
    }

    @Override
    public boolean greaterThan(boolean isAsc, ICompareObject target) {
        if (this.value == null && (target == null || target.getValue() == null)) {
            return false;
        }
        if (this.value == null) {
            return !isAsc;
        }
        if (target == null || target.getValue() == null) {
            return isAsc;
        }
        if (this.isBigDecimal) {
            return isAsc ? ((BigDecimal)this.value).compareTo((BigDecimal)target.getValue()) > 0 : ((BigDecimal)target.getValue()).compareTo((BigDecimal)this.value) > 0;
        }
        return isAsc ? this.value.floatValue() > ((Number)target.getValue()).floatValue() : ((Number)target.getValue()).floatValue() > this.value.floatValue();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

