/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import quadbase.util.internal.ICompareObject;

public class SortObject {
    public static Object[] sort(ICompareObject[] target, boolean isAsc) {
        SortObject.start(target, isAsc);
        int nTarget = target.length;
        Object[] result = new Object[nTarget];
        for (int i = 0; i < nTarget; ++i) {
            result[i] = target[i].getValue();
        }
        return result;
    }

    public static int[] sortIndex(ICompareObject[] target, boolean isAsc) {
        SortObject.start(target, isAsc);
        int nTarget = target.length;
        int[] result = new int[nTarget];
        for (int i = 0; i < nTarget; ++i) {
            result[i] = target[i].getIndex();
        }
        return result;
    }

    private static void quickSort(ICompareObject[] a, int lo0, int hi0, boolean isAsc) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            ICompareObject mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && mid.greaterThan(isAsc, a[lo])) {
                    ++lo;
                }
                while (hi > lo0 && a[hi].greaterThan(isAsc, mid)) {
                    --hi;
                }
                if (lo > hi) continue;
                SortObject.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                SortObject.quickSort(a, lo0, hi, isAsc);
            }
            if (lo < hi0) {
                SortObject.quickSort(a, lo, hi0, isAsc);
            }
        }
    }

    private static void swap(ICompareObject[] a, int i, int j) {
        ICompareObject T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private static void start(ICompareObject[] a, boolean isAsc) {
        SortObject.quickSort(a, 0, a.length - 1, isAsc);
    }
}

