/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.util.Vector;
import quadbase.chart.ColData;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;

public class TransposeRS
implements IResultSet,
IRSMetaData {
    int ncol = 3;
    IResultSet inFormat;
    int inFormatnCol;
    String[] colNames;
    String[] tableNames;
    int[] colTypes;
    Object[] seriesNames;
    int colCursor = -1;
    Object[] currentRowLabel;
    boolean[] doTranspose;
    int[] transposeCol;

    public static IResultSet doTranspose(IResultSet inRS) throws Exception {
        return TransposeRS.doTranspose(inRS, TransposeRS.getDefaultTransposeColumn(inRS));
    }

    public static IResultSet doTranspose(IResultSet inRS, boolean[] doTranspose) throws Exception {
        TransposeRS outRS = new TransposeRS(inRS, doTranspose);
        return outRS;
    }

    public static IResultSet doTranspose(ColData[] dataSet) throws Exception {
        return TransposeRS.doTranspose(dataSet, TransposeRS.getDefaultTransposeColumn(dataSet.length - 1));
    }

    public static IResultSet doTranspose(ColData[] dataSet, boolean[] doTranspose) throws Exception {
        IResultSet inRS = ColData.getResultSet(dataSet);
        return TransposeRS.doTranspose(inRS, doTranspose);
    }

    public TransposeRS(IResultSet inFormat, boolean[] doTranspose) throws Exception {
        doTranspose = TransposeRS.getTransposeColumn(inFormat.getMetaData().getColumnCount(), doTranspose);
        boolean needConvertToDouble = false;
        if (!TransposeRS.isCorrectType(inFormat, doTranspose)) {
            needConvertToDouble = true;
        }
        this.doTranspose = doTranspose;
        this.transposeCol = new int[TransposeRS.countTransposeColumn(doTranspose)];
        int ct = 0;
        for (int i = 0; i < doTranspose.length; ++i) {
            if (!doTranspose[i]) continue;
            this.transposeCol[ct++] = i;
        }
        this.ncol = doTranspose.length - this.transposeCol.length + 2;
        IRSMetaData md = inFormat.getMetaData();
        this.inFormatnCol = md.getColumnCount();
        this.colNames = new String[this.ncol];
        this.tableNames = new String[this.ncol];
        this.colTypes = new int[this.ncol];
        this.seriesNames = new Object[this.transposeCol.length];
        int j = 0;
        int k = 0;
        for (int i = 0; i < doTranspose.length; ++i) {
            if (!doTranspose[i]) {
                this.colNames[j] = md.getColumnName(i + 1);
                this.tableNames[j] = md.getTableName(i + 1);
                this.colTypes[j++] = md.getColumnType(i + 1);
                continue;
            }
            this.colTypes[this.colNames.length - 1] = md.getColumnType(i + 1);
            this.seriesNames[k++] = md.getColumnName(i + 1);
        }
        if (needConvertToDouble) {
            this.colTypes[this.colNames.length - 1] = 8;
        }
        this.colNames[this.colNames.length - 2] = "ColumnLabel";
        this.colNames[this.colNames.length - 1] = "Value";
        this.colTypes[this.colNames.length - 2] = 12;
        TransposeRS.bestMap(this.seriesNames, this.colTypes);
        this.inFormat = inFormat;
    }

    public static void bestMap(Object[] seriesNames, int[] colTypes) {
        boolean changeToInteger = true;
        int nSeriesNames = seriesNames.length;
        Number[] tempNames = new Integer[nSeriesNames];
        for (int i = 0; i < nSeriesNames; ++i) {
            try {
                tempNames[i] = Integer.valueOf((String)seriesNames[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                changeToInteger = false;
                break;
            }
        }
        if (changeToInteger) {
            colTypes[colTypes.length - 2] = 4;
            seriesNames = tempNames;
            return;
        }
        boolean changeToDouble = true;
        tempNames = new Double[nSeriesNames];
        for (int i = 0; i < nSeriesNames; ++i) {
            try {
                tempNames[i] = Double.valueOf((String)seriesNames[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                changeToDouble = false;
                break;
            }
        }
        if (changeToDouble) {
            colTypes[1] = 8;
            seriesNames = tempNames;
            return;
        }
    }

    public static int countTransposeColumn(boolean[] doTranspose) {
        int ct = 0;
        for (boolean element : doTranspose) {
            if (!element) continue;
            ++ct;
        }
        return ct;
    }

    @Override
    public boolean next() throws Exception {
        if (this.colCursor == -1) {
            this.colCursor = 0;
            boolean nextRow = this.inFormat.next();
            if (nextRow) {
                if (((String)this.seriesNames[this.colCursor]).startsWith("EMPTY_COL")) {
                    return this.next();
                }
                return true;
            }
            return false;
        }
        ++this.colCursor;
        if (this.colCursor < this.transposeCol.length) {
            if (((String)this.seriesNames[this.colCursor]).startsWith("EMPTY_COL")) {
                return this.next();
            }
            return true;
        }
        boolean more = this.inFormat.next();
        if (more) {
            this.colCursor = 0;
            this.currentRowLabel = null;
        }
        return more;
    }

    @Override
    public void close() throws Exception {
        this.inFormat.close();
    }

    @Override
    public IRSMetaData getMetaData() {
        return this;
    }

    @Override
    public Object getObject(int colNo) throws Exception {
        if (colNo <= 0 || colNo > this.ncol) {
            throw new IllegalArgumentException("Column number must be greater than 0 and less than 4");
        }
        if (this.colCursor == -1) {
            throw new IllegalArgumentException("Must call next() method first");
        }
        if (this.currentRowLabel == null) {
            this.currentRowLabel = new Object[this.inFormatnCol - this.seriesNames.length];
            int k = 0;
            for (int i = 1; i <= this.inFormatnCol; ++i) {
                if (this.doTranspose[i - 1]) continue;
                this.currentRowLabel[k++] = this.inFormat.getObject(i);
            }
        }
        if (colNo == this.ncol - 1) {
            return this.seriesNames[this.colCursor];
        }
        if (colNo == this.ncol) {
            return this.inFormat.getObject(this.transposeCol[this.colCursor] + 1);
        }
        return this.currentRowLabel[colNo - 1];
    }

    @Override
    public int getColumnCount() {
        return this.ncol;
    }

    @Override
    public String getColumnName(int col) throws Exception {
        if (col <= 0 || col > this.ncol) {
            throw new IllegalArgumentException("Column number must be greater than 0 and less than 4");
        }
        return this.colNames[col - 1];
    }

    @Override
    public String getTableName(int col) throws Exception {
        if (col <= 0 || col > this.ncol) {
            throw new IllegalArgumentException("Column number must be greater than 0 and less than 4");
        }
        return this.tableNames[col - 1];
    }

    @Override
    public int getColumnType(int col) throws Exception {
        if (col <= 0 || col > this.ncol) {
            throw new IllegalArgumentException("Column number must be greater than 0 and less than 4");
        }
        return this.colTypes[col - 1];
    }

    public static boolean isCorrectType(IResultSet inFormat, boolean[] doTranspose) throws Exception {
        doTranspose = TransposeRS.getTransposeColumn(inFormat.getMetaData().getColumnCount(), doTranspose);
        IRSMetaData md = inFormat.getMetaData();
        if (md == null) {
            throw new IllegalArgumentException("IRSMetaData returned by input format cannot be null");
        }
        int count = md.getColumnCount();
        if (count < 2) {
            throw new IllegalArgumentException("Input format must have at leat one data series column");
        }
        int type = -5;
        for (int i = 0; i < count; ++i) {
            if (!doTranspose[i] || md.getColumnName(i + 1).startsWith("EMPTY_COL")) continue;
            if (type == -5) {
                type = md.getColumnType(i + 1);
                continue;
            }
            if (type == md.getColumnType(i + 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCorrectType(ColData[] colData) {
        return TransposeRS.isCorrectType(colData, TransposeRS.getDefaultTransposeColumn(colData.length));
    }

    public static boolean isCorrectType(ColData[] colData, boolean[] doTranspose) {
        doTranspose = TransposeRS.getTransposeColumn(colData.length - 1, doTranspose);
        if (colData.length - 1 < 2) {
            return false;
        }
        int dataType = -5;
        for (int i = 0; i < colData.length - 1; ++i) {
            if (!doTranspose[i] || colData[i].getName().startsWith("EMPTY_COL")) continue;
            if (dataType == -5) {
                dataType = colData[i].getDataType();
                continue;
            }
            if (colData[i].getDataType() == dataType) continue;
            return false;
        }
        return true;
    }

    private static boolean[] getDefaultTransposeColumn(IResultSet inRS) throws Exception {
        return TransposeRS.getDefaultTransposeColumn(inRS.getMetaData().getColumnCount());
    }

    public static boolean[] getDefaultTransposeColumn(int len) {
        boolean[] tmp = new boolean[len];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = i != 0;
        }
        return tmp;
    }

    private static boolean[] getTransposeColumn(int len, boolean[] doTranspose) {
        if (doTranspose == null) {
            return TransposeRS.getDefaultTransposeColumn(len);
        }
        if (len == doTranspose.length) {
            return doTranspose;
        }
        boolean[] tmp = new boolean[len];
        for (int i = 0; i < len; ++i) {
            tmp[i] = i < doTranspose.length ? doTranspose[i] : false;
        }
        return tmp;
    }

    public static boolean[] getTransposeColumn(int[] transposeCol) {
        if (transposeCol == null) {
            return null;
        }
        int max = -1;
        for (int element : transposeCol) {
            if (element <= max) continue;
            max = element;
        }
        if (max < 0) {
            return null;
        }
        boolean[] tmp = new boolean[max + 1];
        for (int i = 0; i < transposeCol.length; ++i) {
            tmp[transposeCol[i]] = true;
        }
        return tmp;
    }

    public static int[] getTransposeIndex(boolean[] transposeCol) {
        if (transposeCol == null) {
            return null;
        }
        Vector<Integer> vec = new Vector<Integer>();
        for (int i = 0; i < transposeCol.length; ++i) {
            if (!transposeCol[i]) continue;
            vec.addElement(i);
        }
        int[] tmp = new int[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            tmp[i] = (Integer)vec.elementAt(i);
        }
        return tmp;
    }
}

