package CDWithModifiedBars;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import quadbase.chart.designer.QbChartDesigner;

public class CDWithModifiedBars extends Applet implements ActionListener {
	static final long serialVersionUID = 1; 
	public QbChartDesigner designer;
	JMenuItem newItem;

	public static void main(java.lang.String[] args) {

		try {

			CDWithModifiedBars doReport = new CDWithModifiedBars();
			doReport.doCustomizeDesignerMenuApplet(null);

		} catch (Exception ex) { ex.printStackTrace(); }

	}

	public void init()  {

		try {

			doCustomizeDesignerMenuApplet(this);
			setLayout(new BorderLayout());
			Panel panel = new Panel();
			panel.setLayout(new BorderLayout());
			panel.add("Center", new Label("LOADING"));
			add("Center", panel);

		} catch (Exception ex) { ex.printStackTrace(); }

	}

	public void doCustomizeDesignerMenuApplet(Object parent) throws Exception {
		QbChartDesigner.setServerAddress("127.0.0.1");
		QbChartDesigner.setServerPortNumber(22071);

		// these folders are located in the <InstallDir> directory. Change the paths to absolute paths, or paths relative to this application.
		String[] imagesPath = {"images", "backgroundImages"};
		
		designer = new QbChartDesigner(parent, "CDWithModifiedBars.cht", imagesPath);

		//	Add a new menu item
		JMenuBar menuBar = designer.getChartMenuBar();
		JMenu fileMenu = menuBar.getMenu(0);
		newItem = new JMenuItem("Hello World");
		newItem.addActionListener(this);
		fileMenu.insert(newItem, 7);

		//	Remove toolbar buttons
		JToolBar designBar = designer.getChartToolBar();
		designBar.remove(5);				// Remove Separator
		designBar.remove(4);				// Remove Export
		designer.setSaveOnExitEnabled(false);  // Do not prompt to save the chart if unsaved on exiting Designer
		designer.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {

		/*** save report **********/
		designer.save("CDWithModifiedBars_Temp.cht");
		/**** create new testing frame *********/
		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(new JLabel("Hello World!"), "Center");
		JFrame frame = new JFrame();
		frame.setContentPane(contentPane);
		frame.pack();
		frame.setVisible(true);
	}
}