import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;

import quadbase.ChartAPI.ColInfo;
import quadbase.ChartAPI.DbData;
import quadbase.ChartAPI.QbChart;
import quadbase.util.IDataSource;
import quadbase.util.IResultSet;

public class CustomClassData extends Applet implements IDataSource {
	static final long serialVersionUID = 1; 
	QbChart chart = null;

//	Setting DbData for passing data as arguments
	String dataType[] = {"string", "String", "double"};
	String fieldName[] = {"Destination",  "Time", "Price"};
	String records[][] = {{"Mayfair",  "13:43", "3.50"},
			{"Bond Street", "13:37", "3.75"},
			{"RickmansWorth", "13:12", "5.25"},
			{"Picadilly",  "13:24", "3.00"}};

	DbData data = new DbData(dataType, fieldName, records);

//	create a empty constructor
	public CustomClassData() {};

//	implement getResultSet
	public IResultSet getResultSet() {

		return data;

	}

	public static void main(java.lang.String[] args) {

		try {

			Frame frame = new Frame();
			CustomClassData doChart = new CustomClassData();
			frame.setLayout(new BorderLayout());
			frame.add("Center", doChart.createChart(null));
			frame.setSize(500, 500);
			frame.setVisible(true);

		} catch (Exception ex) {

			ex.printStackTrace();

		}

	}

	public void init()  {

		setLayout(new BorderLayout());
		add("Center", createChart(this));

	}

	Component createChart(Applet parent)  {

//		Do not Connect to EspressManager
		QbChart.setEspressManagerUsed(false);

		ColInfo colInfo = new ColInfo();
		colInfo.category = 0;
		colInfo.value = 2;
		try {

			chart = new QbChart(parent, QbChart.VIEW2D, QbChart.BAR, QbChart.CLASSFILE,
					"CustomClassData", false, colInfo, null);

		} catch (Exception ex) {

			ex.printStackTrace();

		}
		return chart;

	}

}