import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import quadbase.reportdesigner.ReportAPI.DbData;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.ReportViewer.Viewer;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IDataSource;
import quadbase.reportdesigner.util.IResultSet;

public class CustomClassDataER extends Applet implements IDataSource {
	static final long serialVersionUID = 1;
	QbReport report = null;

	// Setting DbData for passing data as arguments
	String dataType[] = { "string", "String", "double" };
	String fieldName[] = { "Destination", "Time", "Price" };
	String records[][] = { { "Mayfair", "13:43", "3.50" },
			{ "Bond Street", "13:37", "3.75" },
			{ "RickmansWorth", "13:12", "5.25" },
			{ "Picadilly", "13:24", "3.00" } };
	DbData data = new DbData(dataType, fieldName, records);

	// create a empty constructor
	public CustomClassDataER() {
	};

	// implement getResultSet
	public IResultSet getResultSet()
	{
		return data;
	}

	public static void main(java.lang.String[] args) {
		try {
			Frame frame = new Frame();
			CustomClassDataER doReport = new CustomClassDataER();
			frame.setLayout(new BorderLayout());
			frame.add("Center", doReport.createReport(frame));
			frame.setSize(900, 800);
			frame.addWindowListener(new WindowAdapter() {
				@Override
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			});
			frame.setVisible(true);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void init() {
		setLayout(new BorderLayout());
		add("Center", createReport(this));
	}

	Component createReport(Object parent) {
		QbReport.setEspressManagerUsed(false);
		// Create the colinfo array to be used in the QbReport constructor
		ColInfo colInfo[] = new ColInfo[3];
		for (int i = 0; i < colInfo.length; i++) {
			colInfo[i] = new ColInfo(i);
		}

		try {
			report = new QbReport(parent, QbReport.COLUMNAR, QbReport.CLASSFILE, "CustomClassData",
					colInfo, null);
		} catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return (new Viewer().getComponent(report));
	}
}